/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.client;

import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.java.client.impl.ZeroCFABuilderFactory;
import com.ibm.wala.cast.java.ipa.callgraph.AstJavaZeroXCFABuilder;
import com.ibm.wala.cast.java.ipa.callgraph.JavaSourceAnalysisScope;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.io.FileProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;

public abstract class JavaSourceAnalysisEngine
extends AbstractAnalysisEngine<InstanceKey, CallGraphBuilder<InstanceKey>, Void> {
    private final Set<Module> userEntries = HashSetFactory.make();
    private final Set<Module> sourceEntries = HashSetFactory.make();
    private final Set<Module> systemEntries = HashSetFactory.make();

    public void addSourceModule(Module M) {
        this.sourceEntries.add(M);
    }

    public void addCompiledModule(Module M) {
        this.userEntries.add(M);
    }

    public void addSystemModule(Module M) {
        this.systemEntries.add(M);
    }

    @Override
    protected void addApplicationModulesToScope() {
        ClassLoaderReference app = this.scope.getApplicationLoader();
        for (Module M : this.userEntries) {
            this.scope.addToScope(app, M);
        }
        ClassLoaderReference src = ((JavaSourceAnalysisScope)this.scope).getSourceLoader();
        for (Module M : this.sourceEntries) {
            this.scope.addToScope(src, M);
        }
    }

    @Override
    public void buildAnalysisScope() throws IOException {
        this.scope = this.makeSourceAnalysisScope();
        if (this.getExclusionsFile() != null) {
            try (InputStream is = new File(this.getExclusionsFile()).exists() ? new FileInputStream(this.getExclusionsFile()) : FileProvider.class.getClassLoader().getResourceAsStream(this.getExclusionsFile());){
                this.scope.setExclusions(new FileOfClasses(is));
            }
        }
        for (Module M : this.systemEntries) {
            this.scope.addToScope(this.scope.getPrimordialLoader(), M);
        }
        this.addApplicationModulesToScope();
    }

    protected AnalysisScope makeSourceAnalysisScope() {
        return new JavaSourceAnalysisScope();
    }

    protected abstract ClassLoaderFactory getClassLoaderFactory(SetOfClasses var1);

    @Override
    public IClassHierarchy buildClassHierarchy() {
        ClassHierarchy cha = null;
        ClassLoaderFactory factory = this.getClassLoaderFactory(this.scope.getExclusions());
        try {
            cha = ClassHierarchyFactory.make(this.getScope(), factory);
        }
        catch (ClassHierarchyException e) {
            System.err.println("Class Hierarchy construction failed");
            System.err.println(e.toString());
            e.printStackTrace();
        }
        return cha;
    }

    @Override
    protected Iterable<Entrypoint> makeDefaultEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        return Util.makeMainEntrypoints(JavaSourceAnalysisScope.SOURCE, cha);
    }

    @Override
    public IAnalysisCacheView makeDefaultCache() {
        return new AnalysisCacheImpl(AstIRFactory.makeDefaultFactory(), this.getOptions().getSSAOptions());
    }

    @Override
    public AnalysisOptions getOptions() {
        AnalysisOptions options = super.getOptions();
        SSAOptions so = options.getSSAOptions();
        so.setDefaultValues(SymbolTable::getDefaultValue);
        return options;
    }

    @Override
    public AnalysisOptions getDefaultOptions(Iterable<Entrypoint> entrypoints) {
        AnalysisOptions options = new AnalysisOptions(this.getScope(), entrypoints);
        SSAOptions ssaOptions = new SSAOptions();
        ssaOptions.setDefaultValues(SymbolTable::getDefaultValue);
        options.setSSAOptions(ssaOptions);
        return options;
    }

    @Override
    protected AstJavaZeroXCFABuilder getCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
        return new ZeroCFABuilderFactory().make(options, cache, cha, this.scope);
    }
}

