/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.loader;

import com.ibm.wala.cast.ir.ssa.AssignInstruction;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstEchoInstruction;
import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.AstPropertyRead;
import com.ibm.wala.cast.ir.ssa.AstPropertyWrite;
import com.ibm.wala.cast.ir.ssa.AstYieldInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementGetInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementHasNextInstruction;
import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.java.loader.Util;
import com.ibm.wala.cast.java.ssa.AstJavaInstructionFactory;
import com.ibm.wala.cast.java.ssa.AstJavaInvokeInstruction;
import com.ibm.wala.cast.java.ssa.AstJavaNewEnclosingInstruction;
import com.ibm.wala.cast.java.ssa.EnclosingObjectReference;
import com.ibm.wala.cast.java.translator.SourceModuleTranslator;
import com.ibm.wala.cast.loader.AstClass;
import com.ibm.wala.cast.loader.AstField;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstAnnotation;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.ClassLoaderImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JavaLanguage;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JavaSourceLoaderImpl
extends ClassLoaderImpl {
    public Map<CAstEntity, IClass> fTypeMap = HashMapFactory.make();
    private final boolean existsCommonSuperclass;
    public static volatile boolean deleteTypeMapAfterInit = true;
    protected static final InstructionFactory insts = new InstructionFactory();

    protected Collection<Annotation> getAnnotations(CAstEntity e) {
        Collection<CAstAnnotation> annotations = e.getAnnotations();
        if (annotations == null || annotations.isEmpty()) {
            return null;
        }
        HashSet<Annotation> result = HashSetFactory.make();
        for (CAstAnnotation ca : annotations) {
            TypeName walaTypeName = JavaSourceLoaderImpl.toWALATypeName(ca.getType());
            TypeReference ref = TypeReference.findOrCreate(this.getReference(), walaTypeName);
            if (ca.getArguments() == null || ca.getArguments().isEmpty()) {
                result.add(Annotation.make(ref));
                continue;
            }
            HashMap<String, AnnotationsReader.ElementValue> args = HashMapFactory.make();
            for (Map.Entry<String, Object> a : ca.getArguments().entrySet()) {
                args.put(a.getKey(), new AnnotationsReader.ConstantElementValue(a.getValue()));
            }
            result.add(Annotation.makeWithNamed(ref, args));
        }
        return result;
    }

    public static int mapToInt(Collection<CAstQualifier> qualifiers) {
        int result = 0;
        for (CAstQualifier q : qualifiers) {
            if (q == CAstQualifier.PUBLIC) {
                result |= 1;
            }
            if (q == CAstQualifier.PROTECTED) {
                result |= 4;
            }
            if (q == CAstQualifier.PRIVATE) {
                result |= 2;
            }
            if (q == CAstQualifier.STATIC) {
                result |= 8;
            }
            if (q == CAstQualifier.FINAL) {
                result |= 0x10;
            }
            if (q == CAstQualifier.SYNCHRONIZED) {
                result |= 0x20;
            }
            if (q == CAstQualifier.TRANSIENT) {
                result |= 0x80;
            }
            if (q == CAstQualifier.NATIVE) {
                result |= 0x100;
            }
            if (q == CAstQualifier.INTERFACE) {
                result |= 0x200;
            }
            if (q == CAstQualifier.ABSTRACT) {
                result |= 0x400;
            }
            if (q == CAstQualifier.VOLATILE) {
                result |= 0x40;
            }
            if (q != CAstQualifier.STRICTFP) continue;
            result |= 0x800;
        }
        return result;
    }

    public JavaSourceLoaderImpl(boolean existsCommonSuperClass, ClassLoaderReference loaderRef, IClassLoader parent, IClassHierarchy cha) {
        super(loaderRef, cha.getScope().getArrayClassLoader(), parent, cha.getScope().getExclusions(), cha);
        this.existsCommonSuperclass = existsCommonSuperClass;
    }

    public JavaSourceLoaderImpl(ClassLoaderReference loaderRef, IClassLoader parent, IClassHierarchy cha) {
        this(true, loaderRef, parent, cha);
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    @Override
    protected void loadAllSources(Set<ModuleEntry> modules) {
        this.getTranslator().loadAllSources(modules);
    }

    protected abstract SourceModuleTranslator getTranslator();

    @Override
    public void init(List<Module> modules) throws IOException {
        super.init(modules);
        if (deleteTypeMapAfterInit) {
            this.fTypeMap = null;
        }
    }

    public void defineFunction(CAstEntity n, IClass owner, AbstractCFG<?, ?> cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock<SSAInstruction>, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
        ((JavaClass)owner).addMethod(n, owner, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo);
    }

    public void defineAbstractFunction(CAstEntity n, IClass owner) {
        ((JavaClass)owner).addMethod(n, owner);
    }

    public void defineField(CAstEntity n, IClass owner) {
        ((JavaClass)owner).addField(n);
    }

    protected static TypeName toWALATypeName(CAstType type) {
        return TypeName.string2TypeName(type.getName());
    }

    public IClass defineType(CAstEntity type, String typeName, CAstEntity owner) {
        ArrayList<TypeName> superTypeNames = new ArrayList<TypeName>();
        for (CAstType superType : type.getType().getSupertypes()) {
            superTypeNames.add(JavaSourceLoaderImpl.toWALATypeName(superType));
        }
        JavaClass javaClass = new JavaClass(typeName, superTypeNames, type.getPosition(), type.getQualifiers(), this, owner != null ? (JavaClass)this.fTypeMap.get(owner) : (JavaClass)null, this.getAnnotations(type));
        if (this.getParent().lookupClass(javaClass.getName()) != null) {
            return null;
        }
        this.fTypeMap.put(type, javaClass);
        this.loadedClasses.put(javaClass.getName(), javaClass);
        return javaClass;
    }

    @Override
    public String toString() {
        return "Java Source Loader (classes " + this.loadedClasses.values() + ')';
    }

    @Override
    public InstructionFactory getInstructionFactory() {
        return insts;
    }

    public static class InstructionFactory
    extends JavaLanguage.JavaInstructionFactory
    implements AstJavaInstructionFactory {
        @Override
        public EnclosingObjectReference EnclosingObjectReference(int iindex, int lval, TypeReference type) {
            return new EnclosingObjectReference(iindex, lval, type);
        }

        @Override
        public AstJavaNewEnclosingInstruction JavaNewEnclosingInstruction(int iindex, int result, NewSiteReference site, int enclosing) {
            return new AstJavaNewEnclosingInstruction(iindex, result, site, enclosing);
        }

        @Override
        public AstJavaInvokeInstruction JavaInvokeInstruction(int iindex, int[] result, int[] params, int exception, CallSiteReference site) {
            return result == null ? new AstJavaInvokeInstruction(iindex, params, exception, site) : new AstJavaInvokeInstruction(iindex, result[0], params, exception, site);
        }

        @Override
        public AstAssertInstruction AssertInstruction(int iindex, int value, boolean fromSpecification) {
            return new AstAssertInstruction(iindex, value, fromSpecification);
        }

        @Override
        public AssignInstruction AssignInstruction(int iindex, int result, int val) {
            return new AssignInstruction(iindex, result, val);
        }

        @Override
        public EachElementGetInstruction EachElementGetInstruction(int iindex, int value, int objectRef, int propRef) {
            throw new UnsupportedOperationException();
        }

        @Override
        public EachElementHasNextInstruction EachElementHasNextInstruction(int iindex, int value, int objectRef, int propRef) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AstEchoInstruction EchoInstruction(int iindex, int[] rvals) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AstGlobalRead GlobalRead(int iindex, int lhs, FieldReference global) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AstGlobalWrite GlobalWrite(int iindex, FieldReference global, int rhs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, int fieldVal, FieldReference fieldRef) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, FieldReference fieldRef) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval, int fieldVal) {
            return new AstIsDefinedInstruction(iindex, lval, rval, fieldVal);
        }

        @Override
        public AstIsDefinedInstruction IsDefinedInstruction(int iindex, int lval, int rval) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AstLexicalRead LexicalRead(int iindex, AstLexicalAccess.Access[] accesses) {
            return new AstLexicalRead(iindex, accesses);
        }

        @Override
        public AstLexicalRead LexicalRead(int iindex, AstLexicalAccess.Access access) {
            return new AstLexicalRead(iindex, access);
        }

        @Override
        public AstLexicalRead LexicalRead(int iindex, int lhs, String definer, String globalName, TypeReference type) {
            return new AstLexicalRead(iindex, lhs, definer, globalName, type);
        }

        @Override
        public AstLexicalWrite LexicalWrite(int iindex, AstLexicalAccess.Access[] accesses) {
            return new AstLexicalWrite(iindex, accesses);
        }

        @Override
        public AstLexicalWrite LexicalWrite(int iindex, AstLexicalAccess.Access access) {
            return new AstLexicalWrite(iindex, access);
        }

        @Override
        public AstLexicalWrite LexicalWrite(int iindex, String definer, String globalName, TypeReference type, int rhs) {
            return new AstLexicalWrite(iindex, definer, globalName, type, rhs);
        }

        @Override
        public AstYieldInstruction YieldInstruction(int iindex, int[] rvals) {
            return new AstYieldInstruction(iindex, rvals);
        }

        @Override
        public AstPropertyRead PropertyRead(int iindex, int result, int objectRef, int memberRef) {
            assert (false);
            return null;
        }

        @Override
        public AstPropertyWrite PropertyWrite(int iindex, int objectRef, int memberRef, int value) {
            assert (false);
            return null;
        }
    }

    public class ConcreteJavaMethod
    extends JavaEntityMethod {
        public ConcreteJavaMethod(CAstEntity methodEntity, IClass owner, AbstractCFG<?, ?> cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock<SSAInstruction>, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
            super(methodEntity, owner, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo);
        }

        @Override
        public IClassHierarchy getClassHierarchy() {
            return JavaSourceLoaderImpl.this.cha;
        }

        @Override
        public String getLocalVariableName(int bcIndex, int localNumber) {
            return null;
        }

        @Override
        public boolean hasLocalVariableTable() {
            return false;
        }

        @Override
        public AstMethod.LexicalParent[] getParents() {
            if (this.lexicalInfo() == null) {
                return new AstMethod.LexicalParent[0];
            }
            final String[] parents = this.lexicalInfo().getScopingParents();
            if (parents == null) {
                return new AstMethod.LexicalParent[0];
            }
            AstMethod.LexicalParent[] result = new AstMethod.LexicalParent[parents.length];
            for (int i = 0; i < parents.length; ++i) {
                int lastLeftParen = parents[i].lastIndexOf(40);
                int lastQ = parents[i].lastIndexOf(47, lastLeftParen);
                String typeName = parents[i].substring(0, lastQ);
                final IClass cls = JavaSourceLoaderImpl.this.lookupClass(TypeName.string2TypeName(typeName));
                String sig = parents[i].substring(lastQ);
                int nameEnd = sig.indexOf(40);
                String nameStr = sig.substring(1, nameEnd);
                Atom name = Atom.findOrCreateUnicodeAtom(nameStr);
                String descStr = sig.substring(nameEnd);
                Descriptor desc = Descriptor.findOrCreateUTF8(Language.JAVA, descStr);
                final Selector sel = new Selector(name, desc);
                final int hack = i;
                result[i] = new AstMethod.LexicalParent(){

                    @Override
                    public String getName() {
                        return parents[hack];
                    }

                    @Override
                    public AstMethod getMethod() {
                        return (AstMethod)cls.getMethod(sel);
                    }
                };
            }
            return result;
        }
    }

    protected class AbstractJavaMethod
    extends JavaEntityMethod {
        public AbstractJavaMethod(CAstEntity methodEntity, IClass owner) {
            super(methodEntity, owner);
        }

        @Override
        public String getLocalVariableName(int bcIndex, int localNumber) {
            Assertions.UNREACHABLE("AbstractJavaMethod.getLocalVariableName() called");
            return null;
        }

        @Override
        public boolean hasLocalVariableTable() {
            Assertions.UNREACHABLE("AbstractJavaMethod.hasLocalVariableTable() called");
            return false;
        }

        @Override
        public AstMethod.LexicalParent[] getParents() {
            return new AstMethod.LexicalParent[0];
        }

        @Override
        public IClassHierarchy getClassHierarchy() {
            return JavaSourceLoaderImpl.this.cha;
        }
    }

    protected abstract class JavaEntityMethod
    extends AstMethod {
        private final TypeReference[] parameterTypes;
        private final TypeReference[] exceptionTypes;

        public JavaEntityMethod(CAstEntity methodEntity, IClass owner, AbstractCFG<?, ?> cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock<SSAInstruction>, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
            super(owner, methodEntity.getQualifiers(), cfg, symtab, MethodReference.findOrCreate(owner.getReference(), Util.methodEntityToSelector(methodEntity)), hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo, JavaSourceLoaderImpl.this.getAnnotations(methodEntity));
            this.parameterTypes = this.computeParameterTypes(methodEntity);
            this.exceptionTypes = this.computeExceptionTypes(methodEntity);
        }

        public JavaEntityMethod(CAstEntity methodEntity, IClass owner) {
            super(owner, methodEntity.getQualifiers(), MethodReference.findOrCreate(owner.getReference(), Util.methodEntityToSelector(methodEntity)), JavaSourceLoaderImpl.this.getAnnotations(methodEntity));
            this.parameterTypes = this.computeParameterTypes(methodEntity);
            this.exceptionTypes = this.computeExceptionTypes(methodEntity);
        }

        public int getMaxLocals() {
            Assertions.UNREACHABLE("AbstractJavaMethod.getMaxLocals() called");
            return 0;
        }

        public int getMaxStackHeight() {
            Assertions.UNREACHABLE("AbstractJavaMethod.getMaxStackHeight() called");
            return 0;
        }

        @Override
        public TypeReference getParameterType(int i) {
            return this.parameterTypes[i];
        }

        protected TypeReference[] computeParameterTypes(CAstEntity methodEntity) {
            TypeReference[] types;
            CAstType.Function type = (CAstType.Function)methodEntity.getType();
            int argCount = type.getArgumentTypes().size();
            if (this.isStatic()) {
                types = new TypeReference[argCount];
                for (int i = 0; i < argCount; ++i) {
                    types[i] = TypeReference.findOrCreate(JavaSourceLoaderImpl.this.getReference(), type.getArgumentTypes().get(i).getName());
                }
            } else {
                types = new TypeReference[argCount + 1];
                types[0] = this.cls.getReference();
                for (int i = 0; i < argCount; ++i) {
                    types[i + 1] = TypeReference.findOrCreate(JavaSourceLoaderImpl.this.getReference(), type.getArgumentTypes().get(i).getName());
                }
            }
            return types;
        }

        @Override
        public TypeReference[] getDeclaredExceptions() {
            return this.exceptionTypes;
        }

        protected TypeReference[] computeExceptionTypes(CAstEntity methodEntity) {
            CAstType.Function fType = (CAstType.Function)methodEntity.getType();
            Collection<CAstType> exceptionTypes = fType.getExceptionTypes();
            TypeReference[] result = new TypeReference[exceptionTypes.size()];
            int i = 0;
            for (CAstType type : exceptionTypes) {
                result[i] = TypeReference.findOrCreate(JavaSourceLoaderImpl.this.getReference(), type.getName());
                ++i;
            }
            return result;
        }

        public String toString() {
            return "<src-method: " + this.getReference() + '>';
        }
    }

    protected static class JavaField
    extends AstField {
        protected JavaField(CAstEntity fieldEntity, IClassLoader loader, IClass declaringClass, Collection<Annotation> annotations) {
            super(FieldReference.findOrCreate(declaringClass.getReference(), Atom.findOrCreateUnicodeAtom(fieldEntity.getName()), TypeReference.findOrCreate(loader.getReference(), TypeName.string2TypeName(fieldEntity.getType().getName()))), fieldEntity.getQualifiers(), declaringClass, declaringClass.getClassHierarchy(), annotations);
        }
    }

    public class JavaClass
    extends AstClass {
        protected final IClass enclosingClass;
        protected final Collection<TypeName> superTypeNames;
        private final Collection<Annotation> annotations;

        public JavaClass(String typeName, Collection<TypeName> superTypeNames, CAstSourcePositionMap.Position position, Collection<CAstQualifier> qualifiers, JavaSourceLoaderImpl loader, IClass enclosingClass, Collection<Annotation> annotations) {
            super(position, TypeName.string2TypeName(typeName), loader, (short)JavaSourceLoaderImpl.mapToInt(qualifiers), new HashMap<Atom, IField>(), new HashMap<Selector, IMethod>());
            this.superTypeNames = superTypeNames;
            this.enclosingClass = enclosingClass;
            this.annotations = annotations;
        }

        @Override
        public Collection<Annotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public IClassHierarchy getClassHierarchy() {
            return JavaSourceLoaderImpl.this.cha;
        }

        @Override
        public IClass getSuperclass() {
            boolean excludedSupertype = false;
            for (TypeName name : this.superTypeNames) {
                IClass domoType = JavaSourceLoaderImpl.this.lookupClass(name);
                if (domoType != null && !domoType.isInterface()) {
                    return domoType;
                }
                if (domoType != null || !this.getClassHierarchy().getScope().getExclusions().contains(name.toString().substring(1))) continue;
                excludedSupertype = true;
            }
            if (JavaSourceLoaderImpl.this.existsCommonSuperclass && !this.getName().equals(JavaSourceLoaderImpl.this.getLanguage().getRootType().getName()) && !excludedSupertype) {
                Assertions.UNREACHABLE("Cannot find super class for " + this + " in " + this.superTypeNames);
            }
            if (excludedSupertype) {
                System.err.println("Not tracking calls through excluded superclass of " + this.getName() + " extends " + this.superTypeNames);
            }
            return null;
        }

        @Override
        public Collection<IClass> getDirectInterfaces() {
            ArrayList<IClass> result = new ArrayList<IClass>();
            for (TypeName name : this.superTypeNames) {
                IClass domoType = JavaSourceLoaderImpl.this.lookupClass(name);
                if (domoType != null && domoType.isInterface()) {
                    result.add(domoType);
                }
                if (domoType == null && !this.getClassHierarchy().getScope().getExclusions().contains(name.toString().substring(1))) assert (false) : "Failed to find non-excluded interface: " + name;
            }
            return result;
        }

        protected void addMethod(CAstEntity methodEntity, IClass owner, AbstractCFG<?, ?> cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock<SSAInstruction>, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
            this.declaredMethods.put(Util.methodEntityToSelector(methodEntity), new ConcreteJavaMethod(methodEntity, owner, cfg, symtab, hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo));
        }

        protected void addMethod(CAstEntity methodEntity, IClass owner) {
            this.declaredMethods.put(Util.methodEntityToSelector(methodEntity), new AbstractJavaMethod(methodEntity, owner));
        }

        protected void addField(CAstEntity fieldEntity) {
            this.declaredFields.put(Util.fieldEntityToAtom(fieldEntity), new JavaField(fieldEntity, JavaSourceLoaderImpl.this, this, JavaSourceLoaderImpl.this.getAnnotations(fieldEntity)));
        }

        public IClass getEnclosingClass() {
            return this.enclosingClass;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("<src-class: ");
            sb.append(this.getName().toString());
            if (this.enclosingClass != null) {
                sb.append(" (within ").append(this.enclosingClass.getName()).append(')');
            }
            if (this.annotations != null && !this.annotations.isEmpty()) {
                for (Annotation a : this.annotations) {
                    sb.append('[').append(a.getType().getName().getClassName()).append(']');
                }
            }
            return sb.toString();
        }
    }
}

