/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator.jdt.ecj;

import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.translator.Java2IRTranslator;
import com.ibm.wala.cast.java.translator.SourceModuleTranslator;
import com.ibm.wala.cast.java.translator.jdt.JDTJava2CAstTranslator;
import com.ibm.wala.cast.java.translator.jdt.ecj.ECJSourceLoaderImpl;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import com.ibm.wala.classLoader.DirectoryTreeModule;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.JarStreamModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.io.TemporaryFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FileASTRequestor;

public class ECJSourceModuleTranslator
implements SourceModuleTranslator {
    protected boolean dump;
    protected ECJSourceLoaderImpl sourceLoader;
    private final String[] sources;
    private final String[] libs;
    private final SetOfClasses exclusions;

    public ECJSourceModuleTranslator(AnalysisScope scope, ECJSourceLoaderImpl sourceLoader) {
        this(scope, sourceLoader, false);
    }

    public ECJSourceModuleTranslator(AnalysisScope scope, ECJSourceLoaderImpl sourceLoader, boolean dump) {
        this.sourceLoader = sourceLoader;
        this.dump = dump;
        Pair<String[], String[]> paths = ECJSourceModuleTranslator.computeClassPath(scope);
        this.sources = (String[])paths.fst;
        this.libs = (String[])paths.snd;
        this.exclusions = scope.getExclusions();
    }

    private static Pair<String[], String[]> computeClassPath(AnalysisScope scope) {
        LinkedList<String> sources = new LinkedList<String>();
        LinkedList<String> libs = new LinkedList<String>();
        Iterator<ClassLoaderReference> iterator = scope.getLoaders().iterator();
        while (iterator.hasNext()) {
            for (ClassLoaderReference cl = iterator.next(); cl != null; cl = cl.getParent()) {
                List<Module> modules = scope.getModules(cl);
                for (Module m3 : modules) {
                    if (m3 instanceof JarFileModule) {
                        JarFileModule jarFileModule = (JarFileModule)m3;
                        libs.add(jarFileModule.getAbsolutePath());
                        continue;
                    }
                    if (m3 instanceof JarStreamModule) {
                        try {
                            File F = File.createTempFile("tmp", "jar");
                            F.deleteOnExit();
                            TemporaryFile.streamToFile(F, (JarStreamModule)m3);
                            libs.add(F.getAbsolutePath());
                            continue;
                        }
                        catch (IOException e) {
                            assert (false) : e;
                            continue;
                        }
                    }
                    if (!(m3 instanceof DirectoryTreeModule)) continue;
                    DirectoryTreeModule directoryTreeModule = (DirectoryTreeModule)m3;
                    sources.add(directoryTreeModule.getPath());
                }
            }
        }
        return Pair.make(sources.toArray(new String[0]), libs.toArray(new String[0]));
    }

    @Override
    public void loadAllSources(Set<ModuleEntry> modules) {
        LinkedList<String> sources = new LinkedList<String>();
        HashMap<String, ModuleEntry> sourceMap = HashMapFactory.make();
        for (ModuleEntry m3 : modules) {
            if (!m3.isSourceFile()) continue;
            SourceFileModule s2 = (SourceFileModule)m3;
            sourceMap.put(s2.getAbsolutePath(), s2);
            sources.add(s2.getAbsolutePath());
        }
        String[] sourceFiles = sources.toArray(new String[0]);
        ASTParser parser = ASTParser.newParser(8);
        parser.setResolveBindings(true);
        parser.setEnvironment(this.libs, this.sources, null, false);
        Hashtable<String, String> options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "1.8");
        parser.setCompilerOptions(options);
        parser.createASTs(sourceFiles, null, new String[0], new ECJAstToIR(sourceMap), new NullProgressMonitor());
    }

    protected Java2IRTranslator makeIRTranslator() {
        return new Java2IRTranslator(this.sourceLoader, this.exclusions);
    }

    protected JDTJava2CAstTranslator<CAstSourcePositionMap.Position> makeCAstTranslator(CompilationUnit cu, String fullPath) {
        return new ECJJavaToCAstTranslator(this.sourceLoader, cu, fullPath, false, this.dump);
    }

    private final class ECJAstToIR
    extends FileASTRequestor {
        private final Map<String, ModuleEntry> sourceMap;

        public ECJAstToIR(Map<String, ModuleEntry> sourceMap) {
            this.sourceMap = sourceMap;
        }

        @Override
        public void acceptAST(String source, CompilationUnit ast) {
            IProblem[] problems;
            int length;
            JDTJava2CAstTranslator<CAstSourcePositionMap.Position> jdt2cast = ECJSourceModuleTranslator.this.makeCAstTranslator(ast, source);
            Java2IRTranslator java2ir = ECJSourceModuleTranslator.this.makeIRTranslator();
            java2ir.translate(this.sourceMap.get(source), jdt2cast.translateToCAst());
            if (!"true".equals(System.getProperty("wala.jdt.quiet")) && (length = (problems = ast.getProblems()).length) > 0) {
                StringBuilder buffer = new StringBuilder();
                for (IProblem problem : problems) {
                    buffer.append(problem.getMessage());
                    buffer.append('\n');
                }
                if (length != 0) {
                    System.err.println("Unexpected problems in " + source + "\n " + buffer);
                }
            }
        }
    }

    protected class ECJJavaToCAstTranslator
    extends JDTJava2CAstTranslator<CAstSourcePositionMap.Position> {
        public ECJJavaToCAstTranslator(JavaSourceLoaderImpl sourceLoader, CompilationUnit astRoot, String fullPath, boolean replicateForDoLoops, boolean dump) {
            super(sourceLoader, astRoot, fullPath, replicateForDoLoops, dump);
        }

        @Override
        public CAstSourcePositionMap.Position makePosition(final int start, final int end) {
            return new AbstractSourcePosition(){

                @Override
                public URL getURL() {
                    try {
                        return new URL("file://" + ECJJavaToCAstTranslator.this.fullPath);
                    }
                    catch (MalformedURLException e) {
                        assert (false) : ECJJavaToCAstTranslator.access$100(ECJJavaToCAstTranslator.this);
                        return null;
                    }
                }

                @Override
                public Reader getReader() throws IOException {
                    return new InputStreamReader(this.getURL().openConnection().getInputStream());
                }

                @Override
                public int getFirstLine() {
                    return ECJJavaToCAstTranslator.this.cu.getLineNumber(start);
                }

                @Override
                public int getLastLine() {
                    return ECJJavaToCAstTranslator.this.cu.getLineNumber(end);
                }

                @Override
                public int getFirstCol() {
                    return ECJJavaToCAstTranslator.this.cu.getColumnNumber(start);
                }

                @Override
                public int getLastCol() {
                    return ECJJavaToCAstTranslator.this.cu.getColumnNumber(end);
                }

                @Override
                public int getFirstOffset() {
                    return start;
                }

                @Override
                public int getLastOffset() {
                    return end;
                }
            };
        }

        static /* synthetic */ String access$100(ECJJavaToCAstTranslator x0) {
            return x0.fullPath;
        }
    }
}

