/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.ClassConstants;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public abstract class AstClass
implements IClass,
ClassConstants {
    private final CAstSourcePositionMap.Position sourcePosition;
    private final TypeName typeName;
    private final TypeReference typeReference;
    private final IClassLoader loader;
    private final short modifiers;
    protected final Map<Atom, IField> declaredFields;
    protected final Map<Selector, IMethod> declaredMethods;

    protected AstClass(CAstSourcePositionMap.Position sourcePosition, TypeName typeName, IClassLoader loader, short modifiers, Map<Atom, IField> declaredFields, Map<Selector, IMethod> declaredMethods) {
        this.sourcePosition = sourcePosition;
        this.typeName = typeName;
        this.loader = loader;
        this.modifiers = modifiers;
        this.declaredFields = declaredFields;
        this.declaredMethods = declaredMethods;
        this.typeReference = TypeReference.findOrCreate(loader.getReference(), typeName);
    }

    @Override
    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    @Override
    public boolean isReferenceType() {
        return true;
    }

    @Override
    public boolean isArrayClass() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public CAstSourcePositionMap.Position getSourcePosition() {
        return this.sourcePosition;
    }

    public URL getSourceURL() {
        return this.sourcePosition.getURL();
    }

    @Override
    public String getSourceFileName() {
        return this.sourcePosition.getURL().getFile();
    }

    @Override
    public Reader getSource() {
        return null;
    }

    @Override
    public TypeName getName() {
        return this.typeName;
    }

    @Override
    public TypeReference getReference() {
        return this.typeReference;
    }

    @Override
    public IClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public abstract IClass getSuperclass();

    private Collection<IClass> gatherInterfaces() {
        HashSet<IClass> result = HashSetFactory.make();
        result.addAll(this.getDirectInterfaces());
        if (this.getSuperclass() != null) {
            result.addAll(this.getSuperclass().getAllImplementedInterfaces());
        }
        return result;
    }

    public abstract Collection<IClass> getDirectInterfaces();

    @Override
    public Collection<IClass> getAllImplementedInterfaces() {
        return this.gatherInterfaces();
    }

    @Override
    public IMethod getClassInitializer() {
        return this.getMethod(MethodReference.clinitSelector);
    }

    @Override
    public IMethod getMethod(Selector selector) {
        if (this.declaredMethods.containsKey(selector)) {
            return this.declaredMethods.get(selector);
        }
        if (this.getSuperclass() != null) {
            return this.getSuperclass().getMethod(selector);
        }
        return null;
    }

    @Override
    public IField getField(Atom name) {
        if (this.declaredFields.containsKey(name)) {
            return this.declaredFields.get(name);
        }
        if (this.getSuperclass() != null) {
            return this.getSuperclass().getField(name);
        }
        return null;
    }

    @Override
    public IField getField(Atom name, TypeName type) {
        return this.getField(name);
    }

    @Override
    public Collection<? extends IMethod> getDeclaredMethods() {
        return this.declaredMethods.values();
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() {
        HashSet<IField> result = HashSetFactory.make();
        for (IField F : this.declaredFields.values()) {
            if (F.isStatic()) continue;
            result.add(F);
        }
        return result;
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() {
        HashSet<IField> result = HashSetFactory.make();
        for (IField F : this.declaredFields.values()) {
            if (!F.isStatic()) continue;
            result.add(F);
        }
        return result;
    }

    @Override
    public Collection<IField> getAllInstanceFields() {
        HashSet<IField> result = HashSetFactory.make();
        result.addAll(this.getDeclaredInstanceFields());
        if (this.getSuperclass() != null) {
            result.addAll(this.getSuperclass().getAllInstanceFields());
        }
        return result;
    }

    @Override
    public Collection<IField> getAllStaticFields() {
        HashSet<IField> result = HashSetFactory.make();
        result.addAll(this.getDeclaredStaticFields());
        if (this.getSuperclass() != null) {
            result.addAll(this.getSuperclass().getAllStaticFields());
        }
        return result;
    }

    @Override
    public Collection<IField> getAllFields() {
        HashSet<IField> result = HashSetFactory.make();
        result.addAll(this.getAllInstanceFields());
        result.addAll(this.getAllStaticFields());
        return result;
    }

    @Override
    public Collection<? extends IMethod> getAllMethods() {
        HashSet result = HashSetFactory.make();
        result.addAll(this.getDeclaredMethods());
        if (this.getSuperclass() != null) {
            result.addAll(this.getSuperclass().getAllMethods());
        }
        return result;
    }
}

