/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.Collections;

public class AstDynamicField
implements IField {
    private final boolean isStatic;
    private final TypeReference descriptor;
    private final IClass cls;
    private final Atom name;

    public AstDynamicField(boolean isStatic, IClass cls, Atom name, TypeReference descriptor) {
        this.isStatic = isStatic;
        this.descriptor = descriptor;
        this.cls = cls;
        this.name = name;
    }

    public String toString() {
        return "<field " + this.name + '>';
    }

    @Override
    public IClass getDeclaringClass() {
        return this.cls;
    }

    @Override
    public Atom getName() {
        return this.name;
    }

    @Override
    public TypeReference getFieldTypeReference() {
        return this.descriptor;
    }

    @Override
    public FieldReference getReference() {
        return FieldReference.findOrCreate(this.cls.getReference(), this.name, this.descriptor);
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cls.getClassHierarchy();
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return Collections.emptySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
        result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AstDynamicField other = (AstDynamicField)obj;
        if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
            return false;
        }
        if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor)) {
            return false;
        }
        if (this.isStatic != other.isStatic) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

