/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;

public class AstField
implements IField {
    private final Collection<CAstQualifier> qualifiers;
    private final FieldReference ref;
    private final IClass declaringClass;
    private final IClassHierarchy cha;
    private final Collection<Annotation> annotations;

    public AstField(FieldReference ref, Collection<CAstQualifier> qualifiers, IClass declaringClass, IClassHierarchy cha, Collection<Annotation> annotations) {
        this.declaringClass = declaringClass;
        this.qualifiers = qualifiers;
        this.ref = ref;
        this.cha = cha;
        this.annotations = annotations;
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public IClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        return "field " + this.ref.getName();
    }

    @Override
    public Atom getName() {
        return this.ref.getName();
    }

    @Override
    public TypeReference getFieldTypeReference() {
        return this.ref.getFieldType();
    }

    @Override
    public FieldReference getReference() {
        return this.ref;
    }

    @Override
    public boolean isStatic() {
        return this.qualifiers.contains(CAstQualifier.STATIC);
    }

    @Override
    public boolean isFinal() {
        return this.qualifiers.contains(CAstQualifier.CONST) || this.qualifiers.contains(CAstQualifier.FINAL);
    }

    @Override
    public boolean isPrivate() {
        return this.qualifiers.contains(CAstQualifier.PRIVATE);
    }

    @Override
    public boolean isProtected() {
        return this.qualifiers.contains(CAstQualifier.PROTECTED);
    }

    @Override
    public boolean isPublic() {
        return this.qualifiers.contains(CAstQualifier.PUBLIC);
    }

    @Override
    public boolean isVolatile() {
        return this.qualifiers.contains(CAstQualifier.VOLATILE);
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

