/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.cast.types.AstTypeReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.ClassConstants;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.Atom;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;

public abstract class AstFunctionClass
implements IClass,
ClassConstants {
    private final IClassLoader loader;
    protected AstMethod functionBody;
    private final CAstSourcePositionMap.Position sourcePosition;
    private final TypeReference reference;
    private final TypeReference superReference;

    protected AstFunctionClass(TypeReference reference, TypeReference superReference, IClassLoader loader, CAstSourcePositionMap.Position sourcePosition) {
        this.superReference = superReference;
        this.sourcePosition = sourcePosition;
        this.reference = reference;
        this.loader = loader;
    }

    protected AstFunctionClass(TypeReference reference, IClassLoader loader, CAstSourcePositionMap.Position sourcePosition) {
        this(reference, TypeReference.findOrCreate(reference.getClassLoader(), AstTypeReference.functionTypeName), loader, sourcePosition);
    }

    public String toString() {
        try {
            return "function " + this.functionBody.getReference().getDeclaringClass().getName();
        }
        catch (NullPointerException e) {
            return "<need to set code body>";
        }
    }

    @Override
    public IClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this.functionBody == null;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public int getModifiers() {
        return 1;
    }

    @Override
    public IClass getSuperclass() {
        return this.loader.lookupClass(this.superReference.getName());
    }

    public Collection<IClass> getDirectInterfaces() {
        return Collections.emptySet();
    }

    @Override
    public Collection<IClass> getAllImplementedInterfaces() {
        return Collections.emptySet();
    }

    public Collection<IClass> getAllAncestorInterfaces() {
        return Collections.emptySet();
    }

    @Override
    public IMethod getMethod(Selector selector) {
        if (selector.equals(AstMethodReference.fnSelector)) {
            return this.functionBody;
        }
        return this.loader.lookupClass(this.superReference.getName()).getMethod(selector);
    }

    @Override
    public IField getField(Atom name) {
        return this.loader.lookupClass(this.superReference.getName()).getField(name);
    }

    @Override
    public IField getField(Atom name, TypeName type) {
        return this.loader.lookupClass(this.superReference.getName()).getField(name);
    }

    @Override
    public TypeReference getReference() {
        return this.reference;
    }

    public CAstSourcePositionMap.Position getSourcePosition() {
        return this.sourcePosition;
    }

    public URL getSourceURL() {
        return this.sourcePosition.getURL();
    }

    @Override
    public String getSourceFileName() {
        return this.sourcePosition.getURL().getFile();
    }

    @Override
    public Reader getSource() {
        return null;
    }

    @Override
    public IMethod getClassInitializer() {
        return null;
    }

    @Override
    public boolean isArrayClass() {
        return false;
    }

    public Collection<IMethod> getDeclaredMethods() {
        if (this.functionBody != null) {
            return Collections.singleton(this.functionBody);
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() {
        return Collections.emptySet();
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() {
        return Collections.emptySet();
    }

    @Override
    public Collection<IField> getAllInstanceFields() {
        return Collections.emptySet();
    }

    @Override
    public Collection<IField> getAllStaticFields() {
        return Collections.emptySet();
    }

    @Override
    public Collection<IField> getAllFields() {
        return Collections.emptySet();
    }

    public Collection<IMethod> getAllMethods() {
        return Collections.singleton(this.functionBody);
    }

    @Override
    public TypeName getName() {
        return this.reference.getName();
    }

    @Override
    public boolean isReferenceType() {
        return true;
    }

    public AstMethod getCodeBody() {
        return this.functionBody;
    }
}

