/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public abstract class AstMethod
implements IMethod {
    protected final IClass cls;
    private final Collection<CAstQualifier> qualifiers;
    private final AbstractCFG<?, ?> cfg;
    private final SymbolTable symtab;
    private final MethodReference ref;
    private final boolean hasCatchBlock;
    private final boolean hasMonitorOp;
    private final Map<IBasicBlock<SSAInstruction>, TypeReference[]> catchTypes;
    private final AstTranslator.AstLexicalInformation lexicalInfo;
    private final DebuggingInformation debugInfo;
    private final Collection<Annotation> annotations;

    protected AstMethod(IClass cls, Collection<CAstQualifier> qualifiers, AbstractCFG<?, ?> cfg, SymbolTable symtab, MethodReference ref, boolean hasCatchBlock, Map<IBasicBlock<SSAInstruction>, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, DebuggingInformation debugInfo, Collection<Annotation> annotations) {
        this.cls = cls;
        this.cfg = cfg;
        this.ref = ref;
        this.symtab = symtab;
        this.qualifiers = qualifiers;
        this.catchTypes = caughtTypes;
        this.hasCatchBlock = hasCatchBlock;
        this.hasMonitorOp = hasMonitorOp;
        this.lexicalInfo = lexicalInfo;
        this.debugInfo = debugInfo;
        this.annotations = annotations;
    }

    protected AstMethod(IClass cls, Collection<CAstQualifier> qualifiers, MethodReference ref, Collection<Annotation> annotations) {
        this.cls = cls;
        this.qualifiers = qualifiers;
        this.ref = ref;
        this.annotations = annotations;
        this.cfg = null;
        this.symtab = null;
        this.catchTypes = null;
        this.hasCatchBlock = false;
        this.hasMonitorOp = false;
        this.lexicalInfo = null;
        this.debugInfo = null;
        assert (this.isAbstract());
    }

    public AbstractCFG<?, ?> cfg() {
        return this.cfg;
    }

    public boolean hasCatchBlock() {
        return this.hasCatchBlock();
    }

    public SymbolTable symbolTable() {
        return this.symtab;
    }

    public Map<IBasicBlock<SSAInstruction>, TypeReference[]> catchTypes() {
        return this.catchTypes;
    }

    public LexicalInformation cloneLexicalInfo() {
        return new AstTranslator.AstLexicalInformation(this.lexicalInfo);
    }

    public LexicalInformation lexicalInfo() {
        return this.lexicalInfo;
    }

    public DebuggingInformation debugInfo() {
        return this.debugInfo;
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    public abstract LexicalParent[] getParents();

    @Override
    public IClass getDeclaringClass() {
        return this.cls;
    }

    @Override
    public String getSignature() {
        return this.ref.getSignature();
    }

    @Override
    public Selector getSelector() {
        return this.ref.getSelector();
    }

    @Override
    public boolean isClinit() {
        return this.getSelector().equals(MethodReference.clinitSelector);
    }

    @Override
    public boolean isInit() {
        return this.getSelector().getName().equals(MethodReference.initAtom);
    }

    @Override
    public Atom getName() {
        return this.ref.getName();
    }

    @Override
    public Descriptor getDescriptor() {
        return this.ref.getDescriptor();
    }

    @Override
    public MethodReference getReference() {
        return this.ref;
    }

    @Override
    public TypeReference getReturnType() {
        return this.ref.getReturnType();
    }

    @Override
    public boolean isStatic() {
        return this.qualifiers.contains(CAstQualifier.STATIC);
    }

    @Override
    public boolean isSynchronized() {
        return this.qualifiers.contains(CAstQualifier.SYNCHRONIZED);
    }

    @Override
    public boolean isNative() {
        return this.qualifiers.contains(CAstQualifier.NATIVE);
    }

    @Override
    public boolean isWalaSynthetic() {
        return false;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this.qualifiers.contains(CAstQualifier.ABSTRACT);
    }

    @Override
    public boolean isPrivate() {
        return this.qualifiers.contains(CAstQualifier.PRIVATE);
    }

    @Override
    public boolean isProtected() {
        return this.qualifiers.contains(CAstQualifier.PROTECTED);
    }

    @Override
    public boolean isPublic() {
        return this.qualifiers.contains(CAstQualifier.PUBLIC);
    }

    @Override
    public boolean isFinal() {
        return this.qualifiers.contains(CAstQualifier.FINAL);
    }

    @Override
    public boolean isBridge() {
        return this.qualifiers.contains(CAstQualifier.VOLATILE);
    }

    public ControlFlowGraph<?, ?> getControlFlowGraph() {
        return this.cfg;
    }

    @Override
    public boolean hasExceptionHandler() {
        return this.hasCatchBlock;
    }

    public boolean hasMonitorOp() {
        return this.hasMonitorOp;
    }

    @Override
    public int getNumberOfParameters() {
        return this.symtab.getParameterValueNumbers().length;
    }

    @Override
    public IMethod.SourcePosition getParameterSourcePosition(int paramNum) throws InvalidClassFileException {
        return null;
    }

    @Override
    public int getLineNumber(int instructionIndex) {
        CAstSourcePositionMap.Position pos = this.debugInfo.getInstructionPosition(instructionIndex);
        if (pos == null) {
            return -1;
        }
        return pos.getFirstLine();
    }

    public CAstSourcePositionMap.Position getSourcePosition() {
        return this.debugInfo.getCodeBodyPosition();
    }

    public CAstSourcePositionMap.Position getParameterPosition(int paramIndex) {
        return this.debugInfo.getParameterPosition(paramIndex);
    }

    @Override
    public CAstSourcePositionMap.Position getSourcePosition(int instructionIndex) {
        return this.debugInfo.getInstructionPosition(instructionIndex);
    }

    public static abstract class LexicalParent {
        public abstract String getName();

        public abstract AstMethod getMethod();

        public int hashCode() {
            return this.getName().hashCode() * this.getMethod().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof LexicalParent && this.getName().equals(((LexicalParent)o).getName()) && this.getMethod().equals(((LexicalParent)o).getMethod());
        }
    }

    public static interface LexicalInformation {
        public Pair<String, String>[] getExposedNames();

        public int[] getExitExposedUses();

        public int[] getExposedUses(int var1);

        public IntSet getAllExposedUses();

        public String[] getScopingParents();

        public boolean isReadOnly(String var1);

        public String getScopingName();
    }

    public static interface DebuggingInformation {
        public CAstSourcePositionMap.Position getCodeBodyPosition();

        public CAstSourcePositionMap.Position getCodeNamePosition();

        public CAstSourcePositionMap.Position getInstructionPosition(int var1);

        public String[][] getSourceNamesForValues();

        public CAstSourcePositionMap.Position getOperandPosition(int var1, int var2);

        public CAstSourcePositionMap.Position getParameterPosition(int var1);

        public String getLeadingComment(int var1) throws IOException;

        public String getFollowingComment(int var1) throws IOException;
    }

    public static interface Retranslatable {
        public void retranslate(AstTranslator var1);

        public CAstEntity getEntity();
    }
}

