/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.ir.translator.TranslatorToIR;
import com.ibm.wala.cast.loader.AstDynamicPropertyClass;
import com.ibm.wala.cast.loader.AstFunctionClass;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.loader.CAstAbstractLoader;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.classLoader.SourceModule;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.TemporaryFile;
import com.ibm.wala.util.warnings.Warning;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CAstAbstractModuleLoader
extends CAstAbstractLoader {
    private static final boolean DEBUG = false;

    public CAstAbstractModuleLoader(IClassHierarchy cha, IClassLoader parent) {
        super(cha, parent);
    }

    public CAstAbstractModuleLoader(IClassHierarchy cha) {
        this(cha, null);
    }

    protected abstract TranslatorToCAst getTranslatorToCAst(CAst var1, ModuleEntry var2) throws IOException;

    protected abstract boolean shouldTranslate(CAstEntity var1);

    protected abstract TranslatorToIR initTranslator();

    protected File getLocalFile(SourceModule M) throws IOException {
        if (M instanceof SourceFileModule) {
            return ((SourceFileModule)M).getFile();
        }
        File f = File.createTempFile("module", ".txt");
        f.deleteOnExit();
        try (InputStream inputStream = M.getInputStream();){
            TemporaryFile.streamToFile(f, inputStream);
        }
        return f;
    }

    protected void finishTranslation() {
    }

    @Override
    public void init(List<Module> modules) {
        CAstImpl ast = new CAstImpl();
        LinkedHashSet<Pair<CAstEntity, ModuleEntry>> topLevelEntities = new LinkedHashSet<Pair<CAstEntity, ModuleEntry>>();
        for (Module module : modules) {
            this.translateModuleToCAst(module, ast, topLevelEntities);
        }
        TranslatorToIR xlatorToIR = this.initTranslator();
        for (Pair pair : topLevelEntities) {
            if (!this.shouldTranslate((CAstEntity)pair.fst)) continue;
            xlatorToIR.translate((CAstEntity)pair.fst, (ModuleEntry)pair.snd);
        }
        this.finishTranslation();
    }

    private void translateModuleEntryToCAst(ModuleEntry moduleEntry, CAst ast, Set<Pair<CAstEntity, ModuleEntry>> topLevelEntities) {
        try {
            if (moduleEntry.isModuleFile()) {
                this.translateModuleToCAst(moduleEntry.asModule(), ast, topLevelEntities);
            } else {
                TranslatorToCAst xlatorToCAst = this.getTranslatorToCAst(ast, moduleEntry);
                CAstEntity fileEntity = null;
                try {
                    fileEntity = xlatorToCAst.translateToCAst();
                    topLevelEntities.add(Pair.make(fileEntity, moduleEntry));
                }
                catch (TranslatorToCAst.Error e) {
                    this.addMessages(moduleEntry, e.warning);
                }
            }
        }
        catch (IOException e) {
            this.addMessage(moduleEntry, new Warning(2){

                @Override
                public String getMsg() {
                    return "I/O issue: " + e.getMessage();
                }
            });
        }
        catch (RuntimeException e) {
            final ByteArrayOutputStream s2 = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(s2);
            e.printStackTrace(ps);
            this.addMessage(moduleEntry, new Warning(2){

                @Override
                public String getMsg() {
                    return "Parsing issue: " + new String(s2.toByteArray());
                }
            });
        }
    }

    private void translateModuleToCAst(Module module, CAst ast, Set<Pair<CAstEntity, ModuleEntry>> topLevelEntities) {
        for (ModuleEntry moduleEntry : Iterator2Iterable.make(module.getEntries())) {
            this.translateModuleEntryToCAst(moduleEntry, ast, topLevelEntities);
        }
    }

    public class CoreClass
    extends AstDynamicPropertyClass {
        private final TypeName superName;

        public CoreClass(TypeName name, TypeName superName, IClassLoader loader, CAstSourcePositionMap.Position sourcePosition) {
            super(sourcePosition, name, loader, (short)0, Collections.emptyMap(), CAstAbstractModuleLoader.this.getLanguage().getRootType());
            CAstAbstractModuleLoader.this.types.put(name, this);
            this.superName = superName;
        }

        @Override
        public IClassHierarchy getClassHierarchy() {
            return CAstAbstractModuleLoader.this.cha;
        }

        public String toString() {
            return "Core[" + this.getReference().getName().toString().substring(1) + ']';
        }

        @Override
        public Collection<IClass> getDirectInterfaces() {
            return Collections.emptySet();
        }

        @Override
        public IClass getSuperclass() {
            return this.superName == null ? null : (IClass)CAstAbstractModuleLoader.this.types.get(this.superName);
        }

        @Override
        public Collection<Annotation> getAnnotations() {
            return Collections.emptySet();
        }
    }

    public class DynamicMethodObject
    extends AstMethod
    implements AstMethod.Retranslatable {
        private AstTranslator.WalkContext translationContext;
        private CAstEntity entity;

        public DynamicMethodObject(IClass cls, Collection<CAstQualifier> qualifiers, AbstractCFG<?, ?> cfg, SymbolTable symtab, boolean hasCatchBlock, Map<IBasicBlock<SSAInstruction>, TypeReference[]> caughtTypes, boolean hasMonitorOp, AstTranslator.AstLexicalInformation lexicalInfo, AstMethod.DebuggingInformation debugInfo) {
            super(cls, qualifiers, cfg, symtab, AstMethodReference.fnReference(cls.getReference()), hasCatchBlock, caughtTypes, hasMonitorOp, lexicalInfo, debugInfo, null);
            symtab.getNullConstant();
        }

        @Override
        public CAstEntity getEntity() {
            return this.entity;
        }

        @Override
        public void retranslate(AstTranslator xlator) {
            xlator.translate(this.entity, this.translationContext);
        }

        @Override
        public IClassHierarchy getClassHierarchy() {
            return CAstAbstractModuleLoader.this.cha;
        }

        public String toString() {
            return "<Code body of " + this.cls + '>';
        }

        @Override
        public TypeReference[] getDeclaredExceptions() {
            return null;
        }

        @Override
        public AstMethod.LexicalParent[] getParents() {
            if (this.lexicalInfo() == null) {
                return new AstMethod.LexicalParent[0];
            }
            final String[] parents = this.lexicalInfo().getScopingParents();
            if (parents == null) {
                return new AstMethod.LexicalParent[0];
            }
            AstMethod.LexicalParent[] result = new AstMethod.LexicalParent[parents.length];
            for (int i = 0; i < parents.length; ++i) {
                final int hack = i;
                final AstMethod method = (AstMethod)CAstAbstractModuleLoader.this.lookupClass(parents[i], CAstAbstractModuleLoader.this.cha).getMethod(AstMethodReference.fnSelector);
                result[i] = new AstMethod.LexicalParent(){

                    @Override
                    public String getName() {
                        return parents[hack];
                    }

                    @Override
                    public AstMethod getMethod() {
                        return method;
                    }
                };
            }
            return result;
        }

        @Override
        public String getLocalVariableName(int bcIndex, int localNumber) {
            return null;
        }

        @Override
        public boolean hasLocalVariableTable() {
            return false;
        }

        public int getMaxLocals() {
            Assertions.UNREACHABLE();
            return -1;
        }

        public int getMaxStackHeight() {
            Assertions.UNREACHABLE();
            return -1;
        }

        @Override
        public TypeReference getParameterType(int i) {
            if (i == 0) {
                return this.getDeclaringClass().getReference();
            }
            return this.getDeclaringClass().getClassLoader().getLanguage().getRootType();
        }
    }

    public class DynamicCodeBody
    extends AstFunctionClass {
        private final AstTranslator.WalkContext translationContext;
        private final CAstEntity entity;

        public DynamicCodeBody(TypeReference codeName, TypeReference parent, IClassLoader loader, CAstSourcePositionMap.Position sourcePosition, CAstEntity entity, AstTranslator.WalkContext context) {
            super(codeName, parent, loader, sourcePosition);
            CAstAbstractModuleLoader.this.types.put(codeName.getName(), this);
            this.translationContext = context;
            this.entity = entity;
        }

        @Override
        public IClassHierarchy getClassHierarchy() {
            return CAstAbstractModuleLoader.this.cha;
        }

        public IMethod setCodeBody(DynamicMethodObject codeBody) {
            this.functionBody = codeBody;
            codeBody.entity = this.entity;
            codeBody.translationContext = this.translationContext;
            return codeBody;
        }

        @Override
        public Collection<Annotation> getAnnotations() {
            return Collections.emptySet();
        }
    }
}

