/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.rewrite;

import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstNodeTypeMap;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.CAstControlFlowRecorder;
import com.ibm.wala.cast.tree.impl.CAstNodeTypeMapRecorder;
import com.ibm.wala.cast.tree.impl.CAstSourcePositionRecorder;
import com.ibm.wala.cast.tree.impl.DelegatingEntity;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public abstract class CAstRewriter<C extends RewriteContext<K>, K extends CopyKey<K>> {
    protected static final boolean DEBUG = false;
    protected final CAst Ast;
    protected final boolean recursive;
    protected final C rootContext;

    public CAstRewriter(CAst Ast, boolean recursive, C rootContext) {
        this.Ast = Ast;
        this.recursive = recursive;
        this.rootContext = rootContext;
    }

    protected abstract CAstNode copyNodes(CAstNode var1, CAstControlFlowMap var2, C var3, Map<Pair<CAstNode, K>, CAstNode> var4);

    protected CAstNode copySubtreesIntoNewNode(CAstNode n, CAstControlFlowMap cfg, C c, Map<Pair<CAstNode, K>, CAstNode> nodeMap) {
        return this.copySubtreesIntoNewNode(n, cfg, c, nodeMap, Pair.make(n, c.key()));
    }

    protected CAstNode copySubtreesIntoNewNode(CAstNode n, CAstControlFlowMap cfg, C c, Map<Pair<CAstNode, K>, CAstNode> nodeMap, Pair<CAstNode, K> pairKey) {
        List<CAstNode> newChildren = this.copyChildrenArray(n, cfg, c, nodeMap);
        CAstNode newN = this.Ast.makeNode(n.getKind(), newChildren);
        assert (!nodeMap.containsKey(pairKey));
        nodeMap.put(pairKey, newN);
        return newN;
    }

    protected List<CAstNode> copyChildrenArray(CAstNode n, CAstControlFlowMap cfg, C context, Map<Pair<CAstNode, K>, CAstNode> nodeMap) {
        ArrayList<CAstNode> newChildren = new ArrayList<CAstNode>(n.getChildCount());
        for (CAstNode child : n.getChildren()) {
            newChildren.add(this.copyNodes(child, cfg, context, nodeMap));
        }
        return newChildren;
    }

    protected List<CAstNode> copyChildrenArrayAndTargets(CAstNode n, CAstControlFlowMap cfg, C context, Map<Pair<CAstNode, K>, CAstNode> nodeMap) {
        Collection<Object> targetLabels;
        List<CAstNode> children = this.copyChildrenArray(n, cfg, context, nodeMap);
        if (cfg != null && (targetLabels = cfg.getTargetLabels(n)) != null) {
            for (Object label : targetLabels) {
                if (!(label instanceof CAstNode)) continue;
                this.copyNodes((CAstNode)label, cfg, context, nodeMap);
            }
        }
        return children;
    }

    protected CAstNode flowOutTo(Map<Pair<CAstNode, K>, CAstNode> nodeMap, CAstNode oldSource, Object label, CAstNode oldTarget, CAstControlFlowMap orig, CAstSourcePositionMap src) {
        return oldTarget;
    }

    protected CAstControlFlowMap copyFlow(Map<Pair<CAstNode, K>, CAstNode> nodeMap, CAstControlFlowMap orig, CAstSourcePositionMap newSrc) {
        CAstControlFlowRecorder newMap = new CAstControlFlowRecorder(newSrc);
        HashSet mappedOutsideNodes = HashSetFactory.make(1);
        HashSet<CAstNode> allNewTargetNodes = HashSetFactory.make(1);
        Collection<CAstNode> oldSources = orig.getMappedNodes();
        for (Map.Entry<Pair<CAstNode, K>, CAstNode> entry : nodeMap.entrySet()) {
            Pair<CAstNode, K> N = entry.getKey();
            CAstNode oldSource = (CAstNode)N.fst;
            CopyKey key = (CopyKey)N.snd;
            CAstNode newSource = entry.getValue();
            assert (newSource != null);
            newMap.map(newSource, newSource);
            if (!oldSources.contains(oldSource)) continue;
            for (Object origLabel : orig.getTargetLabels(oldSource)) {
                CAstNode newTarget;
                Pair<CAstNode, CopyKey> targetKey;
                CAstNode oldTarget = orig.getTarget(oldSource, origLabel);
                assert (oldTarget != null);
                CopyKey k = key;
                do {
                    targetKey = Pair.make(oldTarget, k);
                    if (k == null) break;
                    k = k.parent();
                } while (!nodeMap.containsKey(targetKey));
                Object newLabel = nodeMap.containsKey(Pair.make(origLabel, targetKey.snd)) ? nodeMap.get(Pair.make(origLabel, targetKey.snd)) : origLabel;
                if (nodeMap.containsKey(targetKey)) {
                    newTarget = nodeMap.get(targetKey);
                    newMap.add(newSource, newTarget, newLabel);
                    allNewTargetNodes.add(newTarget);
                    continue;
                }
                newTarget = this.flowOutTo(nodeMap, oldSource, origLabel, oldTarget, orig, newSrc);
                allNewTargetNodes.add(newTarget);
                newMap.add(newSource, newTarget, newLabel);
                if (newTarget == CAstControlFlowMap.EXCEPTION_TO_EXIT || mappedOutsideNodes.contains(newTarget)) continue;
                mappedOutsideNodes.add(newTarget);
                newMap.map(newTarget, newTarget);
            }
        }
        allNewTargetNodes.removeAll(newMap.getMappedNodes());
        for (CAstNode newTarget : allNewTargetNodes) {
            if (newTarget == CAstControlFlowMap.EXCEPTION_TO_EXIT) continue;
            newMap.map(newTarget, newTarget);
        }
        assert (!this.oldNodesInNewMap(nodeMap, newMap));
        return newMap;
    }

    private boolean oldNodesInNewMap(Map<Pair<CAstNode, K>, CAstNode> nodeMap, CAstControlFlowRecorder newMap) {
        HashSet oldNodes = HashSetFactory.make();
        for (Map.Entry<Pair<CAstNode, K>, CAstNode> e : nodeMap.entrySet()) {
            oldNodes.add(e.getKey().fst);
        }
        for (CAstNode mappedNode : newMap.getMappedNodes()) {
            if (oldNodes.contains(mappedNode)) {
                return true;
            }
            for (Object lbl : newMap.getTargetLabels(mappedNode)) {
                if (!oldNodes.contains(newMap.getTarget(mappedNode, lbl))) continue;
                return true;
            }
        }
        return false;
    }

    protected CAstSourcePositionMap copySource(Map<Pair<CAstNode, K>, CAstNode> nodeMap, CAstSourcePositionMap orig) {
        CAstSourcePositionRecorder newMap = new CAstSourcePositionRecorder();
        for (Map.Entry<Pair<CAstNode, K>, CAstNode> entry : nodeMap.entrySet()) {
            Pair<CAstNode, K> N = entry.getKey();
            CAstNode oldNode = (CAstNode)N.fst;
            CAstNode newNode = entry.getValue();
            if (orig.getPosition(oldNode) == null) continue;
            newMap.setPosition(newNode, orig.getPosition(oldNode));
        }
        return newMap;
    }

    protected CAstNodeTypeMap copyTypes(Map<Pair<CAstNode, K>, CAstNode> nodeMap, CAstNodeTypeMap orig) {
        if (orig != null) {
            CAstNodeTypeMapRecorder newMap = new CAstNodeTypeMapRecorder();
            for (Map.Entry<Pair<CAstNode, K>, CAstNode> entry : nodeMap.entrySet()) {
                Pair<CAstNode, K> N = entry.getKey();
                CAstNode oldNode = (CAstNode)N.fst;
                CAstNode newNode = entry.getValue();
                if (orig.getNodeType(oldNode) == null) continue;
                newMap.add(newNode, orig.getNodeType(oldNode));
            }
            return newMap;
        }
        return null;
    }

    protected Map<CAstNode, Collection<CAstEntity>> copyChildren(CAstNode root, Map<Pair<CAstNode, K>, CAstNode> nodeMap, Map<CAstNode, Collection<CAstEntity>> children) {
        LinkedHashMap<CAstNode, Collection<CAstEntity>> newChildren = new LinkedHashMap<CAstNode, Collection<CAstEntity>>();
        for (Map.Entry<Pair<CAstNode, K>, CAstNode> entry : nodeMap.entrySet()) {
            Pair<CAstNode, K> N = entry.getKey();
            CAstNode oldNode = (CAstNode)N.fst;
            CAstNode newNode = entry.getValue();
            if (!children.containsKey(oldNode)) continue;
            LinkedHashSet<CAstEntity> newEntities = new LinkedHashSet<CAstEntity>();
            newChildren.put(newNode, newEntities);
            for (CAstEntity cAstEntity : children.get(oldNode)) {
                newEntities.add(this.rewrite(cAstEntity));
            }
        }
        for (Map.Entry<Object, Object> entry : children.entrySet()) {
            CAstNode key = (CAstNode)entry.getKey();
            if (key != null) continue;
            LinkedHashSet<CAstEntity> newEntities = new LinkedHashSet<CAstEntity>();
            newChildren.put(key, newEntities);
            for (CAstEntity oldEntity : (Collection)entry.getValue()) {
                newEntities.add(this.rewrite(oldEntity));
            }
        }
        return newChildren;
    }

    public Rewrite rewrite(final CAstNode root, final CAstControlFlowMap cfg, final CAstSourcePositionMap pos, final CAstNodeTypeMap types, final Map<CAstNode, Collection<CAstEntity>> children, CAstNode[] defaults) {
        final HashMap<Pair<CAstNode, K>, CAstNode> nodes = HashMapFactory.make();
        final CAstNode newRoot = this.copyNodes(root, cfg, this.rootContext, nodes);
        final CAstNode[] newDefaults = new CAstNode[defaults == null ? 0 : defaults.length];
        for (int i = 0; i < newDefaults.length; ++i) {
            newDefaults[i] = this.copyNodes(defaults[i], cfg, this.rootContext, nodes);
        }
        return new Rewrite(){
            private CAstControlFlowMap theCfg = null;
            private CAstSourcePositionMap theSource = null;
            private CAstNodeTypeMap theTypes = null;
            private Map<CAstNode, Collection<CAstEntity>> theChildren = null;

            @Override
            public CAstNode[] newDefaults() {
                return newDefaults;
            }

            @Override
            public CAstNode newRoot() {
                return newRoot;
            }

            @Override
            public CAstControlFlowMap newCfg() {
                if (this.theCfg == null && cfg != null) {
                    this.theCfg = CAstRewriter.this.copyFlow(nodes, cfg, this.newPos());
                }
                return this.theCfg;
            }

            @Override
            public CAstSourcePositionMap newPos() {
                if (this.theSource == null && pos != null) {
                    this.theSource = CAstRewriter.this.copySource(nodes, pos);
                }
                return this.theSource;
            }

            @Override
            public CAstNodeTypeMap newTypes() {
                if (this.theTypes == null && types != null) {
                    this.theTypes = CAstRewriter.this.copyTypes(nodes, types);
                }
                return this.theTypes;
            }

            @Override
            public Map<CAstNode, Collection<CAstEntity>> newChildren() {
                if (this.theChildren == null) {
                    this.theChildren = CAstRewriter.this.copyChildren(root, nodes, children);
                }
                return this.theChildren;
            }
        };
    }

    public CAstEntity rewrite(final CAstEntity root) {
        if (root.getAST() != null) {
            final Rewrite rewrite = this.rewrite(root.getAST(), root.getControlFlow(), root.getSourceMap(), root.getNodeTypeMap(), root.getAllScopedEntities(), root.getArgumentDefaults());
            return new DelegatingEntity(root){

                public String toString() {
                    return root.toString() + " (clone)";
                }

                @Override
                public Iterator<CAstEntity> getScopedEntities(CAstNode construct) {
                    Map<CAstNode, Collection<CAstEntity>> newChildren = this.getAllScopedEntities();
                    if (newChildren.containsKey(construct)) {
                        return newChildren.get(construct).iterator();
                    }
                    return EmptyIterator.instance();
                }

                @Override
                public Map<CAstNode, Collection<CAstEntity>> getAllScopedEntities() {
                    return rewrite.newChildren();
                }

                @Override
                public CAstNode getAST() {
                    return rewrite.newRoot();
                }

                @Override
                public CAstNodeTypeMap getNodeTypeMap() {
                    return rewrite.newTypes();
                }

                @Override
                public CAstSourcePositionMap getSourceMap() {
                    return rewrite.newPos();
                }

                @Override
                public CAstControlFlowMap getControlFlow() {
                    return rewrite.newCfg();
                }

                @Override
                public CAstNode[] getArgumentDefaults() {
                    return rewrite.newDefaults();
                }
            };
        }
        if (this.recursive) {
            Map<CAstNode, Collection<CAstEntity>> children = root.getAllScopedEntities();
            final LinkedHashMap newChildren = new LinkedHashMap();
            for (Map.Entry<CAstNode, Collection<CAstEntity>> entry : children.entrySet()) {
                CAstNode key = entry.getKey();
                LinkedHashSet<CAstEntity> newValues = new LinkedHashSet<CAstEntity>();
                newChildren.put(key, newValues);
                for (CAstEntity entity : entry.getValue()) {
                    newValues.add(this.rewrite(entity));
                }
            }
            return new DelegatingEntity(root){

                public String toString() {
                    return root.toString() + " (clone)";
                }

                @Override
                public Iterator<CAstEntity> getScopedEntities(CAstNode construct) {
                    if (newChildren.containsKey(construct)) {
                        return ((Collection)newChildren.get(construct)).iterator();
                    }
                    return EmptyIterator.instance();
                }

                @Override
                public Map<CAstNode, Collection<CAstEntity>> getAllScopedEntities() {
                    return newChildren;
                }
            };
        }
        return root;
    }

    public static interface Rewrite {
        public CAstNode newRoot();

        public CAstControlFlowMap newCfg();

        public CAstSourcePositionMap newPos();

        public CAstNodeTypeMap newTypes();

        public Map<CAstNode, Collection<CAstEntity>> newChildren();

        public CAstNode[] newDefaults();
    }

    public static interface RewriteContext<K extends CopyKey<K>> {
        public K key();
    }

    public static interface CopyKey<Self extends CopyKey<Self>> {
        public int hashCode();

        public boolean equals(Object var1);

        public Self parent();
    }
}

