/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.visit;

import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.util.CAstPrinter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class CAstVisitor<C extends Context> {
    public static boolean DEBUG = true;
    protected CAstSourcePositionMap.Position currentPosition;
    private final Map<CAstEntity, CAstEntity> entityParents = HashMapFactory.make();

    public CAstSourcePositionMap.Position getCurrentPosition() {
        return this.currentPosition;
    }

    protected CAstVisitor() {
    }

    protected C makeFileContext(C context, CAstEntity n) {
        return context;
    }

    protected C makeTypeContext(C context, CAstEntity n) {
        return context;
    }

    protected C makeCodeContext(C context, CAstEntity n) {
        return context;
    }

    protected C makeLocalContext(C context, CAstNode n) {
        return context;
    }

    protected C makeUnwindContext(C context, CAstNode n, CAstVisitor<C> visitor) {
        return context;
    }

    protected CAstEntity getParent(CAstEntity entity) {
        return this.entityParents.get(entity);
    }

    protected void setParent(CAstEntity entity, CAstEntity parent) {
        this.entityParents.put(entity, parent);
    }

    protected boolean doVisitEntity(CAstEntity n, C context, CAstVisitor<C> visitor) {
        return false;
    }

    public final void visitScopedEntities(CAstEntity n, Map<CAstNode, Collection<CAstEntity>> allScopedEntities, C context, CAstVisitor<C> visitor) {
        for (Collection<CAstEntity> collection : allScopedEntities.values()) {
            this.visitScopedEntities(n, collection.iterator(), context, visitor);
        }
    }

    public final void visitScopedEntities(CAstEntity n, Iterator<CAstEntity> i, C context, CAstVisitor<C> visitor) {
        while (i.hasNext()) {
            CAstEntity child = i.next();
            this.setParent(child, n);
            visitor.visitEntities(child, context, visitor);
        }
    }

    protected C getCodeContext(C context) {
        return context;
    }

    public final void visitEntities(CAstEntity n, C context, CAstVisitor<C> visitor) {
        CAstSourcePositionMap.Position restore = this.currentPosition;
        this.currentPosition = n.getPosition() != null ? n.getPosition() : null;
        if (visitor.enterEntity(n, context, visitor)) {
            return;
        }
        switch (n.getKind()) {
            case 5: {
                C fileContext = visitor.makeFileContext(context, n);
                if (visitor.visitFileEntity(n, context, fileContext, visitor)) break;
                visitor.visitScopedEntities(n, n.getAllScopedEntities(), fileContext, visitor);
                visitor.leaveFileEntity(n, context, fileContext, visitor);
                break;
            }
            case 4: {
                if (visitor.visitFieldEntity(n, context, visitor)) break;
                visitor.leaveFieldEntity(n, context, visitor);
                break;
            }
            case 8: {
                if (visitor.visitGlobalEntity(n, context, visitor)) break;
                visitor.leaveGlobalEntity(n, context, visitor);
                break;
            }
            case 3: {
                C typeContext = visitor.makeTypeContext(context, n);
                if (visitor.visitTypeEntity(n, context, typeContext, visitor)) break;
                visitor.visitScopedEntities(n, n.getAllScopedEntities(), typeContext, visitor);
                visitor.leaveTypeEntity(n, context, typeContext, visitor);
                break;
            }
            case 1: {
                for (CAstNode dflt : n.getArgumentDefaults()) {
                    visitor.visit(dflt, this.getCodeContext(context), visitor);
                    visitor.visitScopedEntities(context.top(), context.top().getScopedEntities(dflt), context, visitor);
                }
                C codeContext = visitor.makeCodeContext(context, n);
                if (visitor.visitFunctionEntity(n, context, codeContext, visitor)) break;
                if (n.getAST() != null) {
                    visitor.visit(n.getAST(), codeContext, visitor);
                }
                visitor.visitScopedEntities(n, n.getScopedEntities(null), codeContext, visitor);
                visitor.leaveFunctionEntity(n, context, codeContext, visitor);
                break;
            }
            case 7: {
                C codeContext = visitor.makeCodeContext(context, n);
                if (visitor.visitMacroEntity(n, context, codeContext, visitor)) break;
                if (n.getAST() != null) {
                    visitor.visit(n.getAST(), codeContext, visitor);
                }
                visitor.visitScopedEntities(n, n.getScopedEntities(null), codeContext, visitor);
                visitor.leaveMacroEntity(n, context, codeContext, visitor);
                break;
            }
            case 2: {
                C codeContext = visitor.makeCodeContext(context, n);
                if (visitor.visitScriptEntity(n, context, codeContext, visitor)) break;
                if (n.getAST() != null) {
                    visitor.visit(n.getAST(), codeContext, visitor);
                }
                visitor.visitScopedEntities(n, n.getScopedEntities(null), codeContext, visitor);
                visitor.leaveScriptEntity(n, context, codeContext, visitor);
                break;
            }
            default: {
                if (visitor.doVisitEntity(n, context, visitor)) break;
                System.err.println("No handler for entity " + n.getName());
                Assertions.UNREACHABLE("cannot handle entity of kind" + n.getKind());
            }
        }
        visitor.postProcessEntity(n, context, visitor);
        this.currentPosition = restore;
    }

    protected boolean enterEntity(CAstEntity n, C context, CAstVisitor<C> visitor) {
        return false;
    }

    protected void postProcessEntity(CAstEntity n, C context, CAstVisitor<C> visitor) {
    }

    public boolean visitEntity(CAstEntity n, C context, CAstVisitor<C> visitor) {
        return false;
    }

    public void leaveEntity(CAstEntity n, C context, CAstVisitor<C> visitor) {
    }

    protected boolean visitFileEntity(CAstEntity n, C context, C fileC, CAstVisitor<C> visitor) {
        return visitor.visitEntity(n, context, visitor);
    }

    protected void leaveFileEntity(CAstEntity n, C context, C fileContext, CAstVisitor<C> visitor) {
        visitor.leaveEntity(n, context, visitor);
    }

    protected boolean visitFieldEntity(CAstEntity n, C context, CAstVisitor<C> visitor) {
        return visitor.visitEntity(n, context, visitor);
    }

    protected void leaveFieldEntity(CAstEntity n, C context, CAstVisitor<C> visitor) {
        visitor.leaveEntity(n, context, visitor);
    }

    protected boolean visitGlobalEntity(CAstEntity n, C context, CAstVisitor<C> visitor) {
        return visitor.visitEntity(n, context, visitor);
    }

    protected void leaveGlobalEntity(CAstEntity n, C context, CAstVisitor<C> visitor) {
        visitor.leaveEntity(n, context, visitor);
    }

    protected boolean visitTypeEntity(CAstEntity n, C context, C typeContext, CAstVisitor<C> visitor) {
        return visitor.visitEntity(n, context, visitor);
    }

    protected void leaveTypeEntity(CAstEntity n, C context, C typeContext, CAstVisitor<C> visitor) {
        visitor.leaveEntity(n, context, visitor);
    }

    protected boolean visitFunctionEntity(CAstEntity n, C context, C codeContext, CAstVisitor<C> visitor) {
        return visitor.visitEntity(n, context, visitor);
    }

    protected void leaveFunctionEntity(CAstEntity n, C context, C codeContext, CAstVisitor<C> visitor) {
        visitor.leaveEntity(n, context, visitor);
    }

    protected boolean visitMacroEntity(CAstEntity n, C context, C codeContext, CAstVisitor<C> visitor) {
        return visitor.visitEntity(n, context, visitor);
    }

    protected void leaveMacroEntity(CAstEntity n, C context, C codeContext, CAstVisitor<C> visitor) {
        visitor.leaveEntity(n, context, visitor);
    }

    protected boolean visitScriptEntity(CAstEntity n, C context, C codeContext, CAstVisitor<C> visitor) {
        return visitor.visitEntity(n, context, visitor);
    }

    protected void leaveScriptEntity(CAstEntity n, C context, C codeContext, CAstVisitor<C> visitor) {
        visitor.leaveEntity(n, context, visitor);
    }

    protected boolean doVisit(CAstNode n, C context, CAstVisitor<C> visitor) {
        return false;
    }

    protected boolean doVisitAssignNodes(CAstNode n, C context, CAstNode v, CAstNode a, CAstVisitor<C> visitor) {
        return false;
    }

    public final void visitChildren(CAstNode n, int start, C context, CAstVisitor<C> visitor) {
        int end = n.getChildCount();
        for (int i = start; i < end; ++i) {
            visitor.visit(n.getChild(i), context, visitor);
        }
    }

    public final void visitAllChildren(CAstNode n, C context, CAstVisitor<C> visitor) {
        visitor.visitChildren(n, 0, context, visitor);
    }

    public final void visit(CAstNode n, C context, CAstVisitor<C> visitor) {
        CAstSourcePositionMap.Position p;
        CAstSourcePositionMap.Position restore = this.currentPosition;
        if (context != null && context.getSourceMap() != null && (p = context.getSourceMap().getPosition(n)) != null) {
            this.currentPosition = p;
        }
        if (visitor.enterNode(n, context, visitor)) {
            return;
        }
        int NT = n.getKind();
        switch (NT) {
            case 100: {
                if (visitor.visitFunctionExpr(n, context, visitor)) break;
                visitor.leaveFunctionExpr(n, context, visitor);
                break;
            }
            case 13: {
                if (visitor.visitFunctionStmt(n, context, visitor)) break;
                visitor.leaveFunctionStmt(n, context, visitor);
                break;
            }
            case 29: {
                if (visitor.visitClassStmt(n, context, visitor)) break;
                visitor.leaveClassStmt(n, context, visitor);
                break;
            }
            case 200: {
                if (visitor.visitLocalScope(n, context, visitor)) break;
                C localContext = visitor.makeLocalContext(context, n);
                visitor.visit(n.getChild(0), localContext, visitor);
                visitor.leaveLocalScope(n, context, visitor);
                break;
            }
            case 201: {
                if (visitor.visitSpecialParentScope(n, context, visitor)) break;
                C localContext = visitor.makeSpecialParentContext(context, n);
                visitor.visit(n.getChild(1), localContext, visitor);
                visitor.leaveSpecialParentScope(n, context, visitor);
                break;
            }
            case 104: {
                if (visitor.visitBlockExpr(n, context, visitor)) break;
                visitor.visitAllChildren(n, context, visitor);
                visitor.leaveBlockExpr(n, context, visitor);
                break;
            }
            case 3: {
                if (visitor.visitBlockStmt(n, context, visitor)) break;
                visitor.visitAllChildren(n, context, visitor);
                visitor.leaveBlockStmt(n, context, visitor);
                break;
            }
            case 2: {
                if (visitor.visitLoop(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveLoopHeader(n, context, visitor);
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveLoop(n, context, visitor);
                break;
            }
            case 27: {
                if (visitor.visitForIn(n, context, visitor)) break;
                visitor.leaveForIn(n, context, visitor);
                break;
            }
            case 103: {
                if (visitor.visitGetCaughtException(n, context, visitor)) break;
                visitor.leaveGetCaughtException(n, context, visitor);
                break;
            }
            case 116: {
                if (visitor.visitThis(n, context, visitor)) break;
                visitor.leaveThis(n, context, visitor);
                break;
            }
            case 115: {
                if (visitor.visitSuper(n, context, visitor)) break;
                visitor.leaveSuper(n, context, visitor);
                break;
            }
            case 102: {
                if (visitor.visitCall(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.visitChildren(n, 2, context, visitor);
                visitor.leaveCall(n, context, visitor);
                break;
            }
            case 111: {
                if (visitor.visitVar(n, context, visitor)) break;
                visitor.leaveVar(n, context, visitor);
                break;
            }
            case 300: {
                if (visitor.visitConstant(n, context, visitor)) break;
                visitor.leaveConstant(n, context, visitor);
                break;
            }
            case 105: {
                if (visitor.visitBinaryExpr(n, context, visitor)) break;
                visitor.visit(n.getChild(1), context, visitor);
                visitor.visit(n.getChild(2), context, visitor);
                visitor.leaveBinaryExpr(n, context, visitor);
                break;
            }
            case 106: {
                if (visitor.visitUnaryExpr(n, context, visitor)) break;
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveUnaryExpr(n, context, visitor);
                break;
            }
            case 121: {
                if (visitor.visitArrayLength(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveArrayLength(n, context, visitor);
                break;
            }
            case 120: {
                if (visitor.visitArrayRef(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.visitChildren(n, 2, context, visitor);
                visitor.leaveArrayRef(n, context, visitor);
                break;
            }
            case 6: {
                if (visitor.visitDeclStmt(n, context, visitor)) break;
                if (n.getChildCount() == 2) {
                    visitor.visit(n.getChild(1), context, visitor);
                }
                visitor.leaveDeclStmt(n, context, visitor);
                break;
            }
            case 7: {
                if (visitor.visitReturn(n, context, visitor)) break;
                if (n.getChildCount() > 0) {
                    visitor.visit(n.getChild(0), context, visitor);
                }
                visitor.leaveReturn(n, context, visitor);
                break;
            }
            case 18: {
                if (visitor.visitIfgoto(n, context, visitor)) break;
                if (n.getChildCount() == 1) {
                    visitor.visit(n.getChild(0), context, visitor);
                } else if (n.getChildCount() == 3) {
                    visitor.visit(n.getChild(1), context, visitor);
                    visitor.visit(n.getChild(2), context, visitor);
                } else {
                    Assertions.UNREACHABLE();
                }
                visitor.leaveIfgoto(n, context, visitor);
                break;
            }
            case 8: {
                if (visitor.visitGoto(n, context, visitor)) break;
                visitor.leaveGoto(n, context, visitor);
                break;
            }
            case 17: {
                if (visitor.visitLabelStmt(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                if (n.getChildCount() == 2) {
                    visitor.visit(n.getChild(1), context, visitor);
                } else assert (n.getChildCount() < 2);
                visitor.leaveLabelStmt(n, context, visitor);
                break;
            }
            case 11: {
                if (visitor.visitIfStmt(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveIfStmtCondition(n, context, visitor);
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveIfStmtTrueClause(n, context, visitor);
                if (n.getChildCount() == 3) {
                    visitor.visit(n.getChild(2), context, visitor);
                }
                visitor.leaveIfStmt(n, context, visitor);
                break;
            }
            case 107: {
                if (visitor.visitIfExpr(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveIfExprCondition(n, context, visitor);
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveIfExprTrueClause(n, context, visitor);
                if (n.getChildCount() == 3) {
                    visitor.visit(n.getChild(2), context, visitor);
                }
                visitor.leaveIfExpr(n, context, visitor);
                break;
            }
            case 109: 
            case 131: {
                if (visitor.visitNew(n, context, visitor)) break;
                this.visitChildren(n, 1, context, visitor);
                visitor.leaveNew(n, context, visitor);
                break;
            }
            case 110: {
                if (visitor.visitObjectLiteral(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                for (int i = 1; i < n.getChildCount(); i += 2) {
                    visitor.visit(n.getChild(i), context, visitor);
                    visitor.visit(n.getChild(i + 1), context, visitor);
                    visitor.leaveObjectLiteralFieldInit(n, i, context, visitor);
                }
                visitor.leaveObjectLiteral(n, context, visitor);
                break;
            }
            case 117: {
                if (visitor.visitArrayLiteral(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveArrayLiteralObject(n, context, visitor);
                for (int i = 1; i < n.getChildCount(); ++i) {
                    visitor.visit(n.getChild(i), context, visitor);
                    visitor.leaveArrayLiteralInitElement(n, i, context, visitor);
                }
                visitor.leaveArrayLiteral(n, context, visitor);
                break;
            }
            case 112: {
                if (visitor.visitObjectRef(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveObjectRef(n, context, visitor);
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                if (visitor.visitAssign(n, context, visitor)) break;
                visitor.visit(n.getChild(1), context, visitor);
                if (visitor.visitAssignNodes(n.getChild(0), context, n.getChild(1), n, visitor)) break;
                visitor.leaveAssign(n, context, visitor);
                break;
            }
            case 1: {
                if (visitor.visitSwitch(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveSwitchValue(n, context, visitor);
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveSwitch(n, context, visitor);
                break;
            }
            case 12: {
                if (visitor.visitThrow(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveThrow(n, context, visitor);
                break;
            }
            case 21: {
                if (visitor.visitCatch(n, context, visitor)) break;
                visitor.visitChildren(n, 1, context, visitor);
                visitor.leaveCatch(n, context, visitor);
                break;
            }
            case 22: {
                if (visitor.visitUnwind(n, context, visitor)) break;
                C unwindContext = visitor.makeUnwindContext(context, n.getChild(1), visitor);
                visitor.visit(n.getChild(0), unwindContext, visitor);
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveUnwind(n, context, visitor);
                break;
            }
            case 4: {
                if (visitor.visitTry(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveTryBlock(n, context, visitor);
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveTry(n, context, visitor);
                break;
            }
            case 19: {
                if (visitor.visitEmpty(n, context, visitor)) break;
                visitor.leaveEmpty(n, context, visitor);
                break;
            }
            case 400: {
                if (visitor.visitPrimitive(n, context, visitor)) break;
                visitor.visitAllChildren(n, context, visitor);
                visitor.leavePrimitive(n, context, visitor);
                break;
            }
            case 402: {
                if (visitor.visitVoid(n, context, visitor)) break;
                visitor.leaveVoid(n, context, visitor);
                break;
            }
            case 118: {
                if (visitor.visitCast(n, context, visitor)) break;
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveCast(n, context, visitor);
                break;
            }
            case 119: {
                if (visitor.visitInstanceOf(n, context, visitor)) break;
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveInstanceOf(n, context, visitor);
                break;
            }
            case 403: {
                if (visitor.visitAssert(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveAssert(n, context, visitor);
                break;
            }
            case 124: {
                if (visitor.visitEachElementGet(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveEachElementGet(n, context, visitor);
                break;
            }
            case 123: {
                if (visitor.visitEachElementHasNext(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.visit(n.getChild(1), context, visitor);
                visitor.leaveEachElementHasNext(n, context, visitor);
                break;
            }
            case 127: {
                if (visitor.visitTypeLiteralExpr(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                visitor.leaveTypeLiteralExpr(n, context, visitor);
                break;
            }
            case 128: {
                if (visitor.visitIsDefinedExpr(n, context, visitor)) break;
                visitor.visit(n.getChild(0), context, visitor);
                if (n.getChildCount() == 2) {
                    visitor.visit(n.getChild(1), context, visitor);
                }
                visitor.leaveIsDefinedExpr(n, context, visitor);
                break;
            }
            case 404: {
                if (visitor.visitInclude(n, context, visitor)) break;
                visitor.leaveInclude(n, context, visitor);
                break;
            }
            case 129: {
                if (visitor.visitMacroVar(n, context, visitor)) break;
                visitor.leaveMacroVar(n, context, visitor);
                break;
            }
            case 25: {
                if (visitor.visitEcho(n, context, visitor)) break;
                this.visitAllChildren(n, context, visitor);
                visitor.leaveEcho(n, context, visitor);
                break;
            }
            case 20: {
                if (visitor.visitYield(n, context, visitor)) break;
                this.visitAllChildren(n, context, visitor);
                visitor.leaveYield(n, context, visitor);
                break;
            }
            default: {
                if (visitor.doVisit(n, context, visitor)) break;
                System.err.println("looking at unhandled " + n + '(' + NT + ')' + " of " + n.getClass());
                Assertions.UNREACHABLE("cannot handle node of kind " + NT);
            }
        }
        if (context != null) {
            visitor.visitScopedEntities(context.top(), context.top().getScopedEntities(n), context, visitor);
        }
        visitor.postProcessNode(n, context, visitor);
        this.currentPosition = restore;
    }

    protected void leaveSpecialParentScope(CAstNode n, C context, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, context, visitor);
    }

    protected C makeSpecialParentContext(C context, CAstNode n) {
        return context;
    }

    protected boolean visitSpecialParentScope(CAstNode n, C context, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, context, visitor);
    }

    protected boolean doVisitArrayRefNode(CAstNode n, CAstNode v, CAstNode a, boolean assign, boolean preOp, C context, CAstVisitor<C> visitor) {
        if (assign ? visitor.visitArrayRefAssign(n, v, a, context, visitor) : visitor.visitArrayRefAssignOp(n, v, a, preOp, context, visitor)) {
            return true;
        }
        visitor.visit(n.getChild(0), context, visitor);
        visitor.visitChildren(n, 2, context, visitor);
        if (assign) {
            visitor.leaveArrayRefAssign(n, v, a, context, visitor);
        } else {
            visitor.leaveArrayRefAssignOp(n, v, a, preOp, context, visitor);
        }
        return false;
    }

    protected boolean visitAssignNodes(CAstNode n, C context, CAstNode v, CAstNode a, CAstVisitor<C> visitor) {
        int NT = a.getKind();
        boolean assign = NT == 14;
        boolean preOp = NT == 15;
        switch (n.getKind()) {
            case 120: {
                if (!this.doVisitArrayRefNode(n, v, a, assign, preOp, context, visitor)) break;
                return true;
            }
            case 112: {
                if (assign ? visitor.visitObjectRefAssign(n, v, a, context, visitor) : visitor.visitObjectRefAssignOp(n, v, a, preOp, context, visitor)) {
                    return true;
                }
                visitor.visit(n.getChild(0), context, visitor);
                if (assign) {
                    visitor.leaveObjectRefAssign(n, v, a, context, visitor);
                    break;
                }
                visitor.leaveObjectRefAssignOp(n, v, a, preOp, context, visitor);
                break;
            }
            case 104: {
                if (assign ? visitor.visitBlockExprAssign(n, v, a, context, visitor) : visitor.visitBlockExprAssignOp(n, v, a, preOp, context, visitor)) {
                    return true;
                }
                if (visitor.visitAssignNodes(n.getChild(n.getChildCount() - 1), context, v, a, visitor)) {
                    return true;
                }
                if (assign) {
                    visitor.leaveBlockExprAssign(n, v, a, context, visitor);
                    break;
                }
                visitor.leaveBlockExprAssignOp(n, v, a, preOp, context, visitor);
                break;
            }
            case 111: {
                if (assign ? visitor.visitVarAssign(n, v, a, context, visitor) : visitor.visitVarAssignOp(n, v, a, preOp, context, visitor)) {
                    return true;
                }
                if (assign) {
                    visitor.leaveVarAssign(n, v, a, context, visitor);
                    break;
                }
                visitor.leaveVarAssignOp(n, v, a, preOp, context, visitor);
                break;
            }
            case 117: {
                assert (assign);
                if (visitor.visitArrayLiteralAssign(n, v, a, context, visitor)) {
                    return true;
                }
                visitor.leaveArrayLiteralAssign(n, v, a, context, visitor);
                break;
            }
            case 110: {
                assert (assign);
                for (int i = 1; i < n.getChildCount(); i += 2) {
                    visitor.visit(n.getChild(i), context, visitor);
                }
                if (visitor.visitObjectLiteralAssign(n, v, a, context, visitor)) {
                    return true;
                }
                visitor.leaveObjectLiteralAssign(n, v, a, context, visitor);
                break;
            }
            default: {
                if (visitor.doVisitAssignNodes(n, context, a, v, visitor)) break;
                if (DEBUG) {
                    System.err.println("cannot handle assign to kind " + n.getKind());
                }
                throw new UnsupportedOperationException("cannot handle assignment: " + CAstPrinter.print(a, context.getSourceMap()));
            }
        }
        return false;
    }

    protected boolean enterNode(CAstNode n, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void postProcessNode(CAstNode n, C c, CAstVisitor<C> visitor) {
    }

    public boolean visitNode(CAstNode n, C c, CAstVisitor<C> visitor) {
        return false;
    }

    public void leaveNode(CAstNode n, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitFunctionExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveFunctionExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitFunctionStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveFunctionStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitClassStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveClassStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitLocalScope(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveLocalScope(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitBlockExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveBlockExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitBlockStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveBlockStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitLoop(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected boolean visitForIn(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveLoopHeader(CAstNode n, C c, CAstVisitor<C> visitor) {
    }

    protected void leaveLoop(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected void leaveForIn(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitGetCaughtException(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveGetCaughtException(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitThis(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveThis(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitSuper(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveSuper(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitCall(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveCall(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitVar(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveVar(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitConstant(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveConstant(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitBinaryExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveBinaryExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitUnaryExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveUnaryExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitArrayLength(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveArrayLength(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitArrayRef(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveArrayRef(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitDeclStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveDeclStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitReturn(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveReturn(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitYield(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveYield(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitIfgoto(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveIfgoto(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitGoto(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveGoto(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitLabelStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveLabelStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitIfStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveIfStmtCondition(CAstNode n, C c, CAstVisitor<C> visitor) {
    }

    protected void leaveIfStmtTrueClause(CAstNode n, C c, CAstVisitor<C> visitor) {
    }

    protected void leaveIfStmt(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitIfExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveIfExprCondition(CAstNode n, C c, CAstVisitor<C> visitor) {
    }

    protected void leaveIfExprTrueClause(CAstNode n, C c, CAstVisitor<C> visitor) {
    }

    protected void leaveIfExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitNew(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveNew(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitObjectLiteral(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveObjectLiteralFieldInit(CAstNode n, int i, C c, CAstVisitor<C> visitor) {
    }

    protected void leaveObjectLiteral(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitArrayLiteral(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveArrayLiteralObject(CAstNode n, C c, CAstVisitor<C> visitor) {
    }

    protected void leaveArrayLiteralInitElement(CAstNode n, int i, C c, CAstVisitor<C> visitor) {
    }

    protected void leaveArrayLiteral(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitObjectRef(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveObjectRef(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    public boolean visitAssign(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    public void leaveAssign(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitArrayRefAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void leaveArrayRefAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitArrayRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void leaveArrayRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitObjectRefAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void leaveObjectRefAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitObjectRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void leaveObjectRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitBlockExprAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void leaveBlockExprAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitBlockExprAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void leaveBlockExprAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitVarAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void leaveVarAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitArrayLiteralAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void leaveArrayLiteralAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitObjectLiteralAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void leaveObjectLiteralAssign(CAstNode n, CAstNode v, CAstNode a, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitVarAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, C c, CAstVisitor<C> visitor) {
        return false;
    }

    protected void leaveVarAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, C c, CAstVisitor<C> visitor) {
    }

    protected boolean visitSwitch(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveSwitchValue(CAstNode n, C c, CAstVisitor<C> visitor) {
    }

    protected void leaveSwitch(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitThrow(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveThrow(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitCatch(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveCatch(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitUnwind(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveUnwind(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitTry(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveTryBlock(CAstNode n, C c, CAstVisitor<C> visitor) {
    }

    protected void leaveTry(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitEmpty(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveEmpty(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitPrimitive(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leavePrimitive(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitVoid(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveVoid(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitCast(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveCast(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitInstanceOf(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveInstanceOf(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected void leaveAssert(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitAssert(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected boolean visitEachElementHasNext(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveEachElementHasNext(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitEachElementGet(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveEachElementGet(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitTypeLiteralExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveTypeLiteralExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitIsDefinedExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveIsDefinedExpr(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitEcho(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveEcho(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitInclude(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveInclude(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    protected boolean visitMacroVar(CAstNode n, C c, CAstVisitor<C> visitor) {
        return visitor.visitNode(n, c, visitor);
    }

    protected void leaveMacroVar(CAstNode n, C c, CAstVisitor<C> visitor) {
        visitor.leaveNode(n, c, visitor);
    }

    public static interface Context {
        public CAstEntity top();

        public CAstSourcePositionMap getSourceMap();
    }
}

