/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util;

import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.util.CAstPattern;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AstConstantCollector {
    public static final CAstPattern simplePreUpdatePattern = CAstPattern.parse("ASSIGN_PRE_OP(VAR(<name>CONSTANT()),**)");
    public static final CAstPattern simplePostUpdatePattern = CAstPattern.parse("ASSIGN_POST_OP(VAR(<name>CONSTANT()),**)");
    public static final CAstPattern simpleGlobalPattern = CAstPattern.parse("GLOBAL_DECL(@(VAR(<name>CONSTANT()))@)");
    public static final CAstPattern simpleValuePattern = CAstPattern.parse("ASSIGN(VAR(<name>CONSTANT()),<value>*)");

    public static Map<String, Object> collectConstants(CAstEntity function, Map<String, Object> values, Set<String> bad) {
        if (function.getAST() != null) {
            for (CAstPattern.Segments segments : CAstPattern.findAll(simplePreUpdatePattern, function)) {
                bad.add((String)segments.getSingle("name").getValue());
            }
            for (CAstPattern.Segments segments : CAstPattern.findAll(simpleGlobalPattern, function)) {
                segments.getMultiple("name").iterator().forEachRemaining(name -> bad.add((String)name.getValue()));
            }
            for (CAstPattern.Segments segments : CAstPattern.findAll(simplePostUpdatePattern, function)) {
                bad.add((String)segments.getSingle("name").getValue());
            }
            for (CAstPattern.Segments segments : CAstPattern.findAll(simpleValuePattern, function)) {
                String var = (String)segments.getSingle("name").getValue();
                if (segments.getSingle("value").getKind() != 300) {
                    bad.add(var);
                    continue;
                }
                Object val = segments.getSingle("value").getValue();
                if (bad.contains(var)) continue;
                if (values.containsKey(var)) {
                    if (!(val == null ? values.get(var) != null : !val.equals(values.get(var)))) continue;
                    values.remove(var);
                    bad.add(var);
                    continue;
                }
                values.put(var, val);
            }
        }
        for (Collection collection : function.getAllScopedEntities().values()) {
            for (CAstEntity ce : collection) {
                AstConstantCollector.collectConstants(ce, values, bad);
            }
        }
        bad.forEach(values::remove);
        for (Collection collection : function.getAllScopedEntities().values()) {
            for (CAstEntity ce : collection) {
                for (String s3 : ce.getArgumentNames()) {
                    values.remove(s3);
                }
            }
        }
        return values;
    }

    public static Map<String, Object> collectConstants(CAstEntity function) {
        HashMap<String, Object> values = HashMapFactory.make();
        HashSet<String> bad = HashSetFactory.make();
        AstConstantCollector.collectConstants(function, values, bad);
        return values;
    }
}

