/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.cdg;

import com.ibm.wala.cfg.MinimalCFG;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.dominators.DominanceFrontiers;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ControlDependenceGraph<T>
extends AbstractNumberedGraph<T> {
    private final MinimalCFG<T> cfg;
    private final NumberedEdgeManager<T> edgeManager;
    private Map<Pair<T, T>, Set<? extends Object>> edgeLabels;

    private Map<T, Set<T>> buildControlDependence(boolean wantEdgeLabels) {
        HashMap controlDependence = HashMapFactory.make(this.cfg.getNumberOfNodes());
        DominanceFrontiers<T> RDF = new DominanceFrontiers<T>(GraphInverter.invert(this.cfg), this.cfg.exit());
        if (wantEdgeLabels) {
            this.edgeLabels = HashMapFactory.make();
        }
        for (Object name : this.cfg) {
            HashSet s2 = HashSetFactory.make(2);
            controlDependence.put(name, s2);
        }
        for (Object y : this.cfg) {
            for (T x : Iterator2Iterable.make(RDF.getDominanceFrontier(y))) {
                ((Set)controlDependence.get(x)).add(y);
                if (!wantEdgeLabels) continue;
                HashSet labels = HashSetFactory.make();
                this.edgeLabels.put(Pair.make(x, y), labels);
                for (T s3 : Iterator2Iterable.make(this.cfg.getSuccNodes(x))) {
                    if (!RDF.isDominatedBy(s3, y)) continue;
                    labels.add(this.makeEdgeLabel(x, y, s3));
                }
            }
        }
        return controlDependence;
    }

    protected Object makeEdgeLabel(T from, T to, T s2) {
        return s2;
    }

    private NumberedEdgeManager<T> constructGraphEdges(final Map<T, Set<T>> forwardEdges) {
        return new NumberedEdgeManager<T>(){
            final Map<T, Set<T>> backwardEdges;
            {
                this.backwardEdges = HashMapFactory.make(forwardEdges.size());
                for (Object t : ControlDependenceGraph.this.cfg) {
                    HashSet s2 = HashSetFactory.make();
                    this.backwardEdges.put(t, s2);
                }
                for (Map.Entry entry : forwardEdges.entrySet()) {
                    Iterator iterator = ((Set)entry.getValue()).iterator();
                    while (iterator.hasNext()) {
                        Object t;
                        Object n = t = iterator.next();
                        this.backwardEdges.get(n).add(entry.getKey());
                    }
                }
            }

            @Override
            public Iterator<T> getPredNodes(T N) {
                if (this.backwardEdges.containsKey(N)) {
                    return this.backwardEdges.get(N).iterator();
                }
                return EmptyIterator.instance();
            }

            @Override
            public IntSet getPredNodeNumbers(T node) {
                MutableIntSet x = IntSetUtil.make();
                if (this.backwardEdges.containsKey(node)) {
                    for (Object pred : this.backwardEdges.get(node)) {
                        x.add(ControlDependenceGraph.this.cfg.getNumber(pred));
                    }
                }
                return x;
            }

            @Override
            public int getPredNodeCount(T N) {
                if (this.backwardEdges.containsKey(N)) {
                    return this.backwardEdges.get(N).size();
                }
                return 0;
            }

            @Override
            public Iterator<T> getSuccNodes(T N) {
                if (forwardEdges.containsKey(N)) {
                    return ((Set)forwardEdges.get(N)).iterator();
                }
                return EmptyIterator.instance();
            }

            @Override
            public IntSet getSuccNodeNumbers(T node) {
                MutableIntSet x = IntSetUtil.make();
                if (forwardEdges.containsKey(node)) {
                    for (Object succ : (Set)forwardEdges.get(node)) {
                        x.add(ControlDependenceGraph.this.cfg.getNumber(succ));
                    }
                }
                return x;
            }

            @Override
            public int getSuccNodeCount(T N) {
                if (forwardEdges.containsKey(N)) {
                    return ((Set)forwardEdges.get(N)).size();
                }
                return 0;
            }

            @Override
            public boolean hasEdge(T src, T dst) {
                return forwardEdges.containsKey(src) && ((Set)forwardEdges.get(src)).contains(dst);
            }

            @Override
            public void addEdge(T src, T dst) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeEdge(T src, T dst) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeAllIncidentEdges(T node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeIncomingEdges(T node) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeOutgoingEdges(T node) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Object n : this) {
            sb.append(n.toString()).append('\n');
            for (Object s2 : Iterator2Iterable.make(this.getSuccNodes(n))) {
                sb.append("  --> ").append(s2);
                if (this.edgeLabels != null) {
                    for (Object object : this.edgeLabels.get(Pair.make(n, s2))) {
                        sb.append("\n   label: ").append(object);
                    }
                }
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public ControlDependenceGraph(MinimalCFG<T> cfg, boolean wantEdgeLabels) {
        if (cfg == null) {
            throw new IllegalArgumentException("null cfg");
        }
        this.cfg = cfg;
        this.edgeManager = this.constructGraphEdges(this.buildControlDependence(wantEdgeLabels));
    }

    public ControlDependenceGraph(MinimalCFG<T> cfg) {
        this(cfg, false);
    }

    public MinimalCFG<T> getControlFlowGraph() {
        return this.cfg;
    }

    public Set<? extends Object> getEdgeLabels(T from, T to) {
        return this.edgeLabels.get(Pair.make(from, to));
    }

    @Override
    public NumberedNodeManager<T> getNodeManager() {
        return this.cfg;
    }

    @Override
    public NumberedEdgeManager<T> getEdgeManager() {
        return this.edgeManager;
    }

    public boolean controlEquivalent(T bb1, T bb2) {
        if (this.getPredNodeCount(bb1) != this.getPredNodeCount(bb2)) {
            return false;
        }
        for (T pb : Iterator2Iterable.make(this.getPredNodes(bb1))) {
            if (this.hasEdge(pb, bb2)) continue;
            return false;
        }
        return true;
    }
}

