/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.intra;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.exc.intra.MethodState;
import com.ibm.wala.cfg.exc.intra.NegativeGraphFilter;
import com.ibm.wala.cfg.exc.intra.NullPointerFrameWork;
import com.ibm.wala.cfg.exc.intra.NullPointerSolver;
import com.ibm.wala.cfg.exc.intra.NullPointerState;
import com.ibm.wala.cfg.exc.intra.NullPointerTransferFunctionProvider;
import com.ibm.wala.cfg.exc.intra.ParameterState;
import com.ibm.wala.ipa.cfg.PrunedCFG;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.SparseNumberedGraph;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IntraprocNullPointerAnalysis<T extends ISSABasicBlock> {
    private NullPointerSolver<T> solver;
    private final Set<TypeReference> ignoreExceptions;
    private final IR ir;
    private final ControlFlowGraph<SSAInstruction, T> cfg;
    private final int maxVarNum;
    private int deletedEdges;
    private ControlFlowGraph<SSAInstruction, T> pruned = null;
    private final ParameterState initialState;
    private final MethodState mState;

    IntraprocNullPointerAnalysis(IR ir, ControlFlowGraph<SSAInstruction, T> cfg, TypeReference[] ignoreExceptions, ParameterState initialState, MethodState mState) {
        this.cfg = cfg;
        this.ir = ir;
        this.maxVarNum = ir == null || ir.isEmptyIR() ? -1 : ir.getSymbolTable().getMaxValueNumber();
        this.ignoreExceptions = new HashSet<TypeReference>();
        if (ignoreExceptions != null) {
            this.ignoreExceptions.addAll(Arrays.asList(ignoreExceptions));
        }
        this.initialState = initialState;
        this.mState = mState;
    }

    private static <T extends ISSABasicBlock> List<T> searchNodesWithPathToCatchAll(ControlFlowGraph<SSAInstruction, T> cfg) {
        LinkedList<ISSABasicBlock> nodes = new LinkedList<ISSABasicBlock>();
        for (ISSABasicBlock exp : cfg) {
            List<ISSABasicBlock> excSucc = cfg.getExceptionalSuccessors(exp);
            if (excSucc == null || excSucc.size() <= 1) continue;
            boolean foundExit = false;
            boolean foundCatchAll = false;
            for (ISSABasicBlock succ : excSucc) {
                if (succ.isExitBlock()) {
                    foundExit = true;
                    continue;
                }
                if (!succ.isCatchBlock()) continue;
                Iterator<TypeReference> caught = succ.getCaughtExceptionTypes();
                while (caught.hasNext()) {
                    TypeReference t = caught.next();
                    if (!t.equals(TypeReference.JavaLangException) && !t.equals(TypeReference.JavaLangThrowable)) continue;
                    foundCatchAll = true;
                }
            }
            if (!foundExit || !foundCatchAll) continue;
            nodes.add(exp);
        }
        return nodes;
    }

    void run(MonitorUtil.IProgressMonitor progress) throws CancelException {
        if (this.pruned == null) {
            if (this.ir == null || this.ir.isEmptyIR()) {
                this.pruned = this.cfg;
            } else {
                List<ISSABasicBlock> catched = IntraprocNullPointerAnalysis.searchNodesWithPathToCatchAll(this.cfg);
                NullPointerFrameWork<T> problem = new NullPointerFrameWork<T>(this.cfg, this.ir);
                this.solver = new NullPointerSolver<ISSABasicBlock>(problem, this.maxVarNum, (ISSABasicBlock)this.cfg.entry(), this.ir, this.initialState);
                this.solver.solve(progress);
                Graph<ISSABasicBlock> deleted = this.createDeletedGraph();
                for (ISSABasicBlock ch : catched) {
                    deleted.addNode(ch);
                    deleted.addNode((ISSABasicBlock)this.cfg.exit());
                    deleted.addEdge(ch, (ISSABasicBlock)this.cfg.exit());
                }
                for (ISSABasicBlock node : deleted) {
                    this.deletedEdges += deleted.getSuccNodeCount(node);
                }
                NegativeGraphFilter<T> filter = new NegativeGraphFilter<T>(deleted);
                PrunedCFG<SSAInstruction, T> newCfg = PrunedCFG.make(this.cfg, filter);
                this.pruned = newCfg;
            }
        }
    }

    private Graph<T> createDeletedGraph() {
        NegativeCFGBuilderVisitor nCFGbuilder = new NegativeCFGBuilderVisitor();
        for (ISSABasicBlock bb : this.cfg) {
            nCFGbuilder.work(bb);
        }
        Graph deleted = nCFGbuilder.getNegativeCFG();
        return deleted;
    }

    ControlFlowGraph<SSAInstruction, T> getPrunedCFG() {
        if (this.pruned == null) {
            throw new IllegalStateException("Run analysis first! (call run())");
        }
        return this.pruned;
    }

    int getNumberOfDeletedEdges() {
        if (this.pruned == null) {
            throw new IllegalStateException("Run analysis first! (call run())");
        }
        return this.deletedEdges;
    }

    public NullPointerState getState(T block) {
        assert (this.pruned != null || this.solver != null) : "No solver initialized for method " + this.ir.getMethod().toString();
        if (this.pruned != null && this.solver == null) {
            return new NullPointerState(this.maxVarNum, this.ir.getSymbolTable(), this.initialState);
        }
        return (NullPointerState)this.solver.getOut(block);
    }

    private class NegativeCFGBuilderVisitor
    implements SSAInstruction.IVisitor {
        private final Graph<T> deleted = new SparseNumberedGraph(2);
        private NullPointerState currentState;
        private T currentBlock;

        private NegativeCFGBuilderVisitor() {
            for (ISSABasicBlock bb : IntraprocNullPointerAnalysis.this.cfg) {
                this.deleted.addNode(bb);
            }
        }

        public void work(T bb) {
            if (bb == null) {
                throw new IllegalArgumentException("Null not allowed");
            }
            if (!IntraprocNullPointerAnalysis.this.cfg.containsNode(bb)) {
                throw new IllegalArgumentException("Block not part of current CFG");
            }
            SSAInstruction instr = NullPointerTransferFunctionProvider.getRelevantInstruction(bb);
            if (instr != null) {
                this.currentState = IntraprocNullPointerAnalysis.this.getState(bb);
                this.currentBlock = bb;
                instr.visit(this);
                this.currentState = null;
                this.currentBlock = null;
            }
        }

        public Graph<T> getNegativeCFG() {
            return this.deleted;
        }

        private boolean isOnlyNullPointerExc(SSAInstruction instr) {
            assert (instr.isPEI());
            if (instr instanceof SSAAbstractInvokeInstruction) {
                return IntraprocNullPointerAnalysis.this.mState != null && !IntraprocNullPointerAnalysis.this.mState.throwsException((SSAAbstractInvokeInstruction)instr);
            }
            Collection<TypeReference> exc = instr.getExceptionTypes();
            HashSet<TypeReference> myExcs = new HashSet<TypeReference>(exc);
            myExcs.removeAll(IntraprocNullPointerAnalysis.this.ignoreExceptions);
            return myExcs.size() == 1 && myExcs.contains(TypeReference.JavaLangNullPointerException);
        }

        private boolean noExceptions(SSAInstruction instr) {
            assert (instr.isPEI());
            if (instr instanceof SSAAbstractInvokeInstruction) {
                assert (((SSAAbstractInvokeInstruction)instr).isStatic());
                return IntraprocNullPointerAnalysis.this.mState != null && !IntraprocNullPointerAnalysis.this.mState.throwsException((SSAAbstractInvokeInstruction)instr);
            }
            Collection<TypeReference> exc = instr.getExceptionTypes();
            HashSet<TypeReference> myExcs = new HashSet<TypeReference>(exc);
            myExcs.removeAll(IntraprocNullPointerAnalysis.this.ignoreExceptions);
            return myExcs.isEmpty();
        }

        private void removeImpossibleSuccessors(SSAInstruction instr, int varNum) {
            block2: {
                block3: {
                    if (!this.isOnlyNullPointerExc(instr)) break block2;
                    if (!this.currentState.isNeverNull(varNum)) break block3;
                    for (ISSABasicBlock succ : IntraprocNullPointerAnalysis.this.cfg.getExceptionalSuccessors(this.currentBlock)) {
                        this.deleted.addEdge((ISSABasicBlock)this.currentBlock, succ);
                    }
                    break block2;
                }
                if (!this.currentState.isAlwaysNull(varNum)) break block2;
                for (ISSABasicBlock succ : IntraprocNullPointerAnalysis.this.cfg.getNormalSuccessors(this.currentBlock)) {
                    this.deleted.addEdge((ISSABasicBlock)this.currentBlock, succ);
                }
            }
        }

        private void removeImpossibleSuccessors(SSAInstruction instr) {
            if (this.noExceptions(instr)) {
                for (ISSABasicBlock succ : IntraprocNullPointerAnalysis.this.cfg.getExceptionalSuccessors(this.currentBlock)) {
                    this.deleted.addEdge((ISSABasicBlock)this.currentBlock, succ);
                }
            }
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            int varNum = instruction.getArrayRef();
            this.removeImpossibleSuccessors(instruction, varNum);
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            int varNum = instruction.getArrayRef();
            this.removeImpossibleSuccessors(instruction, varNum);
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            int varNum = instruction.getArrayRef();
            this.removeImpossibleSuccessors(instruction, varNum);
        }

        @Override
        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
        }

        @Override
        public void visitComparison(SSAComparisonInstruction instruction) {
        }

        @Override
        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
        }

        @Override
        public void visitConversion(SSAConversionInstruction instruction) {
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            if (!instruction.isStatic()) {
                int varNum = instruction.getRef();
                this.removeImpossibleSuccessors(instruction, varNum);
            }
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
        }

        @Override
        public void visitGoto(SSAGotoInstruction instruction) {
        }

        @Override
        public void visitInstanceof(SSAInstanceofInstruction instruction) {
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            if (!instruction.isStatic()) {
                int varNum = instruction.getReceiver();
                this.removeImpossibleSuccessors(instruction, varNum);
            } else {
                this.removeImpossibleSuccessors(instruction);
            }
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
        }

        @Override
        public void visitMonitor(SSAMonitorInstruction instruction) {
            int varNum = instruction.getRef();
            this.removeImpossibleSuccessors(instruction, varNum);
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            this.removeImpossibleSuccessors(instruction);
        }

        @Override
        public void visitPhi(SSAPhiInstruction instruction) {
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            if (!instruction.isStatic()) {
                int varNum = instruction.getRef();
                this.removeImpossibleSuccessors(instruction, varNum);
            }
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
        }

        @Override
        public void visitSwitch(SSASwitchInstruction instruction) {
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
        }

        @Override
        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
        }
    }
}

