/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.io.FileProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;

public abstract class AbstractURLModule
implements Module,
ModuleEntry {
    private final URL url;

    public AbstractURLModule(URL url) {
        assert (url != null);
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    public String getName() {
        try {
            URLConnection con = this.url.openConnection();
            if (con instanceof JarURLConnection) {
                return ((JarURLConnection)con).getEntryName();
            }
            return new FileProvider().filePathFromURL(this.url);
        }
        catch (IOException e) {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            return this.url.openConnection().getInputStream();
        }
        catch (IOException e) {
            Assertions.UNREACHABLE();
            return null;
        }
    }

    @Override
    public boolean isModuleFile() {
        return false;
    }

    @Override
    public Module asModule() throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public String getClassName() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Iterator<ModuleEntry> getEntries() {
        return new NonNullSingletonIterator<ModuleEntry>(this);
    }

    @Override
    public Module getContainer() {
        return null;
    }

    public String toString() {
        return "module:" + this.url.toString();
    }
}

