/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.ArrayClassLoader;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderImpl;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class ClassLoaderFactoryImpl
implements ClassLoaderFactory {
    private final SetOfClasses exclusions;
    private final HashMap<ClassLoaderReference, IClassLoader> map = HashMapFactory.make(3);

    public ClassLoaderFactoryImpl(SetOfClasses exclusions) {
        this.exclusions = exclusions;
    }

    @Override
    public IClassLoader getLoader(ClassLoaderReference classLoaderReference, IClassHierarchy cha, AnalysisScope scope) throws IOException {
        if (classLoaderReference == null) {
            throw new IllegalArgumentException("null classLoaderReference");
        }
        IClassLoader result = this.map.get(classLoaderReference);
        if (result == null) {
            ClassLoaderReference parentRef = classLoaderReference.getParent();
            IClassLoader parent = null;
            if (parentRef != null) {
                parent = this.getLoader(parentRef, cha, scope);
            }
            IClassLoader cl = this.makeNewClassLoader(classLoaderReference, cha, parent, scope);
            this.map.put(classLoaderReference, cl);
            result = cl;
        }
        return result;
    }

    protected IClassLoader makeNewClassLoader(ClassLoaderReference classLoaderReference, IClassHierarchy cha, IClassLoader parent, AnalysisScope scope) throws IOException {
        IClassLoader cl;
        String implClass = scope.getLoaderImpl(classLoaderReference);
        if (implClass == null) {
            cl = new ClassLoaderImpl(classLoaderReference, scope.getArrayClassLoader(), parent, this.exclusions, cha);
        } else {
            try {
                Class<?> impl = Class.forName(implClass);
                Constructor<?> ctor = impl.getDeclaredConstructor(ClassLoaderReference.class, IClassLoader.class, SetOfClasses.class, IClassHierarchy.class);
                cl = (IClassLoader)ctor.newInstance(classLoaderReference, parent, this.exclusions, cha);
            }
            catch (Exception e) {
                try {
                    Class<?> impl = Class.forName(implClass);
                    Constructor<?> ctor = impl.getDeclaredConstructor(ClassLoaderReference.class, ArrayClassLoader.class, IClassLoader.class, SetOfClasses.class, IClassHierarchy.class);
                    cl = (IClassLoader)ctor.newInstance(classLoaderReference, scope.getArrayClassLoader(), parent, this.exclusions, cha);
                }
                catch (Exception e2) {
                    System.err.println("failed to load impl class " + implClass);
                    e2.printStackTrace(System.err);
                    Warnings.add(InvalidClassLoaderImplementation.create(implClass));
                    cl = new ClassLoaderImpl(classLoaderReference, scope.getArrayClassLoader(), parent, this.exclusions, cha);
                }
            }
        }
        cl.init(scope.getModules(classLoaderReference));
        return cl;
    }

    public SetOfClasses getExclusions() {
        return this.exclusions;
    }

    private static class InvalidClassLoaderImplementation
    extends Warning {
        final String impl;

        InvalidClassLoaderImplementation(String impl) {
            super((byte)2);
            this.impl = impl;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.impl;
        }

        public static InvalidClassLoaderImplementation create(String impl) {
            return new InvalidClassLoaderImplementation(impl);
        }
    }
}

