/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ShrikeCTMethod;
import com.ibm.wala.classLoader.SyntheticMethod;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CodeScanner {
    public static Collection<CallSiteReference> getCallSites(IMethod m3) throws InvalidClassFileException {
        if (m3 == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m3.isWalaSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m3;
            return CodeScanner.getCallSites(sm.getStatements());
        }
        return CodeScanner.getCallSitesFromShrikeBT((IBytecodeMethod)m3);
    }

    public static Collection<FieldReference> getFieldsRead(IMethod m3) throws InvalidClassFileException {
        if (m3 == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m3.isWalaSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m3;
            return CodeScanner.getFieldsRead(sm.getStatements());
        }
        return CodeScanner.getFieldsReadFromShrikeBT((ShrikeCTMethod)m3);
    }

    public static Collection<FieldReference> getFieldsWritten(IMethod m3) throws InvalidClassFileException {
        if (m3 == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m3.isWalaSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m3;
            return CodeScanner.getFieldsWritten(sm.getStatements());
        }
        return CodeScanner.getFieldsWrittenFromShrikeBT((ShrikeCTMethod)m3);
    }

    public static Collection<TypeReference> getArraysWritten(IMethod m3) throws InvalidClassFileException {
        if (m3 == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m3.isWalaSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m3;
            return CodeScanner.getArraysWritten(sm.getStatements());
        }
        return CodeScanner.getArraysWrittenFromShrikeBT((ShrikeCTMethod)m3);
    }

    public static Collection<NewSiteReference> getNewSites(IMethod m3) throws InvalidClassFileException {
        if (m3 == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m3.isWalaSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m3;
            return CodeScanner.getNewSites(sm.getStatements());
        }
        return CodeScanner.getNewSitesFromShrikeBT((ShrikeCTMethod)m3);
    }

    public static boolean hasObjectArrayLoad(IMethod m3) throws InvalidClassFileException {
        if (m3 == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m3.isWalaSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m3;
            return CodeScanner.hasObjectArrayLoad(sm.getStatements());
        }
        return CodeScanner.hasShrikeBTObjectArrayLoad((ShrikeCTMethod)m3);
    }

    public static boolean hasObjectArrayStore(IMethod m3) throws InvalidClassFileException {
        if (m3 == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m3.isWalaSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m3;
            return CodeScanner.hasObjectArrayStore(sm.getStatements());
        }
        return CodeScanner.hasShrikeBTObjectArrayStore((ShrikeCTMethod)m3);
    }

    public static Set<TypeReference> getCaughtExceptions(IMethod m3) throws InvalidClassFileException {
        if (m3 == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m3.isWalaSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m3;
            return CodeScanner.getCaughtExceptions(sm.getStatements());
        }
        return CodeScanner.getShrikeBTCaughtExceptions((ShrikeCTMethod)m3);
    }

    public static Iterator<TypeReference> iterateCastTypes(IMethod m3) throws InvalidClassFileException {
        if (m3 == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m3.isWalaSynthetic()) {
            SyntheticMethod sm = (SyntheticMethod)m3;
            return CodeScanner.iterateCastTypes(sm.getStatements());
        }
        return CodeScanner.iterateShrikeBTCastTypes((ShrikeCTMethod)m3);
    }

    private static Iterator<TypeReference> iterateShrikeBTCastTypes(ShrikeCTMethod wrapper) throws InvalidClassFileException {
        return wrapper.getCastTypes();
    }

    private static Set<TypeReference> getShrikeBTCaughtExceptions(ShrikeCTMethod method) throws InvalidClassFileException {
        return method.getCaughtExceptionTypes();
    }

    private static boolean hasShrikeBTObjectArrayStore(ShrikeCTMethod M) throws InvalidClassFileException {
        for (TypeReference t : Iterator2Iterable.make(M.getArraysWritten())) {
            if (!t.isReferenceType()) continue;
            return true;
        }
        return false;
    }

    private static Collection<CallSiteReference> getCallSitesFromShrikeBT(IBytecodeMethod<?> M) throws InvalidClassFileException {
        return M.getCallSites();
    }

    private static Collection<NewSiteReference> getNewSitesFromShrikeBT(ShrikeCTMethod M) throws InvalidClassFileException {
        return M.getNewSites();
    }

    private static List<FieldReference> getFieldsReadFromShrikeBT(ShrikeCTMethod M) throws InvalidClassFileException {
        LinkedList<FieldReference> result = new LinkedList<FieldReference>();
        for (FieldReference fr : Iterator2Iterable.make(M.getFieldsRead())) {
            result.add(fr);
        }
        return result;
    }

    private static List<FieldReference> getFieldsWrittenFromShrikeBT(ShrikeCTMethod M) throws InvalidClassFileException {
        LinkedList<FieldReference> result = new LinkedList<FieldReference>();
        for (FieldReference fr : Iterator2Iterable.make(M.getFieldsWritten())) {
            result.add(fr);
        }
        return result;
    }

    private static List<TypeReference> getArraysWrittenFromShrikeBT(ShrikeCTMethod M) throws InvalidClassFileException {
        LinkedList<TypeReference> result = new LinkedList<TypeReference>();
        for (TypeReference tr : Iterator2Iterable.make(M.getArraysWritten())) {
            result.add(tr);
        }
        return result;
    }

    private static boolean hasShrikeBTObjectArrayLoad(ShrikeCTMethod M) throws InvalidClassFileException {
        for (TypeReference tr : Iterator2Iterable.make(M.getArraysRead())) {
            if (!tr.isReferenceType()) continue;
            return true;
        }
        return false;
    }

    public static Set<TypeReference> getCaughtExceptions(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final HashSet<TypeReference> result = HashSetFactory.make(10);
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            @Override
            public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
                Collection<TypeReference> t = instruction.getExceptionTypes();
                result.addAll(t);
            }
        };
        for (SSAInstruction s2 : statements) {
            if (s2 == null) continue;
            s2.visit(v);
        }
        return result;
    }

    public static Iterator<TypeReference> iterateCastTypes(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        HashSet result = HashSetFactory.make(10);
        for (SSAInstruction statement : statements) {
            if (statement == null || !(statement instanceof SSACheckCastInstruction)) continue;
            SSACheckCastInstruction c = (SSACheckCastInstruction)statement;
            result.addAll(Arrays.asList(c.getDeclaredResultTypes()));
        }
        return result.iterator();
    }

    private static List<CallSiteReference> getCallSites(SSAInstruction[] statements) {
        final LinkedList<CallSiteReference> result = new LinkedList<CallSiteReference>();
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            @Override
            public void visitInvoke(SSAInvokeInstruction instruction) {
                result.add(instruction.getCallSite());
            }
        };
        for (SSAInstruction s2 : statements) {
            if (s2 == null) continue;
            s2.visit(v);
        }
        return result;
    }

    private static List<NewSiteReference> getNewSites(SSAInstruction[] statements) {
        final LinkedList<NewSiteReference> result = new LinkedList<NewSiteReference>();
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            @Override
            public void visitNew(SSANewInstruction instruction) {
                result.add(instruction.getNewSite());
            }
        };
        for (SSAInstruction s2 : statements) {
            if (s2 == null) continue;
            s2.visit(v);
        }
        return result;
    }

    public static List<FieldReference> getFieldsRead(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final LinkedList<FieldReference> result = new LinkedList<FieldReference>();
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            @Override
            public void visitGet(SSAGetInstruction instruction) {
                result.add(instruction.getDeclaredField());
            }
        };
        for (SSAInstruction s2 : statements) {
            if (s2 == null) continue;
            s2.visit(v);
        }
        return result;
    }

    public static List<FieldReference> getFieldsWritten(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final LinkedList<FieldReference> result = new LinkedList<FieldReference>();
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            @Override
            public void visitPut(SSAPutInstruction instruction) {
                result.add(instruction.getDeclaredField());
            }
        };
        for (SSAInstruction s2 : statements) {
            if (s2 == null) continue;
            s2.visit(v);
        }
        return result;
    }

    public static List<TypeReference> getArraysWritten(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        final LinkedList<TypeReference> result = new LinkedList<TypeReference>();
        SSAInstruction.Visitor v = new SSAInstruction.Visitor(){

            @Override
            public void visitArrayStore(SSAArrayStoreInstruction instruction) {
                result.add(instruction.getElementType());
            }
        };
        for (SSAInstruction s2 : statements) {
            if (s2 == null) continue;
            s2.visit(v);
        }
        return result;
    }

    public static boolean hasObjectArrayLoad(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        class ScanVisitor
        extends SSAInstruction.Visitor {
            boolean foundOne = false;

            ScanVisitor() {
            }

            @Override
            public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
                if (!instruction.typeIsPrimitive()) {
                    this.foundOne = true;
                }
            }
        }
        ScanVisitor v = new ScanVisitor();
        for (SSAInstruction s2 : statements) {
            if (s2 != null) {
                s2.visit(v);
            }
            if (!v.foundOne) continue;
            return true;
        }
        return false;
    }

    public static boolean hasObjectArrayStore(SSAInstruction[] statements) throws IllegalArgumentException {
        if (statements == null) {
            throw new IllegalArgumentException("statements == null");
        }
        class ScanVisitor
        extends SSAInstruction.Visitor {
            boolean foundOne = false;

            ScanVisitor() {
            }

            @Override
            public void visitArrayStore(SSAArrayStoreInstruction instruction) {
                if (!instruction.typeIsPrimitive()) {
                    this.foundOne = true;
                }
            }
        }
        ScanVisitor v = new ScanVisitor();
        for (SSAInstruction s2 : statements) {
            if (s2 != null) {
                s2.visit(v);
            }
            if (!v.foundOne) continue;
            return true;
        }
        return false;
    }
}

