/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.JarFileEntry;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileUtil;
import com.ibm.wala.util.ref.CacheReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarFileModule
implements Module {
    private final JarFile file;
    private final HashMap<ZipEntry, Object> cache = HashMapFactory.make();

    public JarFileModule(JarFile f) {
        if (f == null) {
            throw new IllegalArgumentException("null f");
        }
        this.file = f;
    }

    public String getAbsolutePath() {
        return this.file.getName();
    }

    public String toString() {
        return "JarFileModule:" + this.file.getName();
    }

    protected ModuleEntry createEntry(ZipEntry z) {
        return new JarFileEntry(z.getName(), this);
    }

    public Iterator<ModuleEntry> getEntries() {
        return new Iterator<ModuleEntry>(){
            private final Enumeration<JarEntry> zipEntryEnumerator;
            {
                this.zipEntryEnumerator = JarFileModule.this.file.entries();
            }

            @Override
            public boolean hasNext() {
                return this.zipEntryEnumerator.hasMoreElements();
            }

            @Override
            public ModuleEntry next() {
                return JarFileModule.this.createEntry(this.zipEntryEnumerator.nextElement());
            }
        };
    }

    public int hashCode() {
        return this.file.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JarFileModule other = (JarFileModule)obj;
        return this.file.getName().equals(other.file.getName());
    }

    public byte[] getContents(ZipEntry entry) {
        byte[] b = (byte[])CacheReference.get(this.cache.get(entry));
        if (b != null) {
            return b;
        }
        try {
            InputStream s2 = this.file.getInputStream(entry);
            byte[] bb = FileUtil.readBytes(s2);
            this.cache.put(entry, CacheReference.make(bb));
            s2.close();
            return bb;
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public JarFile getJarFile() {
        return this.file;
    }
}

