/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.JavaLanguage;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSABuilder;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.ShrikeIndirectionData;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.analysis.DeadAssignmentElimination;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.WalaRuntimeException;
import java.util.Collection;

public class ShrikeIRFactory
implements IRFactory<IBytecodeMethod<IInstruction>> {
    public static final boolean buildLocalMap = true;

    public ShrikeCFG makeCFG(IBytecodeMethod<IInstruction> method) {
        return ShrikeCFG.make(method);
    }

    @Override
    public IR makeIR(final IBytecodeMethod<IInstruction> method, Context C2, final SSAOptions options) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        IInstruction[] shrikeInstructions = null;
        try {
            shrikeInstructions = method.getInstructions();
        }
        catch (InvalidClassFileException e) {
            throw new WalaRuntimeException("bad method bytecodes", e);
        }
        final ShrikeCFG shrikeCFG = this.makeCFG(method);
        final SymbolTable symbolTable = new SymbolTable(method.getNumberOfParameters());
        final SSAInstruction[] newInstrs = new SSAInstruction[shrikeInstructions.length];
        final SSACFG newCfg = new SSACFG(method, shrikeCFG, newInstrs);
        return new IR(method, newInstrs, symbolTable, newCfg, options){
            private final IR.SSA2LocalMap localMap;
            private final ShrikeIndirectionData indirectionData;
            {
                super(method2, instructions, symbolTable3, cfg, options2);
                SSABuilder builder = SSABuilder.make(method, newCfg, shrikeCFG, newInstrs, symbolTable, true, options.getPiNodePolicy());
                builder.build();
                this.localMap = builder.getLocalMap();
                this.indirectionData = builder.getIndirectionData();
                this.eliminateDeadPhis();
                this.pruneExceptionsForSafeArrayCreations();
                this.setupLocationMap();
            }

            private void eliminateDeadPhis() {
                DeadAssignmentElimination.perform(this);
            }

            private void pruneExceptionsForSafeArrayCreations() {
                DefUse du = new DefUse(this);
                for (int i = 0; i < newInstrs.length; ++i) {
                    SSANewInstruction newInstr;
                    SSAInstruction instr = newInstrs[i];
                    if (!(instr instanceof SSANewInstruction) || !(newInstr = (SSANewInstruction)instr).getConcreteType().isArrayType()) continue;
                    boolean isSafe = true;
                    int[] params = new int[newInstr.getNumberOfUses()];
                    for (int u = 0; u < newInstr.getNumberOfUses(); ++u) {
                        int vLength;
                        params[u] = vLength = newInstr.getUse(u);
                        isSafe &= this.isNonNegativeConstant(vLength) || this.isDefdByArrayLength(vLength, du);
                    }
                    if (!isSafe) continue;
                    newInstrs[i] = new SSANewInstruction(newInstr.iIndex(), newInstr.getDef(), newInstr.getNewSite(), params){

                        @Override
                        public Collection<TypeReference> getExceptionTypes() {
                            return JavaLanguage.getNewSafeArrayExceptions();
                        }
                    };
                }
            }

            private boolean isNonNegativeConstant(int vLength) {
                return symbolTable.isIntegerConstant(vLength) && symbolTable.getIntValue(vLength) >= 0;
            }

            private boolean isDefdByArrayLength(int vLength, DefUse du) {
                return du.getDef(vLength) instanceof SSAArrayLengthInstruction;
            }

            @Override
            protected String instructionPosition(int instructionIndex) {
                try {
                    int bcIndex = method.getBytecodeIndex(instructionIndex);
                    int lineNumber = method.getLineNumber(bcIndex);
                    if (lineNumber == -1) {
                        return "";
                    }
                    return "(line " + lineNumber + ')';
                }
                catch (InvalidClassFileException e) {
                    return "";
                }
            }

            @Override
            public IR.SSA2LocalMap getLocalMap() {
                return this.localMap;
            }

            protected ShrikeIndirectionData getIndirectionData() {
                return this.indirectionData;
            }
        };
    }

    @Override
    public boolean contextIsIrrelevant(IBytecodeMethod<IInstruction> method) {
        return true;
    }
}

