/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.bytecode.BytecodeStream;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.Collections;

public class SyntheticMethod
implements IMethod {
    public static final SSAInstruction[] NO_STATEMENTS = new SSAInstruction[0];
    private final MethodReference method;
    protected final IMethod resolvedMethod;
    public final IClass declaringClass;
    private final boolean isStatic;
    private final boolean isFactory;

    public SyntheticMethod(MethodReference method, IClass declaringClass, boolean isStatic, boolean isFactory) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        this.method = method;
        this.resolvedMethod = null;
        this.declaringClass = declaringClass;
        this.isStatic = isStatic;
        this.isFactory = isFactory;
    }

    public SyntheticMethod(IMethod method, IClass declaringClass, boolean isStatic, boolean isFactory) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        this.resolvedMethod = method;
        this.method = this.resolvedMethod.getReference();
        this.declaringClass = declaringClass;
        this.isStatic = isStatic;
        this.isFactory = isFactory;
    }

    @Override
    public boolean isClinit() {
        return this.method.getSelector().equals(MethodReference.clinitSelector);
    }

    @Override
    public boolean isInit() {
        return this.method.getSelector().equals(MethodReference.initSelector);
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isBridge() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public boolean isWalaSynthetic() {
        return true;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public MethodReference getReference() {
        return this.method;
    }

    public InducedCFG makeControlFlowGraph(SSAInstruction[] instructions) {
        return this.getDeclaringClass().getClassLoader().getLanguage().makeInducedCFG(instructions, this, Everywhere.EVERYWHERE);
    }

    public BytecodeStream getBytecodeStream() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getMaxLocals() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getMaxStackHeight() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder("synthetic ");
        if (this.isFactoryMethod()) {
            s2.append(" factory ");
        }
        s2.append(this.method.toString());
        return s2.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyntheticMethod other = (SyntheticMethod)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    @Override
    public boolean hasExceptionHandler() {
        return false;
    }

    public boolean hasPoison() {
        return false;
    }

    public String getPoison() {
        return null;
    }

    public byte getPoisonLevel() {
        return -1;
    }

    @Deprecated
    public SSAInstruction[] getStatements(SSAOptions options) {
        return NO_STATEMENTS;
    }

    public IR makeIR(Context context, SSAOptions options) throws UnimplementedError {
        throw new UnimplementedError("haven't implemented IR yet for class " + this.getClass());
    }

    @Override
    public TypeReference getParameterType(int i) {
        if (this.isStatic()) {
            return this.method.getParameterType(i);
        }
        if (i == 0) {
            return this.method.getDeclaringClass();
        }
        return this.method.getParameterType(i - 1);
    }

    @Override
    public int getNumberOfParameters() {
        int n = this.method.getNumberOfParameters();
        return this.isStatic() ? n : n + 1;
    }

    @Override
    public TypeReference[] getDeclaredExceptions() throws InvalidClassFileException {
        if (this.resolvedMethod == null) {
            return null;
        }
        return this.resolvedMethod.getDeclaredExceptions();
    }

    @Override
    public Atom getName() {
        return this.method.getSelector().getName();
    }

    @Override
    public Descriptor getDescriptor() {
        return this.method.getSelector().getDescriptor();
    }

    @Override
    public IMethod.SourcePosition getSourcePosition(int bcIndex) throws InvalidClassFileException {
        return null;
    }

    @Override
    public IMethod.SourcePosition getParameterSourcePosition(int paramNum) throws InvalidClassFileException {
        return null;
    }

    @Override
    public int getLineNumber(int bcIndex) {
        return -1;
    }

    public boolean isFactoryMethod() {
        return this.isFactory;
    }

    @Override
    public String getSignature() {
        return this.getReference().getSignature();
    }

    @Override
    public Selector getSelector() {
        return this.getReference().getSelector();
    }

    @Override
    public String getLocalVariableName(int bcIndex, int localNumber) {
        return null;
    }

    @Override
    public boolean hasLocalVariableTable() {
        return false;
    }

    public SSAInstruction[] getStatements() {
        return this.getStatements(SSAOptions.defaultOptions());
    }

    @Override
    public TypeReference getReturnType() {
        return this.getReference().getReturnType();
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.getDeclaringClass().getClassHierarchy();
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return Collections.emptySet();
    }
}

