/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.client;

import com.ibm.wala.client.EngineStopwatch;
import com.ibm.wala.util.perf.StopwatchGC;

public abstract class AbstractEngineStopwatch
implements EngineStopwatch {
    protected final StopwatchGC[] stopwatch = new StopwatchGC[this.getNumberOfCategories()];

    protected abstract int getNumberOfCategories();

    protected abstract String[] getCategoryNames();

    protected AbstractEngineStopwatch() {
        for (int i = 0; i < this.getNumberOfCategories(); ++i) {
            this.stopwatch[i] = new StopwatchGC(this.getCategoryNames()[i]);
        }
    }

    @Override
    public final String report() {
        StringBuilder result = new StringBuilder();
        long total = 0L;
        for (int i = 0; i < this.getNumberOfCategories(); ++i) {
            total += this.stopwatch[i].getElapsedMillis();
            result.append(this.getCategoryNames()[i]).append(": ").append(this.stopwatch[i].getElapsedMillis()).append('\n');
        }
        result.append("Total       : ").append(total).append('\n');
        return result.toString();
    }

    @Override
    public void start(byte category) {
        this.stopwatch[category].start();
    }

    @Override
    public void stop(byte category) {
        this.stopwatch[category].stop();
    }

    @Override
    public StopwatchGC getTimer(byte category) {
        return this.stopwatch[category];
    }
}

