/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.classLoader;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.BytecodeCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.BytecodeLanguage;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.JavaLanguage;
import com.ibm.wala.dalvik.classLoader.DexIMethod;
import com.ibm.wala.dalvik.dex.instructions.Instruction;
import com.ibm.wala.dalvik.dex.instructions.Invoke;
import com.ibm.wala.dalvik.dex.instructions.Return;
import com.ibm.wala.dalvik.dex.instructions.Throw;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class DexCFG
extends AbstractCFG<Instruction, BasicBlock>
implements BytecodeCFG {
    private static final boolean DEBUG = false;
    private int[] instruction2Block;
    private final DexIMethod dexMethod;
    private final Context context;
    private static int totalEdges = 0;
    private final int hashBase;
    private final Set<ExceptionHandler> exceptionHandlers = HashSetFactory.make(10);

    protected DexCFG(DexIMethod method, Context context) throws IllegalArgumentException {
        super(method);
        if (method == null) {
            throw new IllegalArgumentException("method cannot be null");
        }
        this.dexMethod = method;
        this.context = context;
        this.hashBase = method.hashCode() * 9967;
        this.makeBasicBlocks();
        this.init();
        this.computeI2BMapping();
        this.computeEdges();
    }

    public DexIMethod getDexMethod() {
        return this.dexMethod;
    }

    public static int getTotalEdges() {
        return totalEdges;
    }

    @Override
    public int hashCode() {
        return 9511 * this.getMethod().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DexCFG && ((DexCFG)o).dexMethod.equals(this.dexMethod) && ((DexCFG)o).context.equals(this.context);
    }

    public Instruction[] getInstructions() {
        return this.dexMethod.getDexInstructions();
    }

    private void computeI2BMapping() {
        this.instruction2Block = new int[this.getInstructions().length];
        for (BasicBlock b : this) {
            for (int j = b.getFirstInstructionIndex(); j <= b.getLastInstructionIndex(); ++j) {
                this.instruction2Block[j] = this.getNumber(b);
            }
        }
    }

    private void computeEdges() {
        for (BasicBlock b : this) {
            if (b.equals(this.exit())) continue;
            if (b.equals(this.entry())) {
                BasicBlock bb0 = this.getBlockForInstruction(0);
                assert (bb0 != null);
                this.addNormalEdge(b, bb0);
                continue;
            }
            b.computeOutgoingEdges();
        }
    }

    private void makeBasicBlocks() {
        ExceptionHandler[][] handlers = this.dexMethod.getHandlers();
        boolean[] r = new boolean[this.getInstructions().length];
        boolean[] catchers = new boolean[this.getInstructions().length];
        int blockCount = 2;
        r[0] = true;
        Instruction[] instructions = this.getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            int[] targets = instructions[i].getBranchTargets();
            if (!(targets.length <= 0 && instructions[i].isFallThrough() || i + 1 >= instructions.length || r[i + 1])) {
                r[i + 1] = true;
                ++blockCount;
            }
            for (int target : targets) {
                if (r[target]) continue;
                r[target] = true;
                ++blockCount;
            }
            if (!instructions[i].isPEI()) continue;
            ExceptionHandler[] hs = handlers[i];
            if (i + 1 < instructions.length && !r[i + 1]) {
                r[i + 1] = true;
                ++blockCount;
            }
            if (hs == null || hs.length <= 0) continue;
            for (ExceptionHandler h2 : hs) {
                this.exceptionHandlers.add(h2);
                if (!r[h2.getHandler()]) {
                    r[h2.getHandler()] = true;
                    ++blockCount;
                }
                catchers[h2.getHandler()] = true;
            }
        }
        BasicBlock entry = new BasicBlock(-1);
        this.addNode(entry);
        int j = 1;
        for (int i = 0; i < r.length; ++i) {
            if (!r[i]) continue;
            BasicBlock b = new BasicBlock(i);
            this.addNode(b);
            if (catchers[i]) {
                this.setCatchBlock(j);
            }
            ++j;
        }
        BasicBlock exit = new BasicBlock(-1);
        this.addNode(exit);
    }

    @Override
    public BasicBlock getBlockForInstruction(int index) {
        return (BasicBlock)this.getNode(this.instruction2Block[index]);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        BitVector catches = this.getCatchBlocks();
        for (BasicBlock bb : this) {
            s2.append("BB").append(this.getNumber(bb));
            if (catches.contains(bb.getNumber())) {
                s2.append("<Handler>");
            }
            s2.append('\n');
            for (int j = bb.getFirstInstructionIndex(); j <= bb.getLastInstructionIndex(); ++j) {
                s2.append("  ").append(j).append("  ").append(this.getInstructions()[j]).append('\n');
            }
            Iterator<BasicBlock> succNodes = this.getSuccNodes(bb);
            while (succNodes.hasNext()) {
                s2.append("    -> BB").append(this.getNumber((IBasicBlock)succNodes.next())).append('\n');
            }
        }
        return s2.toString();
    }

    public int getMaxStackHeight() {
        return this.dexMethod.getMaxStackHeight();
    }

    public int getMaxLocals() {
        return this.dexMethod.getMaxLocals();
    }

    @Override
    public Set<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    @Override
    public int getProgramCounter(int index) {
        return this.dexMethod.getAddressFromIndex(index);
    }

    private static class FailedExceptionResolutionWarning
    extends Warning {
        final TypeReference T;

        FailedExceptionResolutionWarning(TypeReference T) {
            super((byte)1);
            this.T = T;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.T;
        }

        public static FailedExceptionResolutionWarning create(TypeReference T) {
            return new FailedExceptionResolutionWarning(T);
        }
    }

    public final class BasicBlock
    extends NodeWithNumber
    implements IBasicBlock<Instruction> {
        private final int startIndex;

        public BasicBlock(int startIndex) {
            this.startIndex = startIndex;
        }

        @Override
        public boolean isCatchBlock() {
            return DexCFG.this.isCatchBlock(this.getNumber());
        }

        private void computeOutgoingEdges() {
            int[] targets;
            Instruction last = DexCFG.this.getInstructions()[this.getLastInstructionIndex()];
            for (int target : targets = last.getBranchTargets()) {
                BasicBlock b = DexCFG.this.getBlockForInstruction(target);
                this.addNormalEdgeTo(b);
            }
            this.addExceptionalEdges(last);
            if (last.isFallThrough()) {
                BasicBlock next = (BasicBlock)DexCFG.this.getNode(this.getNumber() + 1);
                this.addNormalEdgeTo(next);
            }
            if (last instanceof Return) {
                BasicBlock exit = (BasicBlock)DexCFG.this.exit();
                this.addNormalEdgeTo(exit);
            }
        }

        protected void addExceptionalEdges(Instruction last) {
            IClassHierarchy cha = this.getMethod().getClassHierarchy();
            if (last.isPEI()) {
                BasicBlock exit;
                Collection<Object> exceptionTypes = null;
                boolean goToAllHandlers = false;
                ExceptionHandler[] hs = this.getExceptionHandlers();
                if (last instanceof Throw) {
                    goToAllHandlers = true;
                } else if (hs != null && hs.length > 0) {
                    ExceptionHandler[] loader = this.getMethod().getDeclaringClass().getClassLoader();
                    BytecodeLanguage l = (BytecodeLanguage)loader.getLanguage();
                    exceptionTypes = this.getImplicitExceptionTypes(last);
                    if (last instanceof Invoke) {
                        Invoke call = (Invoke)last;
                        exceptionTypes = HashSetFactory.make(exceptionTypes);
                        MethodReference target = MethodReference.findOrCreate(l, loader.getReference(), call.clazzName, call.methodName, call.descriptor);
                        try {
                            exceptionTypes.addAll(l.inferInvokeExceptions(target, cha));
                        }
                        catch (InvalidClassFileException e) {
                            e.printStackTrace();
                            Assertions.UNREACHABLE();
                        }
                        IMethod mTarget = cha.resolveMethod(target);
                        if (mTarget == null) {
                            goToAllHandlers = true;
                        }
                    }
                }
                if (hs != null && hs.length > 0) {
                    if (!goToAllHandlers) {
                        exceptionTypes = HashSetFactory.make(exceptionTypes);
                    }
                    for (ExceptionHandler element : hs) {
                        BasicBlock b = DexCFG.this.getBlockForInstruction(element.getHandler());
                        if (goToAllHandlers) {
                            this.addExceptionalEdgeTo(b);
                            continue;
                        }
                        TypeReference caughtException = null;
                        if (element.getCatchClass() != null) {
                            ClassLoaderReference loader = DexCFG.this.getMethod().getDeclaringClass().getReference().getClassLoader();
                            caughtException = ShrikeUtil.makeTypeReference(loader, element.getCatchClass());
                            IClass caughtClass = cha.lookupClass(caughtException);
                            if (caughtClass == null) {
                                this.addExceptionalEdgeTo(b);
                                Warnings.add(FailedExceptionResolutionWarning.create(caughtException));
                                caughtException = null;
                            }
                        } else if (!exceptionTypes.isEmpty()) {
                            this.addExceptionalEdgeTo(b);
                            exceptionTypes.clear();
                            assert (caughtException == null);
                        }
                        if (caughtException == null) continue;
                        IClass caughtClass = cha.lookupClass(caughtException);
                        ArrayList<TypeReference> caught = new ArrayList<TypeReference>(exceptionTypes.size());
                        for (TypeReference typeReference : exceptionTypes) {
                            if (typeReference == null) continue;
                            IClass klass = cha.lookupClass(typeReference);
                            if (klass == null) {
                                Warnings.add(FailedExceptionResolutionWarning.create(caughtException));
                                this.addExceptionalEdgeTo(b);
                                continue;
                            }
                            boolean subtype1 = cha.isSubclassOf(klass, caughtClass);
                            if (!subtype1 && !cha.isSubclassOf(caughtClass, klass)) continue;
                            this.addExceptionalEdgeTo(b);
                            if (!subtype1) continue;
                            caught.add(typeReference);
                        }
                        exceptionTypes.removeAll(caught);
                    }
                    if (exceptionTypes == null || !exceptionTypes.isEmpty()) {
                        exit = (BasicBlock)DexCFG.this.exit();
                        this.addExceptionalEdgeTo(exit);
                    }
                } else {
                    exit = (BasicBlock)DexCFG.this.exit();
                    this.addExceptionalEdgeTo(exit);
                }
            }
        }

        public Collection<TypeReference> getImplicitExceptionTypes(Instruction pei) {
            if (pei == null) {
                throw new IllegalArgumentException("pei is null");
            }
            switch (pei.getOpcode()) {
                case AGET: 
                case AGET_WIDE: 
                case AGET_OBJECT: 
                case AGET_BOOLEAN: 
                case AGET_BYTE: 
                case AGET_CHAR: 
                case AGET_SHORT: 
                case APUT: 
                case APUT_WIDE: 
                case APUT_BOOLEAN: 
                case APUT_BYTE: 
                case APUT_CHAR: 
                case APUT_SHORT: {
                    return JavaLanguage.getArrayAccessExceptions();
                }
                case APUT_OBJECT: {
                    return JavaLanguage.getAaStoreExceptions();
                }
                case IGET: 
                case IGET_WIDE: 
                case IGET_OBJECT: 
                case IGET_BOOLEAN: 
                case IGET_BYTE: 
                case IGET_CHAR: 
                case IGET_SHORT: 
                case IPUT: 
                case IPUT_WIDE: 
                case IPUT_OBJECT: 
                case IPUT_BOOLEAN: 
                case IPUT_BYTE: 
                case IPUT_CHAR: 
                case IPUT_SHORT: 
                case INVOKE_VIRTUAL: 
                case INVOKE_SUPER: 
                case INVOKE_DIRECT: 
                case INVOKE_INTERFACE: 
                case INVOKE_VIRTUAL_RANGE: 
                case INVOKE_SUPER_RANGE: 
                case INVOKE_DIRECT_RANGE: 
                case INVOKE_INTERFACE_RANGE: 
                case ARRAY_LENGTH: 
                case MONITOR_ENTER: 
                case MONITOR_EXIT: 
                case THROW: {
                    return JavaLanguage.getNullPointerException();
                }
                case DIV_INT: 
                case DIV_INT_2ADDR: 
                case DIV_INT_LIT16: 
                case DIV_INT_LIT8: 
                case REM_INT: 
                case REM_INT_2ADDR: 
                case REM_INT_LIT16: 
                case REM_INT_LIT8: 
                case DIV_LONG: 
                case DIV_LONG_2ADDR: 
                case REM_LONG: 
                case REM_LONG_2ADDR: {
                    return JavaLanguage.getArithmeticException();
                }
                case NEW_INSTANCE: {
                    return JavaLanguage.getNewScalarExceptions();
                }
                case NEW_ARRAY: 
                case FILLED_NEW_ARRAY: 
                case FILLED_NEW_ARRAY_RANGE: {
                    return JavaLanguage.getNewArrayExceptions();
                }
                case CHECK_CAST: {
                    return JavaLanguage.getClassCastException();
                }
                case SGET: 
                case SGET_BOOLEAN: 
                case SGET_BYTE: 
                case SGET_CHAR: 
                case SGET_OBJECT: 
                case SGET_SHORT: 
                case SGET_WIDE: 
                case SPUT: 
                case SPUT_BOOLEAN: 
                case SPUT_BYTE: 
                case SPUT_CHAR: 
                case SPUT_OBJECT: 
                case SPUT_SHORT: 
                case SPUT_WIDE: {
                    return JavaLanguage.getExceptionInInitializerError();
                }
            }
            return Collections.emptySet();
        }

        private ExceptionHandler[] getExceptionHandlers() {
            ExceptionHandler[][] handlers = DexCFG.this.dexMethod.getHandlers();
            ExceptionHandler[] hs = handlers[this.getLastInstructionIndex()];
            return hs;
        }

        private void addNormalEdgeTo(BasicBlock b) {
            totalEdges++;
            DexCFG.this.addNormalEdge(this, b);
        }

        private void addExceptionalEdgeTo(BasicBlock b) {
            totalEdges++;
            DexCFG.this.addExceptionalEdge(this, b);
        }

        @Override
        public int getLastInstructionIndex() {
            if (this == DexCFG.this.entry() || this == DexCFG.this.exit()) {
                return -2;
            }
            if (this.getNumber() == DexCFG.this.getMaxNumber() - 1) {
                return DexCFG.this.getInstructions().length - 1;
            }
            BasicBlock next = (BasicBlock)DexCFG.this.getNode(this.getNumber() + 1);
            return next.getFirstInstructionIndex() - 1;
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.startIndex;
        }

        public String toString() {
            return "BB[Dex]" + this.getNumber() + " - " + DexCFG.this.dexMethod.getDeclaringClass().getReference().getName() + '.' + DexCFG.this.dexMethod.getName();
        }

        @Override
        public boolean isExitBlock() {
            return this == DexCFG.this.exit();
        }

        @Override
        public boolean isEntryBlock() {
            return this == DexCFG.this.entry();
        }

        @Override
        public IMethod getMethod() {
            return DexCFG.this.getMethod();
        }

        public int hashCode() {
            return DexCFG.this.hashBase + this.getNumber();
        }

        public boolean equals(Object o) {
            return o instanceof BasicBlock && ((BasicBlock)o).getMethod().equals(this.getMethod()) && ((BasicBlock)o).getNumber() == this.getNumber();
        }

        @Override
        public int getNumber() {
            return this.getGraphNodeId();
        }

        @Override
        public Iterator<Instruction> iterator() {
            return new ArrayIterator<Instruction>(DexCFG.this.getInstructions(), this.getFirstInstructionIndex(), this.getLastInstructionIndex());
        }
    }
}

