/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.classLoader;

import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.dalvik.classLoader.DexModuleEntry;
import com.ibm.wala.util.io.TemporaryFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarFile;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;

public class DexFileModule
implements Module {
    private final File f;
    private final DexFile dexfile;
    private final Collection<ModuleEntry> entries;
    public static final int AUTO_INFER_API_LEVEL = -1;

    public static DexFileModule make(File f) throws IllegalArgumentException, IOException {
        return DexFileModule.make(f, -1);
    }

    public static DexFileModule make(File f, int apiLevel) throws IllegalArgumentException, IOException {
        if (f.getName().endsWith("jar")) {
            try (JarFile jar = new JarFile(f);){
                DexFileModule dexFileModule = new DexFileModule(jar);
                return dexFileModule;
            }
        }
        return new DexFileModule(f, apiLevel);
    }

    private static File tf(JarFile f) throws IOException {
        String name = f.getName();
        if (name.indexOf(47) >= 0) {
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        File tf = Files.createTempFile("name", "_classes.dex", new FileAttribute[0]).toFile();
        tf.deleteOnExit();
        System.err.println("using " + tf);
        return tf;
    }

    private DexFileModule(JarFile f) throws IllegalArgumentException, IOException {
        this(TemporaryFile.streamToFile(DexFileModule.tf(f), f.getInputStream(f.getEntry("classes.dex"))));
    }

    private DexFileModule(File f) throws IllegalArgumentException {
        this(f, -1);
    }

    private DexFileModule(File f, int apiLevel) throws IllegalArgumentException {
        try {
            this.f = f;
            this.dexfile = DexFileFactory.loadDexFile(f, apiLevel == -1 ? null : Opcodes.forApi(apiLevel));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        this.entries = new HashSet<ModuleEntry>();
        for (ClassDef classDef : this.dexfile.getClasses()) {
            this.entries.add(new DexModuleEntry(classDef, this));
        }
    }

    public DexFileModule(File f, String entry, int apiLevel) throws IllegalArgumentException {
        try {
            this.f = f;
            this.dexfile = DexFileFactory.loadDexEntry(f, entry, true, apiLevel == -1 ? null : Opcodes.forApi(apiLevel)).getDexFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        this.entries = new HashSet<ModuleEntry>();
        for (ClassDef classDef : this.dexfile.getClasses()) {
            this.entries.add(new DexModuleEntry(classDef, this));
        }
    }

    public DexFileModule(File f, String entry) throws IllegalArgumentException {
        this(f, entry, -1);
    }

    public DexFile getDexFile() {
        return this.dexfile;
    }

    public File getFile() {
        return this.f;
    }

    public Iterator<ModuleEntry> getEntries() {
        return this.entries.iterator();
    }
}

