/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.classLoader;

import com.ibm.wala.classLoader.BytecodeClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dalvik.classLoader.DexFileModule;
import com.ibm.wala.dalvik.classLoader.DexIField;
import com.ibm.wala.dalvik.classLoader.DexIMethod;
import com.ibm.wala.dalvik.classLoader.DexModuleEntry;
import com.ibm.wala.dalvik.classLoader.DexUtil;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.AnnotationVisibility;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodParameter;

public class DexIClass
extends BytecodeClass<IClassLoader> {
    private final ClassDef classDef;
    private final int modifiers;
    private IMethod[] methods = null;
    private int clinitId = -1;
    private final DexModuleEntry dexModuleEntry;

    public DexIClass(IClassLoader loader, IClassHierarchy cha, DexModuleEntry dexEntry) {
        super(loader, cha);
        String descriptor;
        this.dexModuleEntry = dexEntry;
        this.classDef = dexEntry.getClassDefItem();
        this.modifiers = this.classDef.getAccessFlags();
        this.typeReference = TypeReference.findOrCreate(loader.getReference(), dexEntry.getClassName());
        this.hashCode = 2161 * this.getReference().hashCode();
        String string = descriptor = this.classDef.getSuperclass() != null ? this.classDef.getSuperclass() : null;
        if (descriptor != null && descriptor.endsWith(";")) {
            descriptor = descriptor.substring(0, descriptor.length() - 1);
        }
        this.superName = descriptor != null ? ImmutableByteArray.make(descriptor) : null;
        List<String> intfList = this.classDef.getInterfaces();
        int size = intfList == null ? 0 : intfList.size();
        this.interfaceNames = new ImmutableByteArray[size];
        for (int i = 0; i < size; ++i) {
            descriptor = intfList.get(i);
            if (descriptor.endsWith(";")) {
                descriptor = descriptor.substring(0, descriptor.length() - 1);
            }
            this.interfaceNames[i] = ImmutableByteArray.make(descriptor);
        }
        Iterable<? extends Field> encInstFields = this.classDef.getInstanceFields();
        LinkedList<DexIField> ifs = new LinkedList<DexIField>();
        for (Field field : encInstFields) {
            ifs.add(new DexIField(field, this));
        }
        this.instanceFields = ifs.toArray(new IField[0]);
        Iterable<? extends Field> encStatFields = this.classDef.getStaticFields();
        LinkedList<DexIField> linkedList = new LinkedList<DexIField>();
        for (Field field : encStatFields) {
            linkedList.add(new DexIField(field, this));
        }
        this.staticFields = linkedList.toArray(new IField[0]);
    }

    public ClassDef getClassDefItem() {
        return this.classDef;
    }

    @Override
    public boolean isPublic() {
        return (this.modifiers & AccessFlags.PUBLIC.getValue()) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.modifiers & AccessFlags.PRIVATE.getValue()) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.modifiers & AccessFlags.INTERFACE.getValue()) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.modifiers & AccessFlags.ABSTRACT.getValue()) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.modifiers & AccessFlags.SYNTHETIC.getValue()) != 0;
    }

    @Override
    public int getModifiers() throws UnsupportedOperationException {
        return this.modifiers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DexIClass) {
            return this.getReference().equals(((DexIClass)obj).getReference());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    Collection<Annotation> getAnnotations(Set<String> types) {
        HashSet<Annotation> result = HashSetFactory.make();
        for (org.jf.dexlib2.iface.Annotation annotation : this.classDef.getAnnotations()) {
            if (types != null && !types.contains(AnnotationVisibility.getVisibility(annotation.getVisibility()))) continue;
            result.add(DexUtil.getAnnotation(annotation, this.getClassLoader().getReference()));
        }
        return result;
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.getAnnotations((Set<String>)null);
    }

    @Override
    public Collection<Annotation> getAnnotations(boolean runtimeInvisible) {
        return this.getAnnotations(DexIClass.getTypes(runtimeInvisible));
    }

    static Set<String> getTypes(boolean runtimeInvisible) {
        HashSet<String> types = HashSetFactory.make();
        types.add(AnnotationVisibility.getVisibility(2));
        if (runtimeInvisible) {
            types.add(AnnotationVisibility.getVisibility(0));
        } else {
            types.add(AnnotationVisibility.getVisibility(1));
        }
        return types;
    }

    List<Annotation> getAnnotations(Method m3, Set<String> set) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (org.jf.dexlib2.iface.Annotation annotation : m3.getAnnotations()) {
            if (set != null && !set.contains(AnnotationVisibility.getVisibility(annotation.getVisibility()))) continue;
            result.add(DexUtil.getAnnotation(annotation, this.getClassLoader().getReference()));
        }
        return result;
    }

    Collection<Annotation> getAnnotations(Field m3) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (org.jf.dexlib2.iface.Annotation annotation : m3.getAnnotations()) {
            result.add(DexUtil.getAnnotation(annotation, this.getClassLoader().getReference()));
        }
        return result;
    }

    Map<Integer, List<Annotation>> getParameterAnnotations(Method m3) {
        HashMap<Integer, List<Annotation>> result = HashMapFactory.make();
        int i = 0;
        for (MethodParameter methodParameter : m3.getParameters()) {
            for (org.jf.dexlib2.iface.Annotation annotation : methodParameter.getAnnotations()) {
                if (!result.containsKey(i)) {
                    result.put(i, new ArrayList());
                }
                ((List)result.get(i)).add(DexUtil.getAnnotation(annotation, this.getClassLoader().getReference()));
            }
            ++i;
        }
        return result;
    }

    @Override
    protected IMethod[] computeDeclaredMethods() {
        ArrayList<DexIMethod> methodsAL = new ArrayList<DexIMethod>();
        if (this.methods == null) {
            Iterable<? extends Method> directMethods = this.classDef.getDirectMethods();
            Iterable<? extends Method> virtualMethods = this.classDef.getVirtualMethods();
            int i = 0;
            for (Method method : directMethods) {
                DexIMethod method2 = new DexIMethod(method, this);
                methodsAL.add(method2);
                if (method2.isClinit()) {
                    this.clinitId = i;
                }
                ++i;
            }
            for (Method method : virtualMethods) {
                methodsAL.add(new DexIMethod(method, this));
            }
        }
        if (this.methods == null) {
            this.methods = methodsAL.toArray(new IMethod[0]);
        }
        return this.methods;
    }

    @Override
    public IMethod getClassInitializer() {
        if (this.methods == null) {
            this.computeDeclaredMethods();
        }
        return this.clinitId != -1 ? this.methods[this.clinitId] : null;
    }

    @Override
    public DexFileModule getContainer() {
        return this.dexModuleEntry.getContainer();
    }
}

