/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.classLoader;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.dalvik.classLoader.DexIClass;
import com.ibm.wala.dalvik.classLoader.DexUtil;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.iface.Field;

public class DexIField
implements IField {
    private final Field eField;
    private final DexIClass myClass;
    private FieldReference fieldReference;
    private final FieldReference myFieldRef;
    private final Atom name;

    public DexIField(Field encodedField, DexIClass klass) {
        this.eField = encodedField;
        this.myClass = klass;
        String fieldName = this.eField.getName();
        this.name = Atom.findOrCreateUnicodeAtom(fieldName);
        String fieldType = this.eField.getType();
        TypeName T = DexUtil.getTypeName(fieldType);
        TypeReference type = TypeReference.findOrCreate(this.myClass.getClassLoader().getReference(), T);
        this.myFieldRef = FieldReference.findOrCreate(this.myClass.getReference(), this.name, type);
    }

    @Override
    public TypeReference getFieldTypeReference() {
        return this.myFieldRef.getFieldType();
    }

    @Override
    public FieldReference getReference() {
        if (this.fieldReference == null) {
            this.fieldReference = FieldReference.findOrCreate(this.myClass.getReference(), this.getName(), this.getFieldTypeReference());
        }
        return this.fieldReference;
    }

    @Override
    public Atom getName() {
        return this.name;
    }

    @Override
    public boolean isFinal() {
        return (this.eField.getAccessFlags() & AccessFlags.FINAL.getValue()) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.eField.getAccessFlags() & AccessFlags.PRIVATE.getValue()) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.eField.getAccessFlags() & AccessFlags.PROTECTED.getValue()) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.eField.getAccessFlags() & AccessFlags.PUBLIC.getValue()) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.eField.getAccessFlags() & AccessFlags.STATIC.getValue()) != 0;
    }

    @Override
    public IClass getDeclaringClass() {
        return this.myClass;
    }

    @Override
    public boolean isVolatile() {
        return (this.eField.getAccessFlags() & AccessFlags.VOLATILE.getValue()) != 0;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.myClass.getClassHierarchy();
    }

    @Override
    public Collection<Annotation> getAnnotations() {
        return this.myClass.getAnnotations(this.eField);
    }
}

