/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.classLoader;

import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;

public class DexUtil {
    static Collection<Annotation> getAnnotations(Collection<org.jf.dexlib2.iface.Annotation> as, ClassLoaderReference clr) {
        HashSet<Annotation> result = HashSetFactory.make();
        for (org.jf.dexlib2.iface.Annotation a : as) {
            result.add(DexUtil.getAnnotation(a, clr));
        }
        return result;
    }

    static Annotation getAnnotation(org.jf.dexlib2.iface.Annotation ea, ClassLoaderReference clr) {
        HashMap<String, AnnotationsReader.ElementValue> values = HashMapFactory.make();
        TypeReference at = DexUtil.getTypeRef(ea.getType(), clr);
        for (AnnotationElement annotationElement : ea.getElements()) {
            String name = annotationElement.getName();
            EncodedValue v = annotationElement.getValue();
            AnnotationsReader.ElementValue value = DexUtil.getValue(clr, v);
            values.put(name, value);
        }
        return Annotation.makeWithNamed(at, values);
    }

    static AnnotationsReader.ElementValue getValue(ClassLoaderReference clr, EncodedValue v) {
        switch (v.getValueType()) {
            case 29: {
                HashMap<String, AnnotationsReader.ElementValue> values = HashMapFactory.make();
                String at = ((AnnotationEncodedValue)v).getType();
                for (AnnotationElement annotationElement : ((AnnotationEncodedValue)v).getElements()) {
                    String string = annotationElement.getName();
                    EncodedValue ev = annotationElement.getValue();
                    AnnotationsReader.ElementValue value = DexUtil.getValue(clr, ev);
                    values.put(string, value);
                }
                return new AnnotationsReader.AnnotationAttribute(at, values);
            }
            case 28: {
                List<? extends EncodedValue> vs = ((ArrayEncodedValue)v).getValue();
                AnnotationsReader.ElementValue[] rs = new AnnotationsReader.ElementValue[vs.size()];
                int idx = 0;
                for (EncodedValue encodedValue : vs) {
                    rs[idx++] = DexUtil.getValue(clr, encodedValue);
                }
                return new AnnotationsReader.ArrayElementValue(rs);
            }
            case 31: {
                Boolean bl = ((BooleanEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue(bl);
            }
            case 0: {
                Byte bt = ((ByteEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue(bt);
            }
            case 3: {
                Character c = Character.valueOf(((CharEncodedValue)v).getValue());
                return new AnnotationsReader.ConstantElementValue(c);
            }
            case 17: {
                Double d = ((DoubleEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue(d);
            }
            case 27: {
                FieldReference fieldReference = ((EnumEncodedValue)v).getValue();
                return new AnnotationsReader.EnumElementValue(fieldReference.getType(), fieldReference.getName());
            }
            case 25: {
                FieldReference fieldReference = v.getValueType() == 27 ? ((EnumEncodedValue)v).getValue() : ((FieldEncodedValue)v).getValue();
                String fieldName = fieldReference.getName();
                TypeReference ft = DexUtil.getTypeRef(fieldReference.getType(), clr);
                TypeReference ct = DexUtil.getTypeRef(fieldReference.getDefiningClass(), clr);
                return new AnnotationsReader.ConstantElementValue(com.ibm.wala.types.FieldReference.findOrCreate(ct, Atom.findOrCreateUnicodeAtom(fieldName), ft));
            }
            case 16: {
                Float f = Float.valueOf(((FloatEncodedValue)v).getValue());
                return new AnnotationsReader.ConstantElementValue(f);
            }
            case 4: {
                Integer iv = ((IntEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue(iv);
            }
            case 6: {
                Long l = ((LongEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue(l);
            }
            case 26: {
                MethodReference m3 = ((MethodEncodedValue)v).getValue();
                TypeReference ct = DexUtil.getTypeRef(m3.getDefiningClass(), clr);
                String methodName = m3.getName();
                String methodSig = DexUtil.getSignature(m3);
                return new AnnotationsReader.ConstantElementValue(com.ibm.wala.types.MethodReference.findOrCreate(ct, Atom.findOrCreateUnicodeAtom(methodName), Descriptor.findOrCreateUTF8(methodSig)));
            }
            case 30: {
                return new AnnotationsReader.ConstantElementValue(null);
            }
            case 2: {
                Short s2 = ((ShortEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue(s2);
            }
            case 23: {
                String str = ((StringEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue(str);
            }
            case 24: {
                String t = ((TypeEncodedValue)v).getValue();
                return new AnnotationsReader.ConstantElementValue(DexUtil.getTypeName(t) + ";");
            }
        }
        assert (false) : v;
        return null;
    }

    static String getSignature(MethodReference ref) {
        StringBuilder sig = new StringBuilder("(");
        for (CharSequence charSequence : ref.getParameterTypes()) {
            sig = sig.append(charSequence);
        }
        sig.append(')').append(ref.getReturnType());
        return sig.toString();
    }

    static TypeReference getTypeRef(String type, ClassLoaderReference clr) {
        return TypeReference.findOrCreate(clr, DexUtil.getTypeName(type));
    }

    static TypeName getTypeName(String fieldType) {
        ImmutableByteArray fieldTypeArray = ImmutableByteArray.make(fieldType);
        TypeName T = null;
        T = fieldTypeArray.get(fieldTypeArray.length() - 1) == 59 ? TypeName.findOrCreate(fieldTypeArray, 0, fieldTypeArray.length() - 1) : TypeName.findOrCreate(fieldTypeArray);
        return T;
    }
}

