/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.classLoader;

import com.ibm.wala.dalvik.dex.instructions.Instruction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InstructionArray
implements Collection<Instruction> {
    List<Instruction> instructions = new ArrayList<Instruction>();
    Map<Integer, Integer> pc2index = new HashMap<Integer, Integer>();
    List<Integer> index2pc = new ArrayList<Integer>();

    @Override
    public boolean add(Instruction e) {
        boolean ret = this.instructions.add(e);
        if (ret) {
            this.pc2index.put(e.pc, this.size() - 1);
            this.index2pc.add(e.pc);
        }
        return ret;
    }

    @Override
    public boolean addAll(Collection<? extends Instruction> c) {
        boolean ret = false;
        for (Instruction instruction : c) {
            ret |= this.add(instruction);
        }
        return ret;
    }

    @Override
    public boolean contains(Object o) {
        return this.instructions.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.instructions.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.instructions.equals(o);
    }

    @Override
    public int hashCode() {
        return this.instructions.hashCode();
    }

    public int indexOf(Object o) {
        return this.instructions.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.instructions.isEmpty();
    }

    @Override
    public Iterator<Instruction> iterator() {
        return this.instructions.iterator();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.instructions.size();
    }

    @Override
    public Object[] toArray() {
        return this.instructions.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.instructions.toArray(a);
    }

    public int getIndexFromPc(int pc) {
        if (!this.pc2index.containsKey(pc) && this.pc2index.containsKey(pc + 1)) {
            ++pc;
        }
        return this.pc2index.get(pc);
    }

    public int getPcFromIndex(int index) {
        return this.index2pc.get(index);
    }

    public Instruction getFromId(int id) {
        return this.instructions.get(id);
    }

    public Instruction getFromPc(int pc) {
        return this.instructions.get(this.pc2index.get(pc));
    }
}

