/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.dex.instructions;

import com.ibm.wala.dalvik.classLoader.DexIMethod;
import com.ibm.wala.dalvik.dex.instructions.Instruction;
import com.ibm.wala.types.TypeReference;
import org.jf.dexlib2.Opcode;

public class ArrayGet
extends Instruction {
    public final int destination;
    public final int array;
    public final int offset;
    public final Type type;

    public ArrayGet(int pc, int destination, int array, int offset, Type type, Opcode op, DexIMethod method) {
        super(pc, op, method);
        this.destination = destination;
        this.array = array;
        this.offset = offset;
        this.type = type;
    }

    @Override
    public void visit(Instruction.Visitor visitor) {
        visitor.visitArrayGet(this);
    }

    public TypeReference getType() {
        return ArrayGet.getType(this.type);
    }

    public static TypeReference getType(Type type) {
        switch (type) {
            case t_int: {
                return TypeReference.Int;
            }
            case t_wide: {
                return TypeReference.Long;
            }
            case t_boolean: {
                return TypeReference.Boolean;
            }
            case t_byte: {
                return TypeReference.Byte;
            }
            case t_char: {
                return TypeReference.Char;
            }
            case t_object: {
                return TypeReference.JavaLangObject;
            }
            case t_short: {
                return TypeReference.Short;
            }
        }
        return null;
    }

    public static enum Type {
        t_int,
        t_wide,
        t_boolean,
        t_byte,
        t_char,
        t_object,
        t_short;

    }
}

