/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.dex.instructions;

import com.ibm.wala.dalvik.classLoader.DexIMethod;
import com.ibm.wala.dalvik.dex.instructions.Instruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.types.Descriptor;
import org.jf.dexlib2.Opcode;

public abstract class Invoke
extends Instruction {
    public final int[] args;
    public final String clazzName;
    public final String methodName;
    public final String descriptor;

    protected Invoke(int instLoc, String clazzName, String methodName, String descriptor, int[] args, Opcode opcode, DexIMethod method) {
        super(instLoc, opcode, method);
        this.clazzName = clazzName;
        this.methodName = methodName;
        this.descriptor = descriptor;
        this.args = args;
        assert (Descriptor.findOrCreateUTF8(descriptor) != null);
    }

    @Override
    public void visit(Instruction.Visitor visitor) {
        visitor.visitInvoke(this);
    }

    public abstract IInvokeInstruction.IDispatch getInvocationCode();

    public static class InvokeInterface
    extends Invoke {
        public InvokeInterface(int instLoc, String clazzName, String methodName, String descriptor, int[] args, Opcode opcode, DexIMethod method) {
            super(instLoc, clazzName, methodName, descriptor, args, opcode, method);
        }

        @Override
        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.INTERFACE;
        }

        public String toString() {
            StringBuilder argString = new StringBuilder();
            argString.append('(');
            String sep = "";
            for (int r : this.args) {
                argString.append(sep).append(r);
                sep = ",";
            }
            argString.append(')');
            return "InvokeInterface " + this.clazzName + ' ' + this.methodName + ' ' + this.descriptor + ' ' + argString + ' ' + this.pc;
        }
    }

    public static class InvokeStatic
    extends Invoke {
        public InvokeStatic(int instLoc, String clazzName, String methodName, String descriptor, int[] args, Opcode opcode, DexIMethod method) {
            super(instLoc, clazzName, methodName, descriptor, args, opcode, method);
        }

        @Override
        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.STATIC;
        }

        public String toString() {
            StringBuilder argString = new StringBuilder();
            argString.append('(');
            String sep = "";
            for (int r : this.args) {
                argString.append(sep).append(r);
                sep = ",";
            }
            argString.append(')');
            return "InvokeStatic " + this.clazzName + ' ' + this.methodName + ' ' + this.descriptor + ' ' + argString + ' ' + this.pc;
        }
    }

    public static class InvokeDirect
    extends Invoke {
        public InvokeDirect(int instLoc, String clazzName, String methodName, String descriptor, int[] args, Opcode opcode, DexIMethod method) {
            super(instLoc, clazzName, methodName, descriptor, args, opcode, method);
        }

        @Override
        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.SPECIAL;
        }

        public String toString() {
            StringBuilder argString = new StringBuilder();
            argString.append('(');
            String sep = "";
            for (int r : this.args) {
                argString.append(sep).append(r);
                sep = ",";
            }
            argString.append(')');
            return "InvokeDirect " + this.clazzName + ' ' + this.methodName + ' ' + this.descriptor + ' ' + argString + ' ' + this.pc;
        }
    }

    public static class InvokeSuper
    extends Invoke {
        public InvokeSuper(int instLoc, String clazzName, String methodName, String descriptor, int[] args, Opcode opcode, DexIMethod method) {
            super(instLoc, clazzName, methodName, descriptor, args, opcode, method);
            assert (descriptor.contains("("));
        }

        @Override
        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.SPECIAL;
        }

        public String toString() {
            StringBuilder argString = new StringBuilder();
            argString.append('(');
            String sep = "";
            for (int r : this.args) {
                argString.append(sep).append(r);
                sep = ",";
            }
            argString.append(')');
            return "InvokeSuper " + this.clazzName + ' ' + this.methodName + ' ' + this.descriptor + ' ' + argString + ' ' + this.pc;
        }
    }

    public static class InvokeVirtual
    extends Invoke {
        public InvokeVirtual(int instLoc, String clazzName, String methodName, String descriptor, int[] args, Opcode opcode, DexIMethod method) {
            super(instLoc, clazzName, methodName, descriptor, args, opcode, method);
        }

        @Override
        public IInvokeInstruction.IDispatch getInvocationCode() {
            return IInvokeInstruction.Dispatch.VIRTUAL;
        }

        public String toString() {
            StringBuilder argString = new StringBuilder();
            argString.append('(');
            String sep = "";
            for (int r : this.args) {
                argString.append(sep).append(r);
                sep = ",";
            }
            argString.append(')');
            return "InvokeVirtual " + this.clazzName + ' ' + this.methodName + ' ' + this.descriptor + ' ' + argString + ' ' + this.pc;
        }
    }
}

