/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.dex.instructions;

import com.ibm.wala.dalvik.classLoader.DexIMethod;
import com.ibm.wala.dalvik.dex.instructions.Instruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.util.debug.Assertions;
import org.jf.dexlib2.Opcode;

public class UnaryOperation
extends Instruction {
    public final OpID op;
    public final int source;
    public final int destination;

    public UnaryOperation(int pc, OpID op, int destination, int source, Opcode opcode, DexIMethod method) {
        super(pc, opcode, method);
        this.op = op;
        this.destination = destination;
        this.source = source;
    }

    @Override
    public void visit(Instruction.Visitor visitor) {
        visitor.visitUnaryOperation(this);
    }

    public boolean isConversion() {
        switch (this.op) {
            case DOUBLETOLONG: 
            case DOUBLETOFLOAT: 
            case INTTOBYTE: 
            case INTTOCHAR: 
            case INTTOSHORT: 
            case DOUBLETOINT: 
            case FLOATTODOUBLE: 
            case FLOATTOLONG: 
            case FLOATTOINT: 
            case LONGTODOUBLE: 
            case LONGTOFLOAT: 
            case LONGTOINT: 
            case INTTODOUBLE: 
            case INTTOFLOAT: 
            case INTTOLONG: {
                return true;
            }
        }
        return false;
    }

    public boolean isMove() {
        switch (this.op) {
            case MOVE: 
            case MOVE_WIDE: {
                return true;
            }
        }
        return false;
    }

    public IUnaryOpInstruction.IOperator getOperator() {
        switch (this.op) {
            case NOT: 
            case NOTLONG: 
            case NOTINT: {
                return DalvikUnaryOp.BITNOT;
            }
            case NEGINT: 
            case NEGDOUBLE: 
            case NEGFLOAT: 
            case NEGLONG: {
                return IUnaryOpInstruction.Operator.NEG;
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public static enum DalvikUnaryOp implements IUnaryOpInstruction.IOperator
    {
        BITNOT;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum OpID {
        MOVE,
        MOVE_WIDE,
        MOVE_EXCEPTION,
        NOT,
        NEGINT,
        NOTINT,
        NEGLONG,
        NOTLONG,
        NEGFLOAT,
        NEGDOUBLE,
        DOUBLETOLONG,
        DOUBLETOFLOAT,
        INTTOBYTE,
        INTTOCHAR,
        INTTOSHORT,
        DOUBLETOINT,
        FLOATTODOUBLE,
        FLOATTOLONG,
        FLOATTOINT,
        LONGTODOUBLE,
        LONGTOFLOAT,
        LONGTOINT,
        INTTODOUBLE,
        INTTOFLOAT,
        INTTOLONG;

    }
}

