/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModelClass;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.FlatInstantiator;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.IInstantiationBehavior;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.Instantiator;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.ReuseParameters;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.structure.AbstractAndroidModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs.AndroidBoot;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs.AndroidStartComponentTool;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs.ExternalModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs.SystemServiceModel;
import com.ibm.wala.dalvik.ipa.callgraph.impl.AndroidEntryPoint;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.IntentStarters;
import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchyDweller;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ipa.summaries.SummarizedMethodWithNames;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.ssa.ParameterAccessor;
import com.ibm.wala.util.ssa.SSAValue;
import com.ibm.wala.util.ssa.SSAValueManager;
import com.ibm.wala.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AndroidModel
implements IClassHierarchyDweller {
    private final Atom name = Atom.findOrCreateAsciiAtom("AndroidModel");
    public MethodReference mRef;
    protected IClassHierarchy cha;
    protected AnalysisOptions options;
    protected IAnalysisCacheView cache;
    private AbstractAndroidModel labelSpecial;
    private final IInstantiationBehavior instanceBehavior;
    private SSAValueManager paramManager;
    private ParameterAccessor modelAcc;
    private ReuseParameters reuseParameters;
    protected final AnalysisScope scope;
    protected VolatileMethodSummary body;
    private MonitorUtil.IProgressMonitor monitor;
    private int maxProgress;
    protected static boolean doBoot = true;
    protected IClass klass;
    protected boolean built;
    protected SummarizedMethod model;

    public AndroidModel(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
        this.options = options;
        this.cha = cha;
        this.cache = cache;
        this.built = false;
        this.scope = options.getAnalysisScope();
        this.instanceBehavior = AndroidEntryPointManager.MANAGER.getInstantiationBehavior(cha);
    }

    protected void build(Atom name) throws CancelException {
        ArrayList<AndroidEntryPoint> restrictedEntries = new ArrayList<AndroidEntryPoint>();
        for (AndroidEntryPoint ep : AndroidEntryPointManager.ENTRIES) {
            if (!this.selectEntryPoint(ep)) continue;
            restrictedEntries.add(ep);
        }
        this.build(name, restrictedEntries);
    }

    public Atom getName() {
        return this.name;
    }

    public boolean isStatic() {
        return true;
    }

    public TypeName getReturnType() {
        return TypeReference.VoidName;
    }

    public Descriptor getDescriptor() throws CancelException {
        return this.getMethod().getDescriptor();
    }

    protected void build(Atom name, Collection<? extends AndroidEntryPoint> entrypoints) throws CancelException {
        this.klass = this.cha.lookupClass(AndroidModelClass.ANDROID_MODEL_CLASS);
        if (this.klass == null) {
            this.klass = AndroidModelClass.getInstance(this.cha);
            this.cha.addClass(this.klass);
        }
        this.reuseParameters = new ReuseParameters(this.instanceBehavior, this);
        this.reuseParameters.collectParameters(entrypoints);
        this.mRef = this.reuseParameters.toMethodReference(null);
        this.modelAcc = new ParameterAccessor(this.mRef, !this.isStatic());
        this.paramManager = new SSAValueManager(this.modelAcc);
        Selector selector = this.mRef.getSelector();
        AndroidModelClass mClass = AndroidModelClass.getInstance(this.cha);
        if (mClass.containsMethod(selector)) {
            assert (mClass.getMethod(selector) instanceof SummarizedMethod);
            this.model = (SummarizedMethod)mClass.getMethod(selector);
            return;
        }
        this.body = new VolatileMethodSummary(new MethodSummary(this.mRef));
        this.body.setStatic(true);
        this.labelSpecial = AndroidEntryPointManager.MANAGER.makeModelBehavior(this.body, new TypeSafeInstructionFactory(this.cha), this.paramManager, entrypoints);
        this.monitor = AndroidEntryPointManager.MANAGER.getProgressMonitor();
        this.maxProgress = entrypoints.size();
        doBoot &= AndroidEntryPointManager.MANAGER.getDoBootSequence();
        this.monitor.beginTask("Building " + name, this.maxProgress);
        this.populate(entrypoints);
        assert (this.cha.lookupClass(AndroidModelClass.ANDROID_MODEL_CLASS) != null) : "Adding the class failed!";
        if (this.klass == null) {
            throw new IllegalStateException("Could not find ANDROID_MODEL_CLASS in cha.");
        }
        this.body.setLocalNames(this.paramManager.makeLocalNames());
        this.model = new SummarizedMethodWithNames(this.mRef, this.body, this.klass){

            @Override
            public TypeReference getParameterType(int i) {
                IClassHierarchy cha = this.getClassHierarchy();
                TypeReference tRef = super.getParameterType(i);
                if (tRef.isClassType() && cha.lookupClass(tRef) == null) {
                    for (IClass c : cha) {
                        if (!c.getName().toString().equals(tRef.getName().toString())) continue;
                        return c.getReference();
                    }
                }
                return tRef;
            }
        };
        this.built = true;
    }

    private void register(SummarizedMethod model) {
        IClass klass = this.getDeclaringClass();
        ((AndroidModelClass)klass).setMacroModel(model);
    }

    public SummarizedMethod getMethod() throws CancelException {
        if (!this.built) {
            this.build(this.name);
            this.register(this.model);
        }
        return this.model;
    }

    public IClass getDeclaringClass() {
        return this.klass;
    }

    protected boolean selectEntryPoint(AndroidEntryPoint ep) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void populate(Iterable<? extends AndroidEntryPoint> entrypoints) throws CancelException {
        assert (!this.built) : "You can only build once";
        int currentProgress = 0;
        TypeSafeInstructionFactory tsif = new TypeSafeInstructionFactory(this.cha);
        Instantiator instantiator = new Instantiator(this.body, tsif, this.paramManager, this.cha, this.mRef, this.scope);
        boolean enteredASection = false;
        if (doBoot) {
            SSAValue application;
            ParameterAccessor.Parameter parameter = this.modelAcc.firstExtends(AndroidTypes.ApplicationName, this.cha);
            if (parameter != null) {
                application = parameter;
            } else {
                application = this.paramManager.getUnmanaged(AndroidTypes.Application, "app");
                this.body.addConstant(application.getNumber(), new ConstantValue(null));
                application.setAssigned();
            }
            SSAValue sSAValue = this.paramManager.getUnmanaged(AndroidTypes.Intent, "nullIntent");
            this.body.addConstant(sSAValue.getNumber(), new ConstantValue(null));
            sSAValue.setAssigned();
            SSAValue nullBinder = this.paramManager.getUnmanaged(AndroidTypes.IBinder, "nullBinder");
            this.body.addConstant(nullBinder.getNumber(), new ConstantValue(null));
            nullBinder.setAssigned();
            AndroidBoot boot = new AndroidBoot();
            boot.addBootCode(tsif, this.paramManager, this.body);
        }
        for (AndroidEntryPoint androidEntryPoint : entrypoints) {
            void var10_15;
            this.monitor.subTask(androidEntryPoint.getMethod().getReference().getSignature());
            if (!this.selectEntryPoint(androidEntryPoint)) {
                assert (false) : "The ep should not reach here!";
                ++currentProgress;
                continue;
            }
            if (this.labelSpecial.hadSectionSwitch(androidEntryPoint.order)) {
                this.labelSpecial.enter(androidEntryPoint.getSection(), this.body.getNextProgramCounter());
                enteredASection = true;
            }
            ArrayList paramses = new ArrayList(1);
            ArrayList<Integer> mutliTypePositions = new ArrayList<Integer>();
            ArrayList<SSAValue> arrayList = new ArrayList<SSAValue>(androidEntryPoint.getNumberOfParameters());
            paramses.add(arrayList);
            for (int i = 0; i < androidEntryPoint.getNumberOfParameters(); ++i) {
                if (androidEntryPoint.getParameterTypes(i).length != 1) {
                    mutliTypePositions.add(i);
                    arrayList.add(null);
                    continue;
                }
                for (TypeReference type : androidEntryPoint.getParameterTypes(i)) {
                    if (this.instanceBehavior.getBehavior(type.getName(), androidEntryPoint.getMethod(), null) == IInstantiationBehavior.InstanceBehavior.REUSE) {
                        arrayList.add(this.paramManager.getCurrent(new SSAValue.TypeKey(type.getName())));
                        continue;
                    }
                    if (type.isPrimitiveType()) {
                        arrayList.add(this.paramManager.getUnmanaged(type, "p"));
                        continue;
                    }
                    boolean asManaged = false;
                    SSAValue.VariableKey variableKey = null;
                    Set<? extends SSAValue> seen = null;
                    arrayList.add(instantiator.createInstance(type, false, variableKey, seen));
                }
            }
            boolean bl = false;
            while (var10_15 < mutliTypePositions.size()) {
                Integer multiTypePosition = (Integer)mutliTypePositions.get((int)var10_15);
                TypeReference[] typesOnPosition = androidEntryPoint.getParameterTypes(multiTypePosition);
                int typeCountOnPosition = typesOnPosition.length;
                ArrayList new_paramses = new ArrayList(paramses.size() * typeCountOnPosition);
                for (int i = 0; i < typeCountOnPosition; ++i) {
                    for (List list : paramses) {
                        ArrayList new_params = new ArrayList(list.size());
                        new_params.addAll(list);
                        new_paramses.add(new_params);
                    }
                }
                paramses = new_paramses;
                for (int i = 0; i < paramses.size(); ++i) {
                    List params3 = (List)paramses.get(i);
                    assert (params3.get(multiTypePosition) == null) : "Expected null, got " + params3.get(multiTypePosition) + " iter " + i;
                    TypeReference type = typesOnPosition[i * (var10_15 + true) % typeCountOnPosition];
                    if (this.instanceBehavior.getBehavior(type.getName(), androidEntryPoint.getMethod(), null) == IInstantiationBehavior.InstanceBehavior.REUSE) {
                        params3.set(multiTypePosition, this.paramManager.getCurrent(new SSAValue.TypeKey(type.getName())));
                        continue;
                    }
                    if (type.isPrimitiveType()) {
                        params3.set(multiTypePosition, this.paramManager.getUnmanaged(type, "p"));
                        continue;
                    }
                    boolean bl2 = false;
                    SSAValue.VariableKey key = null;
                    Set<? extends SSAValue> seen = null;
                    params3.set(multiTypePosition, instantiator.createInstance(type, false, key, seen));
                }
                ++var10_15;
            }
            for (List list : paramses) {
                SSAAbstractInvokeInstruction invokation;
                int callPC = this.body.getNextProgramCounter();
                CallSiteReference site = androidEntryPoint.makeSite(callPC);
                SSAValue exception = this.paramManager.getException();
                if (androidEntryPoint.getMethod().getReturnType().equals(TypeReference.Void)) {
                    invokation = tsif.InvokeInstruction(callPC, list, exception, site);
                    this.body.addStatement(invokation);
                    continue;
                }
                TypeReference returnType = androidEntryPoint.getMethod().getReturnType();
                SSAValue.TypeKey returnKey = new SSAValue.TypeKey(returnType.getName());
                if (this.paramManager.isSeen(returnKey)) {
                    SSAValue sSAValue = this.paramManager.getCurrent(returnKey);
                    this.paramManager.invalidate(returnKey);
                    SSAValue returnValue = this.paramManager.getUnallocated(returnType, returnKey);
                    invokation = tsif.InvokeInstruction(callPC, returnValue, list, exception, site);
                    this.body.addStatement(invokation);
                    this.paramManager.setAllocation(returnValue, invokation);
                    this.paramManager.invalidate(returnKey);
                    SSAValue newValue = this.paramManager.getFree(returnType, returnKey);
                    int phiPC = this.body.getNextProgramCounter();
                    ArrayList<SSAValue> toPhi = new ArrayList<SSAValue>(2);
                    toPhi.add(sSAValue);
                    toPhi.add(returnValue);
                    SSAPhiInstruction phi = tsif.PhiInstruction(phiPC, newValue, toPhi);
                    this.body.addStatement(phi);
                    this.paramManager.setPhi(newValue, phi);
                    continue;
                }
                SSAValue sSAValue = this.paramManager.getUnmanaged(returnType, new SSAValue.UniqueKey());
                invokation = tsif.InvokeInstruction(callPC, sSAValue, list, exception, site);
                this.body.addStatement(invokation);
            }
            this.monitor.worked(++currentProgress);
            MonitorUtil.throwExceptionIfCanceled(this.monitor);
        }
        if (enteredASection) {
            this.labelSpecial.finish(this.body.getNextProgramCounter());
        }
        this.monitor.done();
    }

    public SummarizedMethod getMethodAs(MethodReference asMethod, TypeReference caller, IntentStarters.StartInfo info, CGNode callerNd) throws CancelException {
        Set<IntentStarters.StarterFlags> flags = null;
        if (info != null) {
            flags = info.getFlags();
        }
        if (!this.built) {
            this.getMethod();
        }
        if (asMethod == null) {
            throw new IllegalArgumentException("asMethod may not be null");
        }
        if (flags == null) {
            flags = Collections.emptySet();
        }
        TypeSafeInstructionFactory instructionFactory = new TypeSafeInstructionFactory(this.getClassHierarchy());
        ParameterAccessor acc = new ParameterAccessor(asMethod, true);
        SSAValueManager pm = new SSAValueManager(acc);
        pm.breadCrumb = callerNd != null ? "Caller: " + caller + " Context: " + callerNd.getContext() + " Model: " + this.getClass() + " Name: " + this.getName() : "Caller: " + caller + " Model: " + this.getClass();
        VolatileMethodSummary redirect = new VolatileMethodSummary(new MethodSummary(asMethod));
        redirect.setStatic(false);
        Instantiator instantiator = new Instantiator(redirect, instructionFactory, pm, this.cha, asMethod, this.scope);
        ParameterAccessor.Parameter self = acc.getThisAs(caller);
        pm.setAllocation(self, null);
        ParameterAccessor modelAcc = new ParameterAccessor(this.model);
        List<ParameterAccessor.Parameter> modelsActivities = modelAcc.allExtend(AndroidTypes.ActivityName, this.getClassHierarchy());
        ArrayList<SSAValue> allActivities = new ArrayList<SSAValue>(modelsActivities.size());
        for (ParameterAccessor.Parameter activity : modelsActivities) {
            SSAValue newInstance;
            TypeReference activityType = activity.getType();
            ParameterAccessor.Parameter inAsMethod = acc.firstOf(activityType);
            if (inAsMethod != null) {
                allActivities.add(inAsMethod);
                continue;
            }
            Atom fdName = activityType.getName().getClassName();
            AndroidModelClass mClass = AndroidModelClass.getInstance(this.cha);
            if (AndroidEntryPointManager.MANAGER.doFlatComponents()) {
                int instPC;
                if (mClass.getField(fdName) != null) {
                    IField field = mClass.getField(fdName);
                    instPC = redirect.getNextProgramCounter();
                    SSAValue target = pm.getUnallocated(activityType, new SSAValue.WeaklyNamedKey(activityType.getName(), "got" + fdName.toString()));
                    SSAGetInstruction getInst = instructionFactory.GetInstruction(instPC, target, field.getReference());
                    redirect.addStatement(getInst);
                    pm.setAllocation(target, getInst);
                    allActivities.add(target);
                    continue;
                }
                newInstance = instantiator.createInstance(activityType, false, null, null);
                allActivities.add(newInstance);
                mClass.putField(fdName, activityType);
                instPC = redirect.getNextProgramCounter();
                FieldReference fdRef = FieldReference.findOrCreate(mClass.getReference(), fdName, activityType);
                SSAPutInstruction putInst = instructionFactory.PutInstruction(instPC, newInstance, fdRef);
                redirect.addStatement(putInst);
                System.out.println("All activities new: " + newInstance);
                continue;
            }
            newInstance = instantiator.createInstance(activityType, false, null, null);
            allActivities.add(newInstance);
        }
        assert (allActivities.size() == modelsActivities.size());
        HashSet<SSAValue> defaults = new HashSet<SSAValue>();
        SSAValue nullBundle = pm.getUnmanaged(AndroidTypes.Bundle, "nullBundle");
        redirect.addConstant(nullBundle.getNumber(), new ConstantValue(null));
        nullBundle.setAssigned();
        defaults.add(nullBundle);
        TypeName intentArray = TypeName.findOrCreate("[Landroid/content/Intent");
        ParameterAccessor.Parameter incoming = acc.firstOf(intentArray);
        if (incoming != null) {
            SSAValue.WeaklyNamedKey unpackedIntentKey = new SSAValue.WeaklyNamedKey(AndroidTypes.IntentName, "unpackedIntent");
            SSAValue unpackedIntent = pm.getUnallocated(AndroidTypes.Intent, unpackedIntentKey);
            int pc = redirect.getNextProgramCounter();
            SSAArrayLoadInstruction fetch = instructionFactory.ArrayLoadInstruction(pc, unpackedIntent, incoming, 0);
            redirect.addStatement(fetch);
            pm.setAllocation(unpackedIntent, fetch);
            defaults.add(unpackedIntent);
        }
        ParameterAccessor.Parameter intent = acc.firstExtends(AndroidTypes.Intent, this.cha);
        AndroidStartComponentTool tool = new AndroidStartComponentTool(this.getClassHierarchy(), asMethod, flags, caller, instructionFactory, acc, pm, redirect, self, info);
        SSAValue androidContext = tool.fetchCallerContext();
        AndroidTypes.AndroidContextType contextType = tool.typeOfCallerContext();
        try {
            IClass declaringClass;
            SSAAbstractInvokeInstruction invokation;
            if (intent != null) {
                tool.setIntent(intent, allActivities);
            } else if (!info.isSystemService()) {
                // empty if block
            }
            List<SSAValue> redirectParams = acc.connectThrough(modelAcc, new HashSet(allActivities), defaults, this.getClassHierarchy(), instantiator, false, null, null);
            int callPC = redirect.getNextProgramCounter();
            CallSiteReference site = CallSiteReference.make(callPC, this.model.getReference(), IInvokeInstruction.Dispatch.STATIC);
            SSAValue exception = pm.getException();
            if (this.model.getReference().getReturnType().equals(TypeReference.Void)) {
                invokation = instructionFactory.InvokeInstruction(callPC, redirectParams, exception, site);
            } else {
                if (this instanceof SystemServiceModel) {
                    IClass declaringClass2;
                    SSAValue svc = pm.getUnmanaged(TypeReference.JavaLangObject, "systemService");
                    invokation = instructionFactory.InvokeInstruction(callPC, svc, redirectParams, exception, site);
                    redirect.addStatement(invokation);
                    if (instructionFactory.isAssignableFrom(svc.getType(), svc.getValidIn().getReturnType())) {
                        int returnPC = redirect.getNextProgramCounter();
                        SSAReturnInstruction returnInstruction = instructionFactory.ReturnInstruction(returnPC, svc);
                        redirect.addStatement(returnInstruction);
                    }
                    if ((declaringClass2 = this.cha.lookupClass(asMethod.getDeclaringClass())) == null) {
                        throw new IllegalStateException("Unable to retreive te IClass of " + asMethod.getDeclaringClass() + " from Method " + asMethod.toString());
                    }
                    redirect.setLocalNames(pm.makeLocalNames());
                    SummarizedMethodWithNames override = new SummarizedMethodWithNames(this.mRef, redirect, declaringClass2);
                    return override;
                }
                if (this instanceof ExternalModel) {
                    SSAValue trash = pm.getUnmanaged(AndroidTypes.Intent, "trash");
                    invokation = instructionFactory.InvokeInstruction(callPC, trash, redirectParams, exception, site);
                } else {
                    throw new UnsupportedOperationException("Can't handle a " + this.model.getClass());
                }
            }
            redirect.addStatement(invokation);
            if (flags.contains((Object)IntentStarters.StarterFlags.CALL_ON_ACTIVITY_RESULT) && !flags.contains((Object)IntentStarters.StarterFlags.CONTEXT_FREE)) {
                ArrayList resultCodes = new ArrayList();
                ArrayList resultData = new ArrayList();
                tool.fetchResults(resultCodes, resultData, allActivities);
                if (resultCodes.size() == 0) {
                    throw new IllegalStateException("The call " + asMethod + " from " + caller + " failed, as the model " + this.model + " did not take an activity to read the result from");
                }
                SSAValue mResultCode = tool.addPhi(resultCodes);
                SSAValue mResultData = tool.addPhi(resultData);
                ParameterAccessor.Parameter outRequestCode = acc.firstOf(TypeReference.Int);
                int callPC2 = redirect.getNextProgramCounter();
                Selector mSel = Selector.make("onActivityResult(IILandroid/content/Intent;)V");
                MethodReference mRef = MethodReference.findOrCreate(caller, mSel);
                CallSiteReference site2 = CallSiteReference.make(callPC2, mRef, IInvokeInstruction.Dispatch.VIRTUAL);
                SSAValue exception2 = pm.getException();
                ArrayList<SSAValue> params = new ArrayList<SSAValue>();
                params.add(self);
                params.add(outRequestCode);
                params.add(mResultCode);
                params.add(mResultData);
                SSAAbstractInvokeInstruction invokation2 = instructionFactory.InvokeInstruction(callPC2, params, exception2, site2);
                redirect.addStatement(invokation2);
            }
            if ((declaringClass = this.cha.lookupClass(asMethod.getDeclaringClass())) == null) {
                throw new IllegalStateException("Unable to retreive te IClass of " + asMethod.getDeclaringClass() + " from Method " + asMethod.toString());
            }
            redirect.setLocalNames(pm.makeLocalNames());
            SummarizedMethodWithNames override = new SummarizedMethodWithNames(this.mRef, redirect, declaringClass);
            return override;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("\nOccured in getMethodAs with parameters of:");
            System.err.println(acc.dump());
            System.err.println("\tpm=\t" + pm);
            System.err.println("\tself=\t" + self);
            System.err.println("\tmodelAcc=\t" + acc.dump());
            System.err.println("\tcontextType=\t" + (Object)((Object)contextType));
            System.err.println("\tandroidContetx=\t" + androidContext);
            System.err.println("\tasMethod=\t" + asMethod);
            System.err.println("\tcaller=\t" + caller);
            System.err.println("\tinfo=\t" + info);
            System.err.println("\tcallerND=\t" + callerNd);
            System.err.println("\tthis=\t" + this.getClass().toString());
            System.err.println("\tthis.name=\t" + this.name);
            throw new IllegalStateException(e);
        }
    }

    public IMethod getMethodEncap() throws CancelException {
        TypeReference clazz = AndroidModelClass.ANDROID_MODEL_CLASS;
        Atom methodName = Atom.concat(this.getName(), Atom.findOrCreateAsciiAtom("Encap"));
        TypeName returnType = TypeReference.VoidName;
        Descriptor descr = Descriptor.findOrCreate(new TypeName[0], returnType);
        MethodReference asMethod = MethodReference.findOrCreate(clazz, methodName, descr);
        AndroidModelClass mClass = AndroidModelClass.getInstance(this.cha);
        if (mClass.containsMethod(asMethod.getSelector())) {
            return mClass.getMethod(asMethod.getSelector());
        }
        VolatileMethodSummary encap = new VolatileMethodSummary(new MethodSummary(asMethod));
        encap.setStatic(true);
        TypeSafeInstructionFactory instructionFactory = new TypeSafeInstructionFactory(this.getClassHierarchy());
        ParameterAccessor acc = new ParameterAccessor(asMethod, false);
        SSAValueManager pm = new SSAValueManager(acc);
        pm.breadCrumb = "Encap: " + this.getClass().toString();
        SummarizedMethod model = this.getMethod();
        ArrayList<SSAValue> params = new ArrayList<SSAValue>();
        FlatInstantiator instantiator = new FlatInstantiator(encap, instructionFactory, pm, this.cha, asMethod, this.scope);
        for (int i = 0; i < model.getNumberOfParameters(); ++i) {
            SSAValue arg;
            TypeReference argT = model.getParameterType(i);
            if (AndroidEntryPointManager.MANAGER.doFlatComponents() && AndroidComponent.isAndroidComponent(argT, this.cha)) {
                Atom fdName = argT.getName().getClassName();
                if (mClass.getField(fdName) != null) {
                    IField field = mClass.getField(fdName);
                    int instPC = encap.getNextProgramCounter();
                    arg = pm.getUnallocated(argT, new SSAValue.WeaklyNamedKey(argT.getName(), "got" + fdName.toString()));
                    SSAGetInstruction getInst = instructionFactory.GetInstruction(instPC, arg, field.getReference());
                    encap.addStatement(getInst);
                    pm.setAllocation(arg, getInst);
                } else {
                    arg = instantiator.createInstance(argT, false, null, null);
                    mClass.putField(fdName, argT);
                    int instPC = encap.getNextProgramCounter();
                    FieldReference fdRef = FieldReference.findOrCreate(mClass.getReference(), fdName, argT);
                    SSAPutInstruction putInst = instructionFactory.PutInstruction(instPC, arg, fdRef);
                    encap.addStatement(putInst);
                }
            } else {
                boolean managed = false;
                SSAValue.TypeKey key = new SSAValue.TypeKey(argT.getName());
                arg = instantiator.createInstance(argT, false, key, null);
            }
            params.add(arg);
        }
        int callPC = encap.getNextProgramCounter();
        CallSiteReference site = CallSiteReference.make(callPC, model.getReference(), IInvokeInstruction.Dispatch.STATIC);
        SSAValue exception = pm.getException();
        SSAAbstractInvokeInstruction invokation = instructionFactory.InvokeInstruction(callPC, params, exception, site);
        encap.addStatement(invokation);
        encap.setLocalNames(pm.makeLocalNames());
        SummarizedMethodWithNames method = new SummarizedMethodWithNames(asMethod, encap, (IClass)mClass);
        mClass.addMethod(method);
        return method;
    }

    @Override
    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public String toString() {
        return "<" + this.getClass() + " name=" + this.name + " />";
    }
}

