/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.FieldImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.SyntheticClass;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ipa.summaries.SummarizedMethodWithNames;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.ssa.SSAValue;
import com.ibm.wala.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AndroidModelClass
extends SyntheticClass {
    private static final Logger logger = LoggerFactory.getLogger(AndroidModelClass.class);
    public static final TypeReference ANDROID_MODEL_CLASS = TypeReference.findOrCreate(ClassLoaderReference.Primordial, TypeName.string2TypeName("Lcom/ibm/wala/AndroidModelClass"));
    private final IClassHierarchy cha;
    private IMethod macroModel = null;
    private final Map<Selector, IMethod> methods = HashMapFactory.make();
    private final Map<Atom, IField> fields = new HashMap<Atom, IField>();

    public static AndroidModelClass getInstance(IClassHierarchy cha) {
        AndroidModelClass mClass;
        IClass android = cha.lookupClass(ANDROID_MODEL_CLASS);
        if (android == null) {
            mClass = new AndroidModelClass(cha);
        } else {
            if (!(android instanceof AndroidModelClass)) {
                throw new IllegalArgumentException(String.format("android model class does not have expected type %s, but %s!", AndroidModelClass.class, android.getClass().toString()));
            }
            mClass = (AndroidModelClass)android;
        }
        return mClass;
    }

    private AndroidModelClass(IClassHierarchy cha) {
        super(ANDROID_MODEL_CLASS, cha);
        this.addMethod(this.clinit());
        this.cha = cha;
        this.cha.addClass(this);
    }

    private SummarizedMethod clinit() {
        MethodReference clinitRef = MethodReference.findOrCreate(this.getReference(), MethodReference.clinitSelector);
        VolatileMethodSummary clinit = new VolatileMethodSummary(new MethodSummary(clinitRef));
        clinit.setStatic(true);
        TypeSafeInstructionFactory instructionFactory = new TypeSafeInstructionFactory(this.cha);
        Set<TypeReference> components = AndroidEntryPointManager.getComponents();
        int ssaNo = 1;
        if (AndroidEntryPointManager.MANAGER.doFlatComponents()) {
            for (TypeReference component : components) {
                SSAValue instance = new SSAValue(ssaNo++, component, clinitRef);
                int pc = clinit.getNextProgramCounter();
                NewSiteReference nRef = NewSiteReference.make(pc, component);
                SSANewInstruction instr = instructionFactory.NewInstruction(pc, instance, nRef);
                clinit.addStatement(instr);
                pc = clinit.getNextProgramCounter();
                MethodReference ctor = MethodReference.findOrCreate(component, MethodReference.initSelector);
                CallSiteReference site = CallSiteReference.make(pc, ctor, IInvokeInstruction.Dispatch.SPECIAL);
                SSAValue exception = new SSAValue(ssaNo++, TypeReference.JavaLangException, clinitRef);
                ArrayList<SSAValue> params = new ArrayList<SSAValue>();
                params.add(instance);
                SSAAbstractInvokeInstruction ctorCall = instructionFactory.InvokeInstruction(pc, params, exception, site);
                clinit.addStatement(ctorCall);
                Atom fdName = component.getName().getClassName();
                this.putField(fdName, component);
                int pc2 = clinit.getNextProgramCounter();
                FieldReference fdRef = FieldReference.findOrCreate(this.getReference(), fdName, component);
                SSAPutInstruction putInst = instructionFactory.PutInstruction(pc2, instance, fdRef);
                clinit.addStatement(putInst);
            }
        }
        return new SummarizedMethodWithNames(clinitRef, clinit, (IClass)this);
    }

    public boolean containsMethod(Selector selector) {
        return this.macroModel != null && this.macroModel.getSelector().equals(selector) || this.methods.containsKey(selector);
    }

    @Override
    public IMethod getMethod(Selector selector) {
        if (this.macroModel != null && this.macroModel.getSelector().equals(selector)) {
            return this.macroModel;
        }
        if (this.methods.containsKey(selector)) {
            return this.methods.get(selector);
        }
        if (selector.equals(MethodReference.initSelector)) {
            logger.warn("AndroidModelClass is not intended to be initialized");
            return null;
        }
        throw new IllegalArgumentException("Could not resolve " + selector);
    }

    public Collection<IMethod> getDeclaredMethods() {
        HashSet methods = HashSetFactory.make();
        if (this.macroModel != null) {
            methods.add(this.macroModel);
        }
        methods.addAll(this.methods.values());
        return Collections.unmodifiableCollection(methods);
    }

    public Collection<IMethod> getAllMethods() {
        return this.getDeclaredMethods();
    }

    void setMacroModel(IMethod model) {
        assert (this.macroModel == null);
        this.macroModel = model;
    }

    public void addMethod(IMethod method) {
        if (this.methods.containsKey(method.getSelector())) {
            throw new IllegalStateException("The AndroidModelClass already contains a Method called" + method.getName());
        }
        assert (this.methods != null);
        this.methods.put(method.getSelector(), method);
    }

    @Override
    public IMethod getClassInitializer() {
        return this.getMethod(MethodReference.clinitSelector);
    }

    @Override
    public IField getField(Atom name) {
        return this.fields.getOrDefault(name, null);
    }

    public void putField(Atom name, TypeReference type) {
        FieldReference fdRef = FieldReference.findOrCreate(this.getReference(), name, type);
        int accessFlags = 9;
        FieldImpl field = new FieldImpl(this, fdRef, 9, null, null);
        this.fields.put(name, field);
    }

    @Override
    public Collection<IField> getAllFields() {
        return this.fields.values();
    }

    @Override
    public Collection<IField> getDeclaredStaticFields() {
        return this.fields.values();
    }

    @Override
    public Collection<IField> getAllStaticFields() {
        return this.fields.values();
    }

    @Override
    public Collection<IField> getDeclaredInstanceFields() throws UnsupportedOperationException {
        return Collections.emptySet();
    }

    @Override
    public Collection<IField> getAllInstanceFields() {
        return Collections.emptySet();
    }

    @Override
    public int getModifiers() {
        return 17;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isArrayClass() {
        return false;
    }

    @Override
    public IClass getSuperclass() throws UnsupportedOperationException {
        return this.getClassHierarchy().getRootClass();
    }

    @Override
    public Collection<IClass> getAllImplementedInterfaces() {
        return Collections.emptySet();
    }

    public Collection<IClass> getDirectInterfaces() {
        return Collections.emptySet();
    }

    @Override
    public boolean isReferenceType() {
        return this.getReference().isReferenceType();
    }
}

