/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.IInstantiationBehavior;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.Atom;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DefaultInstantiationBehavior
extends IInstantiationBehavior {
    private final Map<BehaviorKey<?>, BehviourValue> behaviours = new HashMap();
    private final transient IClassHierarchy cha;
    private static final long serialVersionUID = 89220020131212L;
    public transient boolean serializationIncludesCache = true;

    public DefaultInstantiationBehavior(IClassHierarchy cha) {
        this.cha = cha;
        this.behaviours.put(BehaviorKey.mkPackage("Ljava/lang"), new BehviourValue(IInstantiationBehavior.InstanceBehavior.CREATE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(TypeName.string2TypeName("Ljava/lang/Object")), new BehviourValue(IInstantiationBehavior.InstanceBehavior.CREATE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(TypeReference.findOrCreateArrayOf(TypeReference.JavaLangObject).getName()), new BehviourValue(IInstantiationBehavior.InstanceBehavior.CREATE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.BundleName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.REUSE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.ActivityName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.REUSE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.ServiceName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.REUSE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.BroadcastReceiverName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.REUSE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.ContentProviderName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.REUSE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.MenuName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.CREATE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.ContextMenuName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.CREATE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.MenuItemName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.CREATE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.ActionModeName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.CREATE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.AttributeSetName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.CREATE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.ActionModeCallbackName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.CREATE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mk(AndroidTypes.KeyEventName), new BehviourValue(IInstantiationBehavior.InstanceBehavior.CREATE, IInstantiationBehavior.Exactness.EXACT, null));
        this.behaviours.put(BehaviorKey.mkPackage("Landroid/support/v4/view"), new BehviourValue(IInstantiationBehavior.InstanceBehavior.REUSE, IInstantiationBehavior.Exactness.EXACT, null));
    }

    @Override
    public IInstantiationBehavior.InstanceBehavior getBehavior(TypeName type, TypeName asParameterTo, MethodReference inCall, String withName) {
        IClassLoader[] packK;
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        BehaviorKey<TypeName> typeK = BehaviorKey.mk(type);
        if (this.behaviours.containsKey(typeK)) {
            BehviourValue typeV = this.behaviours.get(typeK);
            while (typeV.cacheFrom != null) {
                typeV = typeV.cacheFrom;
            }
            return typeV.behaviour;
        }
        Atom pack = type.getPackage();
        if (pack != null && this.behaviours.containsKey(packK = BehaviorKey.mk(pack))) {
            BehviourValue packV = this.behaviours.get(packK);
            IInstantiationBehavior.InstanceBehavior beh = packV.behaviour;
            this.behaviours.put(typeK, new BehviourValue(beh, IInstantiationBehavior.Exactness.PACKAGE, packV));
            return beh;
        }
        if (this.cha != null) {
            IClass testClass = null;
            for (IClassLoader loader : this.cha.getLoaders()) {
                testClass = loader.lookupClass(type);
                if (testClass == null) continue;
                testClass = testClass.getSuperclass();
                break;
            }
            while (testClass != null) {
                BehaviorKey<TypeName> testKey = BehaviorKey.mk(testClass.getName());
                if (this.behaviours.containsKey(testKey)) {
                    BehviourValue value = this.behaviours.get(testKey);
                    IInstantiationBehavior.InstanceBehavior beh = value.behaviour;
                    this.behaviours.put(typeK, new BehviourValue(beh, IInstantiationBehavior.Exactness.INHERITED, value));
                    return beh;
                }
                testClass = testClass.getSuperclass();
            }
        }
        String prefix = type.toString();
        while (prefix.contains("/")) {
            BehaviorKey<Atom> prefixKey = BehaviorKey.mk(Atom.findOrCreateAsciiAtom(prefix = prefix.substring(0, prefix.lastIndexOf(47) - 1)));
            if (!this.behaviours.containsKey(prefixKey)) continue;
            BehviourValue value = this.behaviours.get(prefixKey);
            IInstantiationBehavior.InstanceBehavior beh = value.behaviour;
            this.behaviours.put(typeK, new BehviourValue(beh, IInstantiationBehavior.Exactness.PREFIX, value));
            return beh;
        }
        IInstantiationBehavior.InstanceBehavior beh = this.getDafultBehavior();
        BehviourValue packV = new BehviourValue(beh, IInstantiationBehavior.Exactness.DEFAULT, null);
        this.behaviours.put(typeK, packV);
        return beh;
    }

    @Override
    public IInstantiationBehavior.Exactness getExactness(TypeName type, TypeName asParameterTo, MethodReference inCall, String withName) {
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        BehaviorKey<TypeName> typeK = BehaviorKey.mk(type);
        if (!this.behaviours.containsKey(typeK)) {
            this.getBehavior(type, asParameterTo, inCall, withName);
        }
        return this.behaviours.get(typeK).exactness;
    }

    @Override
    public IInstantiationBehavior.InstanceBehavior getDafultBehavior() {
        return IInstantiationBehavior.InstanceBehavior.REUSE;
    }

    protected static Atom type2atom(TypeName type) {
        return Atom.findOrCreateAsciiAtom(type.toString());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.serializationIncludesCache) {
            stream.writeObject(this.behaviours);
        } else {
            HashMap strippedBehaviours = new HashMap();
            for (Map.Entry<BehaviorKey<?>, BehviourValue> entry : this.behaviours.entrySet()) {
                BehviourValue val = entry.getValue();
                if (val.isCached()) continue;
                strippedBehaviours.put(entry.getKey(), val);
            }
            stream.writeObject(strippedBehaviours);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.behaviours.clear();
        this.behaviours.putAll((Map)stream.readObject());
    }

    static final class BehaviorKey<T>
    implements Serializable {
        private static final long serialVersionUID = -1932639921432060660L;
        final T base;

        public BehaviorKey(T base) {
            this.base = base;
        }

        public static BehaviorKey<TypeName> mk(TypeName base) {
            return new BehaviorKey<TypeName>(base);
        }

        public static BehaviorKey<Atom> mk(Atom base) {
            return new BehaviorKey<Atom>(base);
        }

        public static BehaviorKey<Atom> mkPackage(String pack) {
            return new BehaviorKey<Atom>(Atom.findOrCreateAsciiAtom(pack));
        }

        public boolean equals(Object o) {
            if (o instanceof BehaviorKey) {
                BehaviorKey other = (BehaviorKey)o;
                return this.base.equals(other.base);
            }
            return false;
        }

        public int hashCode() {
            return this.base.hashCode();
        }

        public String toString() {
            return "<BehaviorKey of " + this.base.toString() + '>';
        }
    }

    static final class BehviourValue
    implements Serializable {
        private static final long serialVersionUID = 190943987799306506L;
        public final IInstantiationBehavior.InstanceBehavior behaviour;
        public final IInstantiationBehavior.Exactness exactness;
        public final BehviourValue cacheFrom;

        public BehviourValue(IInstantiationBehavior.InstanceBehavior behaviour, IInstantiationBehavior.Exactness exactness, BehviourValue cacheFrom) {
            this.behaviour = behaviour;
            this.exactness = exactness;
            this.cacheFrom = cacheFrom;
        }

        public boolean isCached() {
            return this.cacheFrom != null;
        }
    }
}

