/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.AndroidModelParameterManager;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.IInstantiationBehavior;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ssa.ParameterAccessor;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.List;

public class ReuseParameters {
    private final IMethod ALL_TARGETS = null;
    private final IInstantiationBehavior instanceBehavior;
    private final AndroidModel forModel;
    private List<TypeName> reuseParameters;

    public ReuseParameters(IInstantiationBehavior instanceBehavior, AndroidModel forModel) {
        this.instanceBehavior = instanceBehavior;
        this.forModel = forModel;
    }

    public void collectParameters(Iterable<? extends Entrypoint> entrypoints) {
        this.reuseParameters = new ArrayList<TypeName>();
        for (Entrypoint entrypoint : entrypoints) {
            int paramCount = entrypoint.getNumberOfParameters();
            for (int i = 0; i < paramCount; ++i) {
                TypeReference[] types = entrypoint.getParameterTypes(i);
                if (types.length < 1) {
                    throw new IllegalStateException("The Etrypoint " + entrypoint + " did not return any types for its " + i + "th parameter");
                }
                for (TypeReference type : types) {
                    TypeName paramType = type.getName();
                    if (!this.isReuse(paramType, this.ALL_TARGETS) || this.reuseParameters.contains(paramType)) continue;
                    this.reuseParameters.add(paramType);
                }
            }
        }
    }

    private static int ssaFor(IMethod inCallTo, int paramNo) {
        assert (paramNo >= 0);
        assert (paramNo < inCallTo.getNumberOfParameters());
        if (inCallTo.isStatic()) {
            return paramNo + 1;
        }
        return paramNo + 1;
    }

    private static int firstOf(TypeName type, IMethod inCallTo) {
        for (int i = 0; i < inCallTo.getNumberOfParameters(); ++i) {
            if (!inCallTo.getParameterType(i).getName().equals(type)) continue;
            return i;
        }
        throw new IllegalArgumentException(type.toString() + " is not a parameter to " + inCallTo);
    }

    public boolean isReuse(TypeName param, IMethod inCallTo) {
        MethodReference inCall;
        TypeName asParameterTo;
        String withName;
        if (inCallTo != null && inCallTo != this.ALL_TARGETS) {
            boolean bcIndex = false;
            int localNumber = ReuseParameters.ssaFor(inCallTo, ReuseParameters.firstOf(param, inCallTo));
            try {
                withName = inCallTo.getLocalVariableName(0, localNumber);
            }
            catch (UnsupportedOperationException e) {
                withName = null;
            }
            asParameterTo = inCallTo.getDeclaringClass().getName();
            inCall = inCallTo.getReference();
        } else {
            withName = null;
            asParameterTo = null;
            inCall = null;
        }
        IInstantiationBehavior.InstanceBehavior beh = this.instanceBehavior.getBehavior(param, asParameterTo, inCall, withName);
        return beh == IInstantiationBehavior.InstanceBehavior.REUSE;
    }

    private Descriptor toDescriptor(TypeName returnType) {
        TypeName[] aTypes = this.reuseParameters.toArray(new TypeName[0]);
        return Descriptor.findOrCreate(aTypes, returnType);
    }

    public MethodReference toMethodReference(AndroidModelParameterManager pm) {
        TypeReference clazz = this.forModel.getDeclaringClass().getReference();
        Atom name = this.forModel.getName();
        TypeName returnType = this.forModel.getReturnType();
        Descriptor descr = this.toDescriptor(returnType);
        MethodReference mRef = MethodReference.findOrCreate(clazz, name, descr);
        if (pm != null) {
            int paramSSA = 1;
            if (!this.forModel.isStatic()) {
                paramSSA = 2;
            }
            int descriptorOffset = this.forModel.isStatic() ? 0 : -1;
            for (TypeName param : this.reuseParameters) {
                String tName = null;
                TypeReference tRef = TypeReference.find(ClassLoaderReference.Primordial, param);
                ReuseParameter rp = new ReuseParameter(paramSSA, tName, tRef, mRef, descriptorOffset);
                pm.setAllocation(rp);
                ++paramSSA;
            }
        }
        return mRef;
    }

    public static class ReuseParameter
    extends ParameterAccessor.Parameter {
        protected ReuseParameter(int number, String name, TypeReference type, MethodReference mRef, int descriptorOffset) {
            super(number, name, type, ParameterAccessor.ParamerterDisposition.PARAM, ParameterAccessor.BasedOn.IMETHOD, mRef, descriptorOffset);
        }
    }
}

