/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters;

import com.ibm.wala.classLoader.IField;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModelClass;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.FlatInstantiator;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ssa.IInstantiator;
import com.ibm.wala.util.ssa.ParameterAccessor;
import com.ibm.wala.util.ssa.SSAValue;
import com.ibm.wala.util.ssa.SSAValueManager;
import com.ibm.wala.util.ssa.TypeSafeInstructionFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SpecializedInstantiator
extends FlatInstantiator {
    final IInstantiator parent;
    private static final Set<TypeReference> understandTypes = new HashSet<TypeReference>();

    public SpecializedInstantiator(VolatileMethodSummary body, TypeSafeInstructionFactory instructionFactory, SSAValueManager pm, IClassHierarchy cha, MethodReference scope, AnalysisScope analysisScope, IInstantiator parent) {
        super(body, instructionFactory, pm, cha, scope, analysisScope, 100);
        this.parent = parent;
    }

    @Override
    public SSAValue createInstance(TypeReference T, boolean asManaged, SSAValue.VariableKey key, Set<? extends SSAValue> seen) {
        return this.createInstance(T, asManaged, key, seen, 0);
    }

    SSAValue createInstance(TypeReference T, boolean asManaged, SSAValue.VariableKey key, Set<? extends SSAValue> seen, int currentDepth) {
        if (seen == null) {
            seen = new HashSet<SSAValue>();
        }
        if (currentDepth > this.maxDepth) {
            SSAValue instance = this.pm.getUnmanaged(T, key);
            instance.setAssigned();
            return instance;
        }
        if (asManaged) {
            if (key == null) {
                throw new IllegalArgumentException("A managed variable needs a key - null given.");
            }
        } else if (key == null) {
            key = new SSAValue.UniqueKey();
        }
        assert (SpecializedInstantiator.understands(T));
        if (T.equals(AndroidTypes.Context)) {
            return this.createContext(T, key);
        }
        if (T.equals(AndroidTypes.ContextWrapper)) {
            return this.createContextWrapper(T, key);
        }
        return null;
    }

    public static boolean understands(TypeReference T) {
        return understandTypes.contains(T);
    }

    public SSAValue createContext(TypeReference T, SSAValue.VariableKey key) {
        SSAValue instance;
        ArrayList<SSAValue> appComponents = new ArrayList<SSAValue>();
        if (AndroidEntryPointManager.MANAGER.doFlatComponents()) {
            AndroidModelClass mClass = AndroidModelClass.getInstance(this.cha);
            for (IField f : mClass.getAllFields()) {
                SSAValue instance2;
                assert (f.isStatic()) : "All fields of AndroidModelClass are expected to be static! " + f + " is not.";
                TypeReference fdType = f.getReference().getFieldType();
                if (!ParameterAccessor.isAssignable(fdType, T, this.cha)) {
                    assert (false) : "Unexpected but not fatal - remove assertion if this happens";
                    continue;
                }
                SSAValue.TypeKey iKey = new SSAValue.TypeKey(fdType.getName());
                if (this.pm.isSeen(iKey)) {
                    instance2 = this.pm.getCurrent(iKey);
                } else {
                    int pc = this.body.getNextProgramCounter();
                    SSAValue.WeaklyNamedKey subKey = new SSAValue.WeaklyNamedKey(fdType.getName(), "ctx" + fdType.getName().getClassName().toString());
                    instance2 = this.pm.getUnallocated(fdType, subKey);
                    SSAGetInstruction getInst = this.instructionFactory.GetInstruction(pc, instance2, f.getReference());
                    this.body.addStatement(getInst);
                    this.pm.setAllocation(instance2, getInst);
                }
                appComponents.add(instance2);
            }
        } else {
            for (TypeReference component : AndroidEntryPointManager.getComponents()) {
                SSAValue.TypeKey iKey = new SSAValue.TypeKey(component.getName());
                if (!this.pm.isSeen(iKey)) continue;
                SSAValue instance3 = this.pm.getCurrent(iKey);
                assert (instance3.getNumber() > 0);
                appComponents.add(instance3);
            }
        }
        if (appComponents.size() == 1) {
            instance = (SSAValue)appComponents.get(0);
        } else if (appComponents.size() > 0) {
            int pc = this.body.getNextProgramCounter();
            instance = this.pm.getFree(T, key);
            assert (pc > 0);
            assert (instance.getNumber() > 0);
            SSAPhiInstruction phi = this.instructionFactory.PhiInstruction(pc, instance, appComponents);
            this.body.addStatement(phi);
            this.pm.setPhi(instance, phi);
        } else {
            instance = this.pm.getUnmanaged(T, key);
            this.body.addConstant(instance.getNumber(), new ConstantValue(null));
            instance.setAssigned();
        }
        return instance;
    }

    public SSAValue createContextWrapper(TypeReference T, SSAValue.VariableKey key) {
        SSAValue.TypeKey contextKey = new SSAValue.TypeKey(AndroidTypes.ContextName);
        SSAValue context = this.pm.isSeen(contextKey) ? this.pm.getCurrent(contextKey) : this.createContext(AndroidTypes.Context, contextKey);
        SSAValue instance = this.pm.getUnallocated(T, key);
        MethodReference ctor = MethodReference.findOrCreate(T, MethodReference.initAtom, Descriptor.findOrCreate(new TypeName[]{AndroidTypes.ContextName}, TypeReference.VoidName));
        ArrayList<SSAValue> params = new ArrayList<SSAValue>();
        params.add(context);
        this.addCallCtor(instance, ctor, params);
        return instance;
    }

    @Override
    public int createInstance(TypeReference type, Object ... instantiatorArgs) {
        Object o;
        Set seen;
        if (!(instantiatorArgs[0] instanceof Boolean)) {
            throw new IllegalArgumentException("Argument 0 to createInstance has to be boolean.");
        }
        if (instantiatorArgs[1] != null && !(instantiatorArgs[1] instanceof SSAValue.VariableKey)) {
            throw new IllegalArgumentException("Argument 1 to createInstance has to be null or an instance of VariableKey");
        }
        if (instantiatorArgs[2] != null && !(instantiatorArgs[2] instanceof Set)) {
            throw new IllegalArgumentException("Argument 2 to createInstance has to be null or an instance of Set<? extends SSAValue>, got: " + instantiatorArgs[2].getClass());
        }
        int currentDepth = instantiatorArgs.length == 4 ? (Integer)instantiatorArgs[3] : 0;
        if (instantiatorArgs[2] != null && !(seen = (Set)instantiatorArgs[2]).isEmpty() && !((o = seen.iterator().next()) instanceof SSAValue)) {
            throw new IllegalArgumentException("Argument 2 to createInstance has to be null or an instance of Set<? extends SSAValue>, got Set<" + o.getClass() + '>');
        }
        return this.createInstance(type, (Boolean)instantiatorArgs[0], (SSAValue.VariableKey)instantiatorArgs[1], (Set)instantiatorArgs[2], currentDepth).getNumber();
    }

    static {
        understandTypes.add(AndroidTypes.Context);
        understandTypes.add(AndroidTypes.ContextWrapper);
    }
}

