/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.structure;

import com.ibm.wala.dalvik.ipa.callgraph.impl.AndroidEntryPoint;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ssa.SSAValueManager;
import com.ibm.wala.util.ssa.TypeSafeInstructionFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAndroidModel {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAndroidModel.class);
    private AndroidEntryPoint.ExecutionOrder currentSection = null;
    protected VolatileMethodSummary body = null;
    protected TypeSafeInstructionFactory insts = null;
    protected SSAValueManager paramManager = null;
    protected Iterable<? extends Entrypoint> entryPoints = null;
    private AndroidEntryPoint.IExecutionOrder lastQueriedMethod = null;

    protected List<TypeReference> returnTypesBetween(AndroidEntryPoint.IExecutionOrder start, AndroidEntryPoint.IExecutionOrder end) {
        assert (start != null) : "The argument start was null";
        assert (end != null) : "The argument end was null";
        ArrayList<TypeReference> returnTypes = new ArrayList<TypeReference>();
        for (Entrypoint entrypoint : this.entryPoints) {
            if (entrypoint instanceof AndroidEntryPoint) {
                AndroidEntryPoint aep = (AndroidEntryPoint)entrypoint;
                if (aep.compareTo(start) < 0 || aep.compareTo(end) > 0 || aep.getMethod().getReturnType().equals(TypeReference.Void) || aep.getMethod().getReturnType().isPrimitiveType() || returnTypes.contains(aep.getMethod().getReturnType())) continue;
                returnTypes.add(aep.getMethod().getReturnType());
                continue;
            }
            throw new IllegalArgumentException("Entrypoint (given to Constructor) is not an AndroidEntryPoint!");
        }
        return returnTypes;
    }

    public AbstractAndroidModel(VolatileMethodSummary body, TypeSafeInstructionFactory insts, SSAValueManager paramManager, Iterable<? extends Entrypoint> entryPoints) {
        if (body == null) {
            throw new IllegalArgumentException("The argument body may not be null.");
        }
        if (insts == null) {
            throw new IllegalArgumentException("The argument insts may not be null.");
        }
        if (entryPoints == null) {
            throw new IllegalArgumentException("The argument entryPoints may not be null.");
        }
        this.body = body;
        this.insts = insts;
        this.paramManager = paramManager;
        this.entryPoints = entryPoints;
    }

    public final boolean hadSectionSwitch(AndroidEntryPoint.IExecutionOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("the argument order may not be null.");
        }
        if (this.currentSection == null) {
            if (this.lastQueriedMethod != null) {
                throw new IllegalStateException("You didn't call AbstractAndroidModel.enter(AT_FIRST) after a section-switch");
            }
            this.lastQueriedMethod = order;
            return true;
        }
        if (order.compareTo(this.lastQueriedMethod) < 0) {
            throw new IllegalArgumentException("This method is meant to be called on AndoidEntrypoints in ascending order");
        }
        if (this.currentSection.compareTo(this.lastQueriedMethod.getSection()) != 0 && order.getSection().compareTo(this.lastQueriedMethod.getSection()) == 0) {
            throw new IllegalStateException("You didn't call AbstractAndroidModel.enter(" + order.getSection() + ") after a section-switch");
        }
        this.lastQueriedMethod = order;
        return this.currentSection.compareTo(order.getSection()) < 0;
    }

    protected int enterAT_FIRST(int PC) {
        return PC;
    }

    protected int enterBEFORE_LOOP(int PC) {
        return PC;
    }

    protected int enterSTART_OF_LOOP(int PC) {
        return PC;
    }

    protected int enterMIDDLE_OF_LOOP(int PC) {
        return PC;
    }

    protected int enterMULTIPLE_TIMES_IN_LOOP(int PC) {
        return PC;
    }

    protected int enterEND_OF_LOOP(int PC) {
        return PC;
    }

    protected int enterAFTER_LOOP(int PC) {
        return PC;
    }

    protected int enterAT_LAST(int PC) {
        return PC;
    }

    protected int leaveAT_LAST(int PC) {
        return PC;
    }

    public int enter(AndroidEntryPoint.ExecutionOrder section, int PC) {
        section = section.getSection();
        if (this.currentSection != null && this.currentSection.compareTo(section) >= 0) {
            if (this.currentSection.compareTo(section) == 0) {
                logger.error("You entered {} twice! Ignoring second atempt.", (Object)section);
            } else {
                throw new IllegalArgumentException("Sections must be in ascending order! When trying to enter " + this.currentSection.toString() + " from " + section.toString());
            }
        }
        if (PC < 0) {
            throw new IllegalArgumentException("The PC can't be negative!");
        }
        if (section.compareTo(AndroidEntryPoint.ExecutionOrder.AT_FIRST) == 0 && this.currentSection != null) {
            throw new IllegalArgumentException("Sections must be in ascending order!");
        }
        if (this.currentSection == null && section.compareTo(AndroidEntryPoint.ExecutionOrder.AT_FIRST) >= 0) {
            logger.info("ENTER: AT_FIRST");
            PC = this.enterAT_FIRST(PC);
            this.currentSection = AndroidEntryPoint.ExecutionOrder.AT_FIRST;
        }
        if (this.currentSection.compareTo(AndroidEntryPoint.ExecutionOrder.AT_FIRST) <= 0 && section.compareTo(AndroidEntryPoint.ExecutionOrder.BEFORE_LOOP) >= 0) {
            logger.info("ENTER: BEFORE_LOOP");
            PC = this.enterBEFORE_LOOP(PC);
            this.currentSection = AndroidEntryPoint.ExecutionOrder.BEFORE_LOOP;
        }
        if (this.currentSection.compareTo(AndroidEntryPoint.ExecutionOrder.BEFORE_LOOP) <= 0 && section.compareTo(AndroidEntryPoint.ExecutionOrder.START_OF_LOOP) >= 0) {
            logger.info("ENTER: START_OF_LOOP");
            PC = this.enterSTART_OF_LOOP(PC);
            this.currentSection = AndroidEntryPoint.ExecutionOrder.START_OF_LOOP;
        }
        if (this.currentSection.compareTo(AndroidEntryPoint.ExecutionOrder.START_OF_LOOP) <= 0 && section.compareTo(AndroidEntryPoint.ExecutionOrder.MIDDLE_OF_LOOP) >= 0) {
            logger.info("ENTER: MIDDLE_OF_LOOP");
            PC = this.enterMIDDLE_OF_LOOP(PC);
            this.currentSection = AndroidEntryPoint.ExecutionOrder.MIDDLE_OF_LOOP;
        }
        if (this.currentSection.compareTo(AndroidEntryPoint.ExecutionOrder.MIDDLE_OF_LOOP) <= 0 && section.compareTo(AndroidEntryPoint.ExecutionOrder.MULTIPLE_TIMES_IN_LOOP) >= 0) {
            PC = this.enterMULTIPLE_TIMES_IN_LOOP(PC);
            logger.info("ENTER: MULTIPLE_TIMES_IN_LOOP");
            this.currentSection = AndroidEntryPoint.ExecutionOrder.MULTIPLE_TIMES_IN_LOOP;
        }
        if (this.currentSection.compareTo(AndroidEntryPoint.ExecutionOrder.MULTIPLE_TIMES_IN_LOOP) <= 0 && section.compareTo(AndroidEntryPoint.ExecutionOrder.END_OF_LOOP) >= 0) {
            logger.info("ENTER: END_OF_LOOP");
            PC = this.enterEND_OF_LOOP(PC);
            this.currentSection = AndroidEntryPoint.ExecutionOrder.END_OF_LOOP;
        }
        if (this.currentSection.compareTo(AndroidEntryPoint.ExecutionOrder.END_OF_LOOP) <= 0 && section.compareTo(AndroidEntryPoint.ExecutionOrder.AFTER_LOOP) >= 0) {
            logger.info("ENTER: AFTER_LOOP");
            PC = this.enterAFTER_LOOP(PC);
            this.currentSection = AndroidEntryPoint.ExecutionOrder.AFTER_LOOP;
        }
        if (this.currentSection.compareTo(AndroidEntryPoint.ExecutionOrder.AFTER_LOOP) <= 0 && section.compareTo(AndroidEntryPoint.ExecutionOrder.AT_LAST) >= 0) {
            logger.info("ENTER: AT_LAST");
            PC = this.enterAT_LAST(PC);
            this.currentSection = AndroidEntryPoint.ExecutionOrder.AT_LAST;
        }
        return PC;
    }

    public int finish(int PC) {
        if (this.currentSection == null) {
            throw new IllegalStateException("Called finish() on a model that doesn't contain any sections - an empty model of" + this.body.getMethod().toString());
        }
        if (this.currentSection.compareTo(AndroidEntryPoint.ExecutionOrder.AT_LAST) < 0) {
            PC = this.enter(AndroidEntryPoint.ExecutionOrder.AT_LAST, PC);
        }
        PC = this.leaveAT_LAST(PC);
        this.currentSection = new AndroidEntryPoint.ExecutionOrder(Integer.MAX_VALUE);
        this.body = null;
        this.insts = null;
        this.paramManager = null;
        this.entryPoints = null;
        this.lastQueriedMethod = null;
        return PC;
    }
}

