/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.ssa.SSAValue;
import com.ibm.wala.util.ssa.SSAValueManager;
import com.ibm.wala.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;

public class AndroidBoot {
    private TypeSafeInstructionFactory instructionFactory;
    private SSAValueManager pm;
    private VolatileMethodSummary body;
    private SSAValue mainThread = null;
    private SSAValue systemContext = null;
    private SSAValue packageContext = null;

    public void addBootCode(TypeSafeInstructionFactory instructionFactory, SSAValueManager pm, VolatileMethodSummary body) {
        this.instructionFactory = instructionFactory;
        this.pm = pm;
        this.body = body;
        this.mainThread = this.createMainThred();
        this.systemContext = this.createSystemContext(this.mainThread);
        this.packageContext = this.createPackageContext(this.mainThread);
    }

    public SSAValue getSystemContext() {
        if (this.systemContext == null) {
            throw new IllegalStateException("No value for systemContext - was addBootCode called?");
        }
        return this.systemContext;
    }

    public SSAValue getPackageContext() {
        if (this.packageContext == null) {
            throw new IllegalStateException("No value for packageContext - was addBootCode called?");
        }
        return this.packageContext;
    }

    public SSAValue getMainThread() {
        if (this.mainThread == null) {
            throw new IllegalStateException("No value for mainThread - was addBootCode called?");
        }
        return this.mainThread;
    }

    private SSAValue createMainThred() {
        SSAValue mainThread = this.pm.getUnmanaged(AndroidTypes.ActivityThread, "mMainThred");
        int pc = this.body.getNextProgramCounter();
        NewSiteReference nRef = NewSiteReference.make(pc, AndroidTypes.ActivityThread);
        SSANewInstruction newInstr = this.instructionFactory.NewInstruction(pc, mainThread, nRef);
        this.body.addStatement(newInstr);
        pc = this.body.getNextProgramCounter();
        MethodReference mRef = MethodReference.findOrCreate(AndroidTypes.ActivityThread, MethodReference.initSelector);
        SSAValue exception = this.pm.getUnmanaged(TypeReference.JavaLangException, "ctor_exc");
        CallSiteReference site = CallSiteReference.make(pc, mRef, IInvokeInstruction.Dispatch.SPECIAL);
        ArrayList<SSAValue> params = new ArrayList<SSAValue>(1);
        params.add(mainThread);
        SSAAbstractInvokeInstruction ctorCall = this.instructionFactory.InvokeInstruction(pc, params, exception, site);
        this.body.addStatement(ctorCall);
        return mainThread;
    }

    private SSAValue createSystemContext(SSAValue mainThread) {
        SSAValue systemContext = this.pm.getUnmanaged(AndroidTypes.ContextImpl, "systemContextImpl");
        int pc = this.body.getNextProgramCounter();
        Descriptor desc = Descriptor.findOrCreate(new TypeName[0], AndroidTypes.ContextImplName);
        Selector mSel = new Selector(Atom.findOrCreateAsciiAtom("getSystemContext"), desc);
        MethodReference mRef = MethodReference.findOrCreate(AndroidTypes.ActivityThread, mSel);
        CallSiteReference site = CallSiteReference.make(pc, mRef, IInvokeInstruction.Dispatch.VIRTUAL);
        SSAValue exception = this.pm.getException();
        ArrayList<SSAValue> params = new ArrayList<SSAValue>(1);
        params.add(mainThread);
        SSAAbstractInvokeInstruction call = this.instructionFactory.InvokeInstruction(pc, systemContext, params, exception, site);
        this.body.addStatement(call);
        SSAValue falseConst = this.pm.getUnmanaged(TypeReference.Boolean, "falseConst");
        this.body.addConstant(falseConst.getNumber(), new ConstantValue(false));
        falseConst.setAssigned();
        int pc2 = this.body.getNextProgramCounter();
        FieldReference mRestricted = FieldReference.findOrCreate(AndroidTypes.ContextImpl, Atom.findOrCreateAsciiAtom("mRestricted"), TypeReference.Boolean);
        SSAPutInstruction putInst = this.instructionFactory.PutInstruction(pc2, systemContext, falseConst, mRestricted);
        this.body.addStatement(putInst);
        return systemContext;
    }

    private SSAValue createPackageContext(SSAValue mainThread) {
        SSAValue packageContext = this.pm.getUnmanaged(AndroidTypes.ContextImpl, "packageContextImpl");
        int pc = this.body.getNextProgramCounter();
        NewSiteReference nRef = NewSiteReference.make(pc, AndroidTypes.ContextImpl);
        SSANewInstruction newInstr = this.instructionFactory.NewInstruction(pc, packageContext, nRef);
        this.body.addStatement(newInstr);
        pc = this.body.getNextProgramCounter();
        MethodReference mRef = MethodReference.findOrCreate(AndroidTypes.ContextImpl, MethodReference.initSelector);
        SSAValue exception = this.pm.getUnmanaged(TypeReference.JavaLangException, "ctor_exc");
        CallSiteReference site = CallSiteReference.make(pc, mRef, IInvokeInstruction.Dispatch.SPECIAL);
        ArrayList<SSAValue> params = new ArrayList<SSAValue>(1);
        params.add(packageContext);
        SSAAbstractInvokeInstruction ctorCall = this.instructionFactory.InvokeInstruction(pc, params, exception, site);
        this.body.addStatement(ctorCall);
        SSAValue falseConst = this.pm.getUnmanaged(TypeReference.Boolean, "falseConst");
        this.body.addConstant(falseConst.getNumber(), new ConstantValue(false));
        falseConst.setAssigned();
        int pc2 = this.body.getNextProgramCounter();
        FieldReference mRestricted = FieldReference.findOrCreate(AndroidTypes.ContextImpl, Atom.findOrCreateAsciiAtom("mRestricted"), TypeReference.Boolean);
        SSAPutInstruction putInst = this.instructionFactory.PutInstruction(pc2, packageContext, falseConst, mRestricted);
        this.body.addStatement(putInst);
        SSAValue packageName = this.pm.getUnmanaged(TypeReference.JavaLangString, "packageName");
        this.body.addConstant(packageName.getNumber(), new ConstantValue("foo"));
        packageName.setAssigned();
        SSAValue uid = this.pm.getUnmanaged(AndroidTypes.UserHandle, "uid");
        int pc3 = this.body.getNextProgramCounter();
        NewSiteReference nRef2 = NewSiteReference.make(pc3, AndroidTypes.UserHandle);
        SSANewInstruction newInstr2 = this.instructionFactory.NewInstruction(pc3, uid, nRef2);
        this.body.addStatement(newInstr2);
        SSAValue nullApk = this.pm.getUnmanaged(AndroidTypes.LoadedApk, "nullApk");
        this.body.addConstant(nullApk.getNumber(), new ConstantValue(null));
        nullApk.setAssigned();
        SSAValue nullIBinder = this.pm.getUnmanaged(AndroidTypes.IBinder, "nullBinder");
        this.body.addConstant(nullIBinder.getNumber(), new ConstantValue(null));
        nullIBinder.setAssigned();
        int pc4 = this.body.getNextProgramCounter();
        Descriptor desc = Descriptor.findOrCreate(new TypeName[]{AndroidTypes.LoadedApkName, AndroidTypes.IBinderName, AndroidTypes.ActivityThreadName}, TypeReference.VoidName);
        Selector mSel = new Selector(Atom.findOrCreateAsciiAtom("init"), desc);
        MethodReference mRef2 = MethodReference.findOrCreate(AndroidTypes.ContextImpl, mSel);
        SSAValue exception2 = this.pm.getException();
        CallSiteReference site2 = CallSiteReference.make(pc4, mRef2, IInvokeInstruction.Dispatch.VIRTUAL);
        ArrayList<SSAValue> params2 = new ArrayList<SSAValue>(7);
        params2.add(packageContext);
        params2.add(nullApk);
        params2.add(nullIBinder);
        params2.add(mainThread);
        SSAAbstractInvokeInstruction call = this.instructionFactory.InvokeInstruction(pc4, params2, exception2, site2);
        this.body.addStatement(call);
        return packageContext;
    }

    public static enum BootAction {
        CREATE_SYSTEM_CONTEXT,
        CREATE_APK_CONTEXT;

    }
}

