/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModelClass;
import com.ibm.wala.dalvik.ipa.callgraph.impl.AndroidEntryPoint;
import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.MethodSummary;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.ssa.ParameterAccessor;
import com.ibm.wala.util.ssa.SSAValue;
import com.ibm.wala.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.Collection;

public class ExternalModel
extends AndroidModel {
    public final Atom name;
    private SummarizedMethod activityModel;

    @Override
    protected boolean selectEntryPoint(AndroidEntryPoint ep) {
        return false;
    }

    public ExternalModel(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache, AndroidComponent target) {
        super(cha, options, cache);
        if (target == null) {
            throw new IllegalArgumentException("The component type requested to create an ExternalModel for was null");
        }
        this.name = Atom.findOrCreateAsciiAtom("startExternal" + target.toString());
    }

    private void register(SummarizedMethod model) {
        AndroidModelClass mClass = AndroidModelClass.getInstance(this.cha);
        if (!mClass.containsMethod(model.getSelector())) {
            mClass.addMethod(model);
        }
    }

    @Override
    public SummarizedMethod getMethod() throws CancelException {
        if (!this.built) {
            super.build(this.name);
            this.register(this.model);
            this.activityModel = this.model;
        }
        return this.activityModel;
    }

    @Override
    protected void build(Atom name, Collection<? extends AndroidEntryPoint> entrypoints) {
        assert (entrypoints == null || !entrypoints.iterator().hasNext());
        TypeName intentName = AndroidTypes.IntentName;
        TypeName bundleName = AndroidTypes.BundleName;
        Descriptor descr = Descriptor.findOrCreate(new TypeName[]{intentName, TypeReference.IntName, bundleName}, intentName);
        this.mRef = MethodReference.findOrCreate(AndroidModelClass.ANDROID_MODEL_CLASS, name, descr);
        Selector selector = new Selector(name, descr);
        AndroidModelClass mClass = AndroidModelClass.getInstance(this.cha);
        if (mClass.containsMethod(selector)) {
            this.model = (SummarizedMethod)mClass.getMethod(selector);
            return;
        }
        this.body = new VolatileMethodSummary(new MethodSummary(this.mRef));
        this.body.setStatic(true);
        this.populate(null);
        this.klass = AndroidModelClass.getInstance(this.cha);
        this.model = new SummarizedMethod(this.mRef, this.body.getMethodSummary(), this.klass){

            @Override
            public TypeReference getParameterType(int i) {
                IClassHierarchy cha = this.getClassHierarchy();
                TypeReference tRef = super.getParameterType(i);
                if (tRef.isClassType()) {
                    if (cha.lookupClass(tRef) != null) {
                        return tRef;
                    }
                    for (IClass c : cha) {
                        if (!c.getName().toString().equals(tRef.getName().toString())) continue;
                        return c.getReference();
                    }
                    throw new IllegalStateException("Error looking up " + tRef);
                }
                return tRef;
            }
        };
        this.built = true;
    }

    private void populate(Iterable<? extends AndroidEntryPoint> entrypoints) {
        assert (entrypoints == null || !entrypoints.iterator().hasNext());
        assert (!this.built) : "You can only build once";
        TypeSafeInstructionFactory instructionFactory = new TypeSafeInstructionFactory(this.getClassHierarchy());
        ParameterAccessor pAcc = new ParameterAccessor(this.mRef, false);
        ParameterAccessor.Parameter inIntent = pAcc.firstOf(AndroidTypes.IntentName);
        assert (inIntent.getNumber() == 1);
        ParameterAccessor.Parameter inBundle = pAcc.firstOf(AndroidTypes.BundleName);
        assert (inBundle.getNumber() == 3) : "Wrong bundle " + inBundle + " of " + this.mRef;
        int nextLocal = pAcc.getFirstAfter();
        int callPC = this.body.getNextProgramCounter();
        Selector mSel = Selector.make("getExtras()Landroid/os/Bundle;");
        MethodReference mRef = MethodReference.findOrCreate(AndroidTypes.Intent, mSel);
        CallSiteReference site = CallSiteReference.make(callPC, mRef, IInvokeInstruction.Dispatch.VIRTUAL);
        SSAValue exception = new SSAValue(nextLocal++, TypeReference.JavaLangException, this.mRef, "exception");
        SSAValue outBundle = new SSAValue(nextLocal++, inBundle);
        ArrayList<ParameterAccessor.Parameter> params = new ArrayList<ParameterAccessor.Parameter>(1);
        params.add(inIntent);
        SSAAbstractInvokeInstruction invokation = instructionFactory.InvokeInstruction(callPC, outBundle, params, exception, site);
        this.body.addStatement(invokation);
        SSAValue outName = new SSAValue(nextLocal++, TypeReference.JavaLangString, this.mRef, "outName");
        this.body.addConstant(outName.getNumber(), new ConstantValue("my.extra.object"));
        SSAValue outValue = new SSAValue(nextLocal++, TypeReference.Int, this.mRef, "outValue");
        int callPC2 = this.body.getNextProgramCounter();
        Selector mSel2 = Selector.make("putExtra(Ljava/lang/String;I)Landroid/content/Intent;");
        MethodReference mRef2 = MethodReference.findOrCreate(AndroidTypes.Intent, mSel2);
        CallSiteReference site2 = CallSiteReference.make(callPC2, mRef2, IInvokeInstruction.Dispatch.VIRTUAL);
        SSAValue exception2 = new SSAValue(nextLocal++, TypeReference.JavaLangException, this.mRef, "exception");
        SSAValue outIntent = new SSAValue(nextLocal++, inIntent);
        ArrayList<SSAValue> params2 = new ArrayList<SSAValue>(3);
        params2.add(inIntent);
        params2.add(outName);
        params2.add(outValue);
        SSAAbstractInvokeInstruction invokation2 = instructionFactory.InvokeInstruction(callPC2, outIntent, params2, exception2, site2);
        this.body.addStatement(invokation2);
        int returnPC = this.body.getNextProgramCounter();
        SSAReturnInstruction returnInstruction = instructionFactory.ReturnInstruction(returnPC, outIntent);
        this.body.addStatement(returnInstruction);
    }
}

