/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs.ExternalModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs.UnknownTargetModel;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.IntentStarters;
import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Set;

public class Overrides {
    private final AndroidModel caller;
    private final IClassHierarchy cha;
    private final AnalysisOptions options;
    private final IAnalysisCacheView cache;

    public Overrides(AndroidModel caller, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
        this.caller = caller;
        this.cha = cha;
        this.options = options;
        this.cache = cache;
    }

    public MethodTargetSelector overrideAll() throws CancelException {
        HashMap<MethodReference, SummarizedMethod> overrides = HashMapFactory.make();
        EnumMap<AndroidComponent, UnknownTargetModel> callTo = new EnumMap<AndroidComponent, UnknownTargetModel>(AndroidComponent.class);
        MonitorUtil.IProgressMonitor monitor = AndroidEntryPointManager.MANAGER.getProgressMonitor();
        int monitorCounter = 0;
        for (AndroidComponent target : AndroidComponent.values()) {
            AndroidModel targetModel;
            if (AndroidEntryPointManager.EPContainAny(target)) {
                targetModel = new UnknownTargetModel(this.cha, this.options, this.cache, target);
                callTo.put(target, (UnknownTargetModel)targetModel);
                continue;
            }
            targetModel = new ExternalModel(this.cha, this.options, this.cache, target);
            callTo.put(target, (UnknownTargetModel)targetModel);
        }
        IntentStarters starters = new IntentStarters(this.cha);
        Set<Selector> methodsToOverride = starters.getKnownMethods();
        monitor.beginTask("Context-Free overrides", methodsToOverride.size());
        for (Selector mSel : methodsToOverride) {
            monitor.subTask(mSel.getName().toString());
            IntentStarters.StartInfo info = starters.getInfo(mSel);
            info.setContextFree();
            TypeReference inClass = info.getDeclaringClass();
            if (inClass == null) {
                System.err.println("Class does not exist for " + info + " in " + mSel);
                continue;
            }
            MethodReference overrideMe = MethodReference.findOrCreate(inClass, mSel);
            Set<AndroidComponent> possibleTargets = info.getComponentsPossible();
            assert (possibleTargets.size() == 1);
            for (AndroidComponent target : possibleTargets) {
                AndroidModel targetModel = (AndroidModel)callTo.get((Object)target);
                SummarizedMethod override = targetModel.getMethodAs(overrideMe, this.caller.getMethod().getReference().getDeclaringClass(), info, null);
                overrides.put(overrideMe, override);
            }
            monitor.worked(++monitorCounter);
        }
        StartComponentMethodTargetSelector MTSel = new StartComponentMethodTargetSelector(overrides, this.options.getMethodTargetSelector());
        monitor.done();
        return MTSel;
    }

    protected static class StartComponentMethodTargetSelector
    implements MethodTargetSelector {
        protected MethodTargetSelector parent;
        protected MethodTargetSelector child;
        protected final HashMap<MethodReference, SummarizedMethod> syntheticMethods;

        public StartComponentMethodTargetSelector(HashMap<MethodReference, SummarizedMethod> syntheticMethods, MethodTargetSelector child) {
            this.syntheticMethods = syntheticMethods;
            this.parent = null;
            this.child = child;
        }

        public void setParent(MethodTargetSelector parent) {
            if (this.parent != null) {
                throw new IllegalStateException("Parent may only be set once");
            }
            this.parent = parent;
        }

        public void setChild(MethodTargetSelector child) {
            if (this.child != null) {
                throw new IllegalStateException("Child may only be set once");
            }
            this.child = child;
        }

        @Override
        public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass receiver) {
            IMethod resolved;
            IMethod resolved2;
            if (site == null) {
                throw new IllegalArgumentException("site is null");
            }
            if (this.parent != null && (resolved2 = this.parent.getCalleeTarget(caller, site, receiver)) != null) {
                return resolved2;
            }
            MethodReference mRef = site.getDeclaredTarget();
            if (this.syntheticMethods.containsKey(mRef)) {
                if (caller != null) {
                    // empty if block
                }
                if (receiver == null) {
                    // empty if block
                }
                return this.syntheticMethods.get(mRef);
            }
            if (this.child != null && (resolved = this.child.getCalleeTarget(caller, site, receiver)) != null) {
                return resolved;
            }
            return null;
        }
    }
}

