/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa;

import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.strings.Atom;

public class Intent
implements ContextItem,
Comparable<Intent> {
    public static final ContextKey INTENT_KEY = new ContextKey(){};
    public static final Atom UNBOUND = Atom.findOrCreateAsciiAtom("Unbound");
    private Atom action;
    public Atom uri;
    private IntentType type;
    private Explicit explicit = Explicit.UNSET;
    private AndroidComponent targetCompontent;
    private boolean immutable = false;

    public Intent() {
        this.action = null;
    }

    public Intent(String action) {
        this(Atom.findOrCreateAsciiAtom(action));
    }

    public Intent(Atom action) {
        this(action, null);
    }

    public Intent(Atom action, Atom uri) {
        this.action = action;
        this.uri = uri;
        this.type = null;
        this.targetCompontent = null;
    }

    public Intent(TypeName action, Atom uri) {
        this(Atom.findOrCreateAsciiAtom(action.toString()), uri);
    }

    public Intent(TypeName action) {
        this(action, null);
    }

    public void setExplicit() {
        switch (this.explicit) {
            case UNSET: {
                this.explicit = Explicit.EXPLICIT;
                break;
            }
            case EXPLICIT: {
                this.unbind();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("unexpected explicitness setting %s", new Object[]{this.explicit}));
            }
        }
    }

    public boolean isExplicit() {
        return this.explicit == Explicit.EXPLICIT;
    }

    public void setImmutable() {
        this.immutable = true;
    }

    public Intent clone() {
        Intent clone = new Intent();
        clone.action = this.action;
        clone.uri = this.uri;
        clone.type = this.type;
        clone.explicit = this.explicit;
        clone.targetCompontent = this.targetCompontent;
        return clone;
    }

    public void setActionExplicit(Atom action) {
        if (action == null) {
            throw new IllegalArgumentException("Action may not be null!");
        }
        if (this.action == null) {
            assert (this.explicit == Explicit.UNSET) : "No Action but Intent is not UNSET - is " + (Object)((Object)this.explicit);
            assert (!this.immutable) : "Intent was marked immutable - can't change it.";
            this.action = action;
            this.explicit = Explicit.EXPLICIT;
        } else if (this.isExplicit() && !this.action.equals(action)) {
            this.unbind();
        } else if (!this.isExplicit()) {
            assert (!this.immutable) : "Intent was marked immutable - can't change it.";
            this.action = action;
            this.explicit = Explicit.EXPLICIT;
        }
    }

    public void unbind() {
        assert (!this.immutable) : "Intent was marked immutable - can't change it.";
        this.action = UNBOUND;
        this.type = IntentType.UNKNOWN_TARGET;
        this.explicit = Explicit.MULTI;
    }

    public void setAction(Atom action) {
        if (this.action == null) {
            assert (!this.immutable) : "Intent was marked immutable - can't change it.";
            this.action = action;
        } else if (!this.isExplicit() && !action.equals(this.action)) {
            this.unbind();
        }
    }

    public Atom getAction() {
        if (this.action == null) {
            assert (!this.isExplicit()) : "Beeing explicit implies having an action!";
            return UNBOUND;
        }
        return this.action;
    }

    public IntentType getType() {
        if (this.type != null) {
            return this.type;
        }
        this.type = Intent.isSystemService(this) ? IntentType.SYSTEM_SERVICE : (Intent.isStandardAction(this) ? IntentType.STANDARD_ACTION : (Intent.isInternal(this) ? IntentType.INTERNAL_TARGET : (Intent.isExternal(this) ? IntentType.EXTERNAL_TARGET : IntentType.UNKNOWN_TARGET)));
        return this.type;
    }

    public AndroidComponent getComponent() {
        return this.targetCompontent;
    }

    private static boolean isSystemService(Intent intent) {
        assert (intent.action != null);
        return intent.action.getVal(0) != 76 && intent.action.rIndex((byte)47) < 0 && intent.action.rIndex((byte)46) < 0;
    }

    private static boolean isInternal(Intent intent) {
        return false;
    }

    private static boolean isExternal(Intent intent) {
        if (intent.action == null || intent.action.equals(UNBOUND)) {
            return false;
        }
        String pack = AndroidEntryPointManager.MANAGER.guessPackage();
        if (pack == null) {
            return false;
        }
        return !intent.action.toString().startsWith('L' + pack) && !intent.action.toString().startsWith(pack);
    }

    private static boolean isStandardAction(Intent intent) {
        if (intent.action == null || intent.action.equals(UNBOUND)) {
            return false;
        }
        Atom andoidIntentAction = Atom.findOrCreateAsciiAtom("Landroid/intent/action");
        return intent.action.startsWith(andoidIntentAction);
    }

    public boolean isInternal(boolean strict) {
        IntentType type = this.getType();
        return type == IntentType.INTERNAL_TARGET || !strict && type == IntentType.UNKNOWN_TARGET;
    }

    public boolean isExternal(boolean strict) {
        IntentType type = this.getType();
        return type == IntentType.EXTERNAL_TARGET || type == IntentType.STANDARD_ACTION || !strict && type == IntentType.UNKNOWN_TARGET;
    }

    public boolean isStandard(boolean strict) {
        IntentType type = this.getType();
        return type == IntentType.STANDARD_ACTION || !strict && type == IntentType.UNKNOWN_TARGET;
    }

    public String toString() {
        if (this.action == null || this.action.equals(UNBOUND)) {
            return "Unbound Intent";
        }
        StringBuilder ret = this.getType() == IntentType.SYSTEM_SERVICE ? new StringBuilder("SystemService(") : new StringBuilder("Intent(");
        ret.append(this.action.toString());
        if (this.uri != null) {
            ret.append(", ");
            ret.append(this.uri.toString());
        }
        ret.append(") of type ");
        ret.append((Object)this.getType());
        return ret.toString();
    }

    public int hashCode() {
        if (this.uri != null) {
            return this.getAction().hashCode() * this.uri.hashCode();
        }
        return this.getAction().hashCode();
    }

    public boolean equalAction(Intent other) {
        return this.getAction().equals(other.getAction());
    }

    public boolean equals(Object o) {
        if (o instanceof Intent) {
            Intent other = (Intent)o;
            if (this.uri != null) {
                return this.uri.equals(other.uri) && this.equalAction(other);
            }
            return other.uri == null && this.equalAction(other);
        }
        System.err.println("WARNING: Can't compare Intent to " + o.getClass());
        return false;
    }

    public Intent resolve() {
        return AndroidEntryPointManager.MANAGER.getIntent(this);
    }

    @Override
    public int compareTo(Intent other) {
        return this.getAction().toString().compareTo(other.getAction().toString());
    }

    private static enum Explicit {
        UNSET,
        IMPLICIT,
        EXPLICIT,
        MULTI;

    }

    public static enum IntentType {
        UNKNOWN_TARGET,
        INTERNAL_TARGET,
        EXTERNAL_TARGET,
        STANDARD_ACTION,
        SYSTEM_SERVICE,
        BROADCAST,
        IGNORE;

    }
}

