/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.AndroidModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.MicroModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs.ExternalModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs.SystemServiceModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.stubs.UnknownTargetModel;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.Intent;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.IntentStarters;
import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.propagation.AbstractTypeInNode;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.SummarizedMethod;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRView;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;

public class IntentContextInterpreter
implements SSAContextInterpreter {
    private final IntentStarters intentStarters;
    private final IClassHierarchy cha;
    private final AnalysisOptions options;
    private final IAnalysisCacheView cache;

    public IntentContextInterpreter(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
        this.cha = cha;
        this.options = options;
        this.cache = cache;
        this.intentStarters = new IntentStarters(cha);
    }

    private AndroidComponent fetchTargetComponent(Intent intent, IMethod method) {
        assert (method != null);
        assert (this.intentStarters.getInfo(method.getReference()) != null) : "No IntentStarter for Method " + method + ' ' + intent;
        if (intent.getComponent() != null) {
            return intent.getComponent();
        }
        if (intent.getType() == Intent.IntentType.SYSTEM_SERVICE) {
            return AndroidComponent.UNKNOWN;
        }
        Set<AndroidComponent> possibleTargets = this.intentStarters.getInfo(method.getReference()).getComponentsPossible();
        if (possibleTargets.size() == 1) {
            Iterator<AndroidComponent> it = possibleTargets.iterator();
            return it.next();
        }
        Iterator<AndroidComponent> it = possibleTargets.iterator();
        AndroidComponent targetComponent = it.next();
        return targetComponent;
    }

    private static TypeReference getCaller(Context ctx, CGNode node) {
        if (ctx.get(ContextKey.CALLER) != null) {
            System.out.println("CALLER CONTEXT" + ctx.get(ContextKey.CALLER));
            return node.getMethod().getReference().getDeclaringClass();
        }
        if (ctx.get(ContextKey.CALLSITE) != null) {
            System.out.println("CALLSITE CONTEXT" + ctx.get(ContextKey.CALLSITE));
            return node.getMethod().getReference().getDeclaringClass();
        }
        if (ctx.get(ContextKey.RECEIVER) != null) {
            AbstractTypeInNode aType = (AbstractTypeInNode)ctx.get(ContextKey.RECEIVER);
            return aType.getConcreteType().getReference();
        }
        return node.getMethod().getReference().getDeclaringClass();
    }

    @Override
    public IR getIR(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        Context ctx = node.getContext();
        TypeReference callingClass = IntentContextInterpreter.getCaller(ctx, node);
        if (ctx.get(Intent.INTENT_KEY) != null) {
            try {
                AndroidModel model;
                IntentStarters.StartInfo info;
                Intent inIntent = (Intent)ctx.get(Intent.INTENT_KEY);
                Intent intent = AndroidEntryPointManager.MANAGER.getIntent(inIntent);
                IMethod method = node.getMethod();
                Intent.IntentType type = intent.getType();
                if (intent.getAction().equals(Intent.UNBOUND)) {
                    type = Intent.IntentType.UNKNOWN_TARGET;
                }
                switch (type) {
                    case INTERNAL_TARGET: {
                        info = this.intentStarters.getInfo(method.getReference());
                        model = new MicroModel(this.cha, this.options, this.cache, intent.getAction());
                        break;
                    }
                    case SYSTEM_SERVICE: {
                        info = new IntentStarters.StartInfo(node.getMethod().getReference().getDeclaringClass(), EnumSet.of(Intent.IntentType.SYSTEM_SERVICE), EnumSet.of(AndroidComponent.SERVICE), new int[]{1});
                        model = new SystemServiceModel(this.cha, this.options, this.cache, intent.getAction());
                        break;
                    }
                    case EXTERNAL_TARGET: {
                        info = this.intentStarters.getInfo(method.getReference());
                        model = new ExternalModel(this.cha, this.options, this.cache, this.fetchTargetComponent(intent, method));
                        break;
                    }
                    case STANDARD_ACTION: 
                    case UNKNOWN_TARGET: {
                        info = this.intentStarters.getInfo(method.getReference());
                        model = new UnknownTargetModel(this.cha, this.options, this.cache, this.fetchTargetComponent(intent, method));
                        break;
                    }
                    case IGNORE: {
                        return null;
                    }
                    default: {
                        throw new UnsupportedOperationException("The Intent-Type " + (Object)((Object)intent.getType()) + " is not known to IntentContextInterpreter");
                    }
                }
                assert (info != null) : "IntentInfo is null! Every Starter should have an StartInfo...";
                SummarizedMethod override = model.getMethodAs(method.getReference(), callingClass, info, node);
                return override.makeIR(ctx, this.options.getSSAOptions());
            }
            catch (CancelException e) {
                throw new IllegalStateException("The operation was canceled.", e);
            }
        }
        IMethod method = node.getMethod();
        IntentStarters.StartInfo info = this.intentStarters.getInfo(method.getReference());
        assert (info != null) : "IntentInfo is null! Every Starter should have an StartInfo... - Method " + method.getReference();
        Intent intent = new Intent(Intent.UNBOUND);
        AndroidComponent targetComponent = this.fetchTargetComponent(intent, method);
        try {
            UnknownTargetModel model = new UnknownTargetModel(this.cha, this.options, this.cache, targetComponent);
            SummarizedMethod override = model.getMethodAs(method.getReference(), callingClass, this.intentStarters.getInfo(method.getReference()), node);
            return override.makeIR(ctx, this.options.getSSAOptions());
        }
        catch (CancelException e) {
            throw new IllegalStateException("The operation was canceled.", e);
        }
    }

    @Override
    public IRView getIRView(CGNode node) {
        return this.getIR(node);
    }

    @Override
    public boolean understands(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        MethodReference target = node.getMethod().getReference();
        return this.intentStarters.isStarter(target);
    }

    @Override
    public Iterator<NewSiteReference> iterateNewSites(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        IR ir = this.getIR(node);
        return ir.iterateNewSites();
    }

    @Override
    public Iterator<CallSiteReference> iterateCallSites(CGNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        assert (this.understands(node));
        IR ir = this.getIR(node);
        return ir.iterateCallSites();
    }

    @Override
    public ControlFlowGraph<SSAInstruction, ISSABasicBlock> getCFG(CGNode node) {
        assert (this.understands(node));
        return this.getIR(node).getControlFlowGraph();
    }

    @Override
    public int getNumberOfStatements(CGNode node) {
        assert (this.understands(node));
        return this.getIR(node).getInstructions().length;
    }

    @Override
    public DefUse getDU(CGNode node) {
        assert (this.understands(node));
        return new DefUse(this.getIR(node));
    }

    @Override
    public boolean recordFactoryType(CGNode node, IClass klass) {
        return false;
    }

    @Override
    public Iterator<FieldReference> iterateFieldsWritten(CGNode node) {
        assert (this.understands(node));
        SSAInstruction[] statements = this.getIR(node).getInstructions();
        return CodeScanner.getFieldsWritten(statements).iterator();
    }

    @Override
    public Iterator<FieldReference> iterateFieldsRead(CGNode node) {
        assert (this.understands(node));
        SSAInstruction[] statements = this.getIR(node).getInstructions();
        return CodeScanner.getFieldsRead(statements).iterator();
    }
}

