/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.Intent;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.IntentContext;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.IntentMap;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.IntentStarters;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.util.intset.EmptyIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntentContextSelector
implements ContextSelector {
    private static final Logger logger = LoggerFactory.getLogger(IntentContextSelector.class);
    private final IntentMap intents = new IntentMap();
    private final ContextSelector parent;
    private final IntentStarters intentStarters;

    public IntentContextSelector(IClassHierarchy cha) {
        this(null, cha);
    }

    public IntentContextSelector(ContextSelector parent, IClassHierarchy cha) {
        this.parent = parent;
        this.intentStarters = new IntentStarters(cha);
    }

    @Override
    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] actualParameters) {
        Context ctx = null;
        if (this.parent != null) {
            ctx = this.parent.getCalleeTarget(caller, site, callee, actualParameters);
            assert (ctx.get(Intent.INTENT_KEY) == null) : "Already have Intent: " + ctx + " caller " + caller + " callee " + callee;
        }
        if (this.intentStarters.isStarter(callee.getReference())) {
            Intent intent = null;
            for (InstanceKey actualParameter : actualParameters) {
                InstanceKey param = actualParameter;
                if (param == null || !param.getConcreteType().getName().equals(AndroidTypes.IntentName)) continue;
                if (!this.intents.contains(param)) {
                    logger.error("Unable to resolve Intent called from {}", (Object)caller.getMethod());
                    logger.error("Search Key: {} hash: {}", (Object)param, (Object)param.hashCode());
                    break;
                }
                intent = this.intents.find(param);
                break;
            }
            if (intent != null) {
                AndroidEntryPointManager.MANAGER.addCallSeen(site, intent);
                Intent iintent = this.intents.findOrCreateImmutable(intent);
                return new IntentContext(ctx, iintent);
            }
            logger.warn("Encountered unresolvable Intent");
            intent = new Intent("Unresolvable");
            intent.setImmutable();
            AndroidEntryPointManager.MANAGER.addCallSeen(site, intent);
            return new IntentContext(ctx, intent);
        }
        if (callee.getReference().toString().contains("getSystemService")) {
            Intent intent;
            assert (actualParameters.length == 2) : "PARAMS LENGTH IS" + actualParameters.length;
            InstanceKey param = actualParameters[1];
            if (param instanceof ConstantKey) {
                String target = (String)((ConstantKey)param).getValue();
                intent = new Intent(target){

                    @Override
                    public Intent.IntentType getType() {
                        return Intent.IntentType.SYSTEM_SERVICE;
                    }
                };
            } else {
                intent = null;
                if (param == null) {
                    logger.warn("Got param as 'null'. Obviously can't handle this. Caller was: {}", (Object)caller.getMethod());
                } else {
                    logger.warn("Got param as {}. Can't handle this :(", (Object)param.getClass());
                }
            }
            if (intent != null) {
                AndroidEntryPointManager.MANAGER.addCallSeen(site, intent);
                logger.info("SystemService {} in {} by {}", intent, site, caller);
                Intent iintent = this.intents.findOrCreateImmutable(intent);
                return new IntentContext(ctx, iintent);
            }
        } else if (callee.isInit() && callee.getDeclaringClass().getName().equals(AndroidTypes.IntentName)) {
            InstanceKey actionKey;
            InstanceKey self = actualParameters[0];
            Selector calleeSel = callee.getSelector();
            boolean isExplicit = false;
            switch (callee.getNumberOfParameters()) {
                case 1: {
                    logger.debug("Handling Intent()");
                    actionKey = null;
                    break;
                }
                case 2: {
                    if (calleeSel.equals(Selector.make("<init>(Ljava/lang/String;)V"))) {
                        logger.debug("Handling Intent(String action)");
                        actionKey = actualParameters[1];
                        break;
                    }
                    if (calleeSel.equals(Selector.make("<init>(Landroid/content/Intent;)V"))) {
                        logger.debug("Handling Intent(Intent other)");
                        InstanceKey inIntent = actualParameters[1];
                        if (this.intents.contains(inIntent)) {
                            this.intents.put(self, this.intents.find(inIntent));
                        } else {
                            logger.warn("In Intent-Copy constructor: Unable to find the original");
                        }
                        actionKey = null;
                        break;
                    }
                    logger.error("No handling implemented for: {}", (Object)callee);
                    actionKey = null;
                    break;
                }
                case 3: {
                    if (calleeSel.equals(Selector.make("<init>(Ljava/lang/String;Landroid/net/Uri;)V"))) {
                        logger.debug("Handling Intent(String action, Uri uri)");
                        actionKey = actualParameters[1];
                        break;
                    }
                    if (calleeSel.equals(Selector.make("<init>(Landroid/content/Context;Ljava/lang/Class;)V"))) {
                        logger.debug("Handling Intent(Context, Class)");
                        actionKey = actualParameters[2];
                        isExplicit = true;
                        break;
                    }
                    logger.error("No handling implemented for: {}", (Object)callee);
                    actionKey = null;
                    break;
                }
                case 5: {
                    if (calleeSel.equals(Selector.make("<init>(Ljava/lang/String;Landroid/net/Uri;Landroid/content/Context;Ljava/lang/Class;)V"))) {
                        logger.debug("Handling Intent(String action, Uri uri, Context, Class)");
                        actionKey = actualParameters[4];
                        isExplicit = true;
                        break;
                    }
                    logger.error("No handling implemented for: {}", (Object)callee);
                    actionKey = null;
                    break;
                }
                default: {
                    logger.error("Can't extract Info from Intent-Constructor: {} (not implemented)", (Object)site);
                    actionKey = null;
                }
            }
            Intent intent = this.intents.findOrCreate(self);
            if (actionKey == null) {
                logger.trace("Got action as 'null'. Obviously can't handle this. Caller was {}", (Object)caller.getMethod());
                if (isExplicit) {
                    logger.warn("An Intent with undeteminable target would be explicit - unbinding. Caller was {}", (Object)caller.getMethod());
                    intent.unbind();
                }
            } else {
                this.intents.setAction(self, actionKey, isExplicit);
            }
            logger.debug("Setting the target of Intent {} in {} by {}", intent, site, caller);
        } else if (callee.getSelector().equals(Selector.make("setAction(Ljava/lang/String;)Landroid/content/Intent;")) && callee.getDeclaringClass().getName().equals(AndroidTypes.IntentName)) {
            InstanceKey self = actualParameters[0];
            InstanceKey actionKey = actualParameters[1];
            Intent intent = this.intents.find(self);
            if (AndroidEntryPointManager.MANAGER.isAllowIntentRerouting()) {
                logger.warn("Re-Setting the target of Intent {} in {} by {}", intent, site, caller);
                this.intents.setAction(self, actionKey, false);
            } else {
                this.intents.unbind(self);
            }
            logger.info("Encountered Intent.setAction - Intent is now: {}", (Object)intent);
        } else if (callee.getSelector().equals(Selector.make("setComponent(Landroid/content/ComponentName;)Landroid/content/Intent;"))) {
            InstanceKey self = actualParameters[0];
            Intent intent = this.intents.find(self);
            logger.warn("Re-Setting the target of Intent {} in {} by {}", intent, site, caller);
            intent.setExplicit();
            this.intents.unbind(self);
        } else if (callee.getSelector().equals(Selector.make("setClass(Landroid/content/Context;Ljava/lang/Class;)Landroid/content/Intent;")) || callee.getSelector().equals(Selector.make("setClassName(Ljava/lang/String;Ljava/lang/String;)Landroid/content/Intent;")) || callee.getSelector().equals(Selector.make("setClassName(Landroid/content/Context;Ljava/lang/String;)Landroid/content/Intent;"))) {
            InstanceKey self = actualParameters[0];
            InstanceKey actionKey = actualParameters[2];
            Intent intent = this.intents.find(self);
            if (AndroidEntryPointManager.MANAGER.isAllowIntentRerouting()) {
                logger.warn("Re-Setting the target of Intent {} in {} by {}", intent, site, caller);
                this.intents.setAction(self, actionKey, true);
            } else {
                this.intents.unbind(self);
            }
            logger.info("Encountered Intent.setClass - Intent is now: {}", (Object)intent);
        } else if (callee.getSelector().equals(Selector.make("fillIn(Landroid/content/Intent;I)I"))) {
            logger.warn("Intent.fillIn not implemented - Caller: {}", (Object)caller);
            InstanceKey self = actualParameters[0];
            this.intents.unbind(self);
        } else if (callee.isInit() && callee.getDeclaringClass().getName().equals(AndroidTypes.IntentSenderName)) {
            logger.error("Unable to evaluate IntentSender: Not implemented!");
        }
        return ctx;
    }

    @Override
    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        IntSet ret = this.parent != null ? this.parent.getRelevantParameters(caller, site) : EmptyIntSet.instance;
        MethodReference target = site.getDeclaredTarget();
        if (this.intentStarters.isStarter(target)) {
            IntentStarters.StartInfo info = this.intentStarters.getInfo(target);
            int[] relevant = info.getRelevant();
            if (relevant != null) {
                for (int element : relevant) {
                    ret = IntSetUtil.add(ret, element);
                }
            }
            logger.debug("Get relevant for {} is {}", (Object)site, (Object)ret);
        } else {
            if (site.isSpecial() && target.getDeclaringClass().getName().equals(AndroidTypes.IntentName)) {
                MethodReference mRef = site.getDeclaredTarget();
                int numArgs = mRef.getNumberOfParameters();
                switch (numArgs) {
                    case 0: {
                        return EmptyIntSet.instance;
                    }
                    case 1: {
                        return IntSetUtil.make(new int[]{0, 1});
                    }
                    case 2: {
                        logger.debug("Got Intent Constructor of: {}", (Object)site.getDeclaredTarget().getSelector());
                        return IntSetUtil.make(new int[]{0, 1, 2});
                    }
                    case 3: {
                        logger.debug("Got Intent Constructor of: {}", (Object)site.getDeclaredTarget().getSelector());
                        return IntSetUtil.make(new int[]{0, 1, 2, 3});
                    }
                    case 4: {
                        logger.debug("Got Intent Constructor of: {}", (Object)site.getDeclaredTarget().getSelector());
                        return IntSetUtil.make(new int[]{0, 1, 2, 3, 4});
                    }
                }
                logger.debug("Got Intent Constructor of: {}", (Object)site.getDeclaredTarget().getSelector());
                return IntSetUtil.make(new int[]{0, 1, 2, 3, 4, 5});
            }
            if (site.isSpecial() && target.getDeclaringClass().getName().equals(AndroidTypes.IntentSenderName)) {
                logger.warn("Encountered an IntentSender-Object: {}", (Object)target);
                if (target.getNumberOfParameters() == 0) {
                    return IntSetUtil.make(new int[]{0});
                }
                return IntSetUtil.make(new int[]{0, 1});
            }
            if (target.getSelector().equals(Selector.make("getSystemService(Ljava/lang/String;)Ljava/lang/Object;"))) {
                logger.debug("Encountered Context.getSystemService()");
                return IntSetUtil.make(new int[]{0, 1});
            }
            if (target.getSelector().equals(Selector.make("setAction(Ljava/lang/String;)Landroid/content/Intent;"))) {
                return IntSetUtil.make(new int[]{0, 1});
            }
            if (target.getSelector().equals(Selector.make("setComponent(Landroid/content/ComponentName;)Landroid/content/Intent;"))) {
                return IntSetUtil.make(new int[]{0});
            }
            if (target.getSelector().equals(Selector.make("setClass(Landroid/content/Context;Ljava/lang/Class;)Landroid/content/Intent;"))) {
                return IntSetUtil.make(new int[]{0, 2});
            }
            if (target.getSelector().equals(Selector.make("setClassName(Landroid/content/Context;Ljava/lang/String;)Landroid/content/Intent;"))) {
                return IntSetUtil.make(new int[]{0, 2});
            }
            if (target.getSelector().equals(Selector.make("setClassName(Ljava/lang/String;Ljava/lang/String;)Landroid/content/Intent;"))) {
                return IntSetUtil.make(new int[]{0, 2});
            }
        }
        return ret;
    }
}

