/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa;

import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.Intent;
import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidTypes;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;

public class IntentStarters {
    private final boolean doIntentSender = true;
    private final HashMap<Selector, StartInfo> starters = HashMapFactory.make();

    public boolean isStarter(MethodReference mRef) {
        return this.starters.containsKey(mRef.getSelector());
    }

    public StartInfo getInfo(MethodReference mRef) {
        return this.starters.get(mRef.getSelector());
    }

    public StartInfo getInfo(Selector mSel) {
        return this.starters.get(mSel);
    }

    public Set<Selector> getKnownMethods() {
        return this.starters.keySet();
    }

    public IntentStarters(IClassHierarchy cha) {
        boolean doUsers;
        ClassLoaderReference searchLoader = ClassLoaderReference.Primordial;
        TypeReference tContextWrapper = TypeReference.find(searchLoader, "Landroid/content/ContextWrapper");
        TypeReference tContext = TypeReference.find(searchLoader, "Landroid/content/Context");
        TypeReference tActivity = TypeReference.find(searchLoader, "Landroid/app/Activity");
        boolean doFragments = cha.lookupClass(AndroidTypes.Fragment) != null;
        boolean bl = doUsers = cha.lookupClass(AndroidTypes.UserHandle) != null;
        if (!doFragments) {
            System.out.println("WARNING: IntentStarters skipping starters with Fragments - Stubs to old!");
        }
        if (!doUsers) {
            System.out.println("WARNING: IntentStarters skipping starters with UserHandles - Stubs to old!");
        }
        this.starters.put(Selector.make("bindService(Landroid/content/Intent;Landroid/content/ServiceConnection;I)Z"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.SERVICE), new int[]{1}));
        this.starters.put(Selector.make("sendBroadcast(Landroid/content/Intent;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        this.starters.put(Selector.make("sendBroadcast(Landroid/content/Intent;Ljava/lang/String;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        if (doUsers) {
            this.starters.put(Selector.make("sendBroadcastAsUser(Landroid/content/Intent;Landroid/os/UserHandle;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
            this.starters.put(Selector.make("sendBroadcastAsUser(Landroid/content/Intent;Landroid/os/UserHandle;Ljava/lang/String;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        }
        this.starters.put(Selector.make("sendOrderedBroadcast(Landroid/content/Intent;Ljava/lang/String;Landroid/content/BroadcastReceiver;Landroid/os/Handler;ILjava/lang/String;Landroid/os/Bundle;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        this.starters.put(Selector.make("sendOrderedBroadcast(Landroid/content/Intent;Ljava/lang/String;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        if (doUsers) {
            this.starters.put(Selector.make("sendOrderedBroadcastAsUser(Landroid/content/Intent;Landroid/os/UserHandle;Ljava/lang/String;Landroid/content/BroadcastReceiver;Landroid/os/Handler;ILjava/lang/String;Landroid/os/Bundle;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        }
        this.starters.put(Selector.make("sendStickyBroadcast(Landroid/content/Intent;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        if (doUsers) {
            this.starters.put(Selector.make("sendStickyBroadcastAsUser(Landroid/content/Intent;Landroid/os/UserHandle;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        }
        this.starters.put(Selector.make("sendStickyOrderedBroadcast(Landroid/content/Intent;Ljava/lang/String;Landroid/content/BroadcastReceiver;Landroid/os/Handler;ILjava/lang/String;Landroid/os/Bundle;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        if (doUsers) {
            this.starters.put(Selector.make("sendStickyOrderedBroadcastAsUser(Landroid/content/Intent;Landroid/os/UserHandle;Landroid/content/BroadcastReceiver;Landroid/os/Handler;ILjava/lang/String;Landroid/os/Bundle;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        }
        this.starters.put(Selector.make("startActivities([Landroid/content/Intent;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivities([Landroid/content/Intent;Landroid/os/Bundle;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivity(Landroid/content/Intent;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivity(Landroid/content/Intent;Landroid/os/Bundle;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startIntentSender(Landroid/content/IntentSender;Landroid/content/Intent;IIILandroid/os/Bundle;)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1, 2}, EnumSet.of(StarterFlags.QUENCH_PERMISSIONS)));
        this.starters.put(Selector.make("startIntentSender(Landroid/content/IntentSender;Landroid/content/Intent;III)V"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1, 2}, EnumSet.of(StarterFlags.QUENCH_PERMISSIONS)));
        this.starters.put(Selector.make("startService(Landroid/content/Intent;)Landroid/content/ComponentName;"), new StartInfo(tContextWrapper, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.SERVICE), new int[]{1}));
        this.starters.put(Selector.make("bindService(Landroid/content/Intent;Landroid/content/ServiceConnection;I)Z"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.SERVICE), new int[]{1}));
        this.starters.put(Selector.make("sendBroadcast(Landroid/content/Intent;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        this.starters.put(Selector.make("sendBroadcast(Landroid/content/Intent;Ljava/lang/String;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        if (doUsers) {
            this.starters.put(Selector.make("sendBroadcastAsUser(Landroid/content/Intent;Landroid/os/UserHandle;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
            this.starters.put(Selector.make("sendBroadcastAsUser(Landroid/content/Intent;Landroid/os/UserHandle;Ljava/lang/String;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        }
        this.starters.put(Selector.make("sendOrderedBroadcast(Landroid/content/Intent;Ljava/lang/String;Landroid/content/BroadcastReceiver;Landroid/os/Handler;ILjava/lang/String;Landroid/os/Bundle;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        this.starters.put(Selector.make("sendOrderedBroadcast(Landroid/content/Intent;Ljava/lang/String;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        if (doUsers) {
            this.starters.put(Selector.make("sendOrderedBroadcastAsUser(Landroid/content/Intent;Landroid/os/UserHandle;Ljava/lang/String;Landroid/content/BroadcastReceiver;Landroid/os/Handler;ILjava/lang/String;Landroid/os/Bundle;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
            this.starters.put(Selector.make("sendStickyBroadcast(Landroid/content/Intent;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
            this.starters.put(Selector.make("sendStickyBroadcastAsUser(Landroid/content/Intent;Landroid/os/UserHandle;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        }
        this.starters.put(Selector.make("sendStickyOrderedBroadcast(Landroid/content/Intent;Ljava/lang/String;Landroid/content/BroadcastReceiver;Landroid/os/Handler;ILjava/lang/String;Landroid/os/Bundle;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        if (doUsers) {
            this.starters.put(Selector.make("sendStickyOrderedBroadcastAsUser(Landroid/content/Intent;Landroid/os/UserHandle;Landroid/content/BroadcastReceiver;Landroid/os/Handler;ILjava/lang/String;Landroid/os/Bundle;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.BROADCAST), EnumSet.of(AndroidComponent.BROADCAST_RECEIVER), new int[]{1}));
        }
        this.starters.put(Selector.make("startActivities([Landroid/content/Intent;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivities([Landroid/content/Intent;Landroid/os/Bundle;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivity(Landroid/content/Intent;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivity(Landroid/content/Intent;Landroid/os/Bundle;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startIntentSender(Landroid/content/IntentSender;Landroid/content/Intent;IIILandroid/os/Bundle;)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1, 2}, EnumSet.of(StarterFlags.QUENCH_PERMISSIONS)));
        this.starters.put(Selector.make("startIntentSender(Landroid/content/IntentSender;Landroid/content/Intent;III)V"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1, 2}, EnumSet.of(StarterFlags.QUENCH_PERMISSIONS)));
        this.starters.put(Selector.make("startService(Landroid/content/Intent;)Landroid/content/ComponentName;"), new StartInfo(tContext, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.SERVICE), new int[]{1}));
        this.starters.put(Selector.make("startActivities([Landroid/content/Intent;)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivities([Landroid/content/Intent;Landroid/os/Bundle;)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivity(Landroid/content/Intent;)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivity(Landroid/content/Intent;Landroid/os/Bundle;)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivityForResult(Landroid/content/Intent;I)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}, EnumSet.of(StarterFlags.CALL_ON_ACTIVITY_RESULT)));
        this.starters.put(Selector.make("startActivityForResult(Landroid/content/Intent;ILandroid/os/Bundle;)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}, EnumSet.of(StarterFlags.CALL_ON_ACTIVITY_RESULT)));
        this.starters.put(Selector.make("startActivityFromChild(Landroid/app/Activity;Landroid/content/Intent;I)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivityFromChild(Landroid/app/Activity;Landroid/content/Intent;ILandroid/os/Bundle;)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        if (doFragments) {
            this.starters.put(Selector.make("startActivityFromFragment(Landroid/app/Fragment;Landroid/content/Intent;I)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
            this.starters.put(Selector.make("startActivityFromFragment(Landroid/app/Fragment;Landroid/content/Intent;ILandroid/os/Bundle;)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        }
        this.starters.put(Selector.make("startActivityIfNeeded(Landroid/content/Intent;I)Z"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startActivityIfNeeded(Landroid/content/Intent;ILandroid/os/Bundle;)Z"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startIntentSender(Landroid/content/IntentSender;Landroid/content/Intent;IIILandroid/os/Bundle;)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1, 2}, EnumSet.of(StarterFlags.QUENCH_PERMISSIONS)));
        this.starters.put(Selector.make("startIntentSender(Landroid/content/IntentSender;Landroid/content/Intent;III)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1, 2}, EnumSet.of(StarterFlags.QUENCH_PERMISSIONS)));
        this.starters.put(Selector.make("startIntentSenderForResult(Landroid/content/IntentSender;ILandroid/content/Intent;IIILandroid/os/Bundle;)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1, 2}, EnumSet.of(StarterFlags.CALL_ON_ACTIVITY_RESULT, StarterFlags.QUENCH_PERMISSIONS)));
        this.starters.put(Selector.make("startIntentSenderForResult(Landroid/content/IntentSender;ILandroid/content/Intent;III)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1, 2}, EnumSet.of(StarterFlags.CALL_ON_ACTIVITY_RESULT, StarterFlags.QUENCH_PERMISSIONS)));
        this.starters.put(Selector.make("startIntentSenderFromChild(Landroid/app/Activity;Landroid/content/IntentSender;ILandroid/content/Intent;III)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1, 2}, EnumSet.of(StarterFlags.QUENCH_PERMISSIONS)));
        this.starters.put(Selector.make("startIntentSenderFromChild(Landroid/app/Activity;Landroid/content/IntentSender;ILandroid/content/Intent;IIILandroid/os/Bundle;)V"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1, 2}, EnumSet.of(StarterFlags.QUENCH_PERMISSIONS)));
        this.starters.put(Selector.make("startNextMatchingActivity(Landroid/content/Intent;)Z"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        this.starters.put(Selector.make("startNextMatchingActivity(Landroid/content/Intent;Landroid/os/Bundle;)Z"), new StartInfo(tActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        if (doFragments) {
            TypeReference tFragmentActivity = TypeReference.find(searchLoader, "Landroid/support/v4/app/FragmentActivity");
            this.starters.put(Selector.make("startActivityForResult(Landroid/content/Intent;I)Z"), new StartInfo(tFragmentActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}, EnumSet.of(StarterFlags.CALL_ON_ACTIVITY_RESULT)));
            this.starters.put(Selector.make("startActivityFromFragment(Landroid/app/Fragment;Landroid/content/Intent;I)Z"), new StartInfo(tFragmentActivity, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), EnumSet.of(AndroidComponent.ACTIVITY), new int[]{1}));
        }
    }

    public static class StartInfo {
        private final Set<Intent.IntentType> targetAccuracy;
        private final Set<AndroidComponent> componentType;
        private final int[] relevantParameters;
        private final Set<StarterFlags> flags;
        private final TypeReference declaringClass;

        StartInfo(TypeReference declaringClass, Set<Intent.IntentType> targetAccuracy, Set<AndroidComponent> componentType, int[] relevantParameters) {
            this(declaringClass, targetAccuracy, componentType, relevantParameters, EnumSet.noneOf(StarterFlags.class));
        }

        StartInfo(TypeReference declaringClass, Set<Intent.IntentType> targetAccuracy, Set<AndroidComponent> componentType, int[] relevantParameters, Set<StarterFlags> flags) {
            this.declaringClass = declaringClass;
            this.targetAccuracy = targetAccuracy;
            this.componentType = componentType;
            this.relevantParameters = relevantParameters;
            this.flags = flags;
        }

        public static StartInfo makeContextFree(AndroidComponent component) {
            Set<AndroidComponent> compo = component == null ? Collections.emptySet() : EnumSet.of(component);
            return new StartInfo(null, EnumSet.of(Intent.IntentType.UNKNOWN_TARGET), compo, new int[0], EnumSet.of(StarterFlags.CONTEXT_FREE));
        }

        public void setContextFree() {
            this.flags.add(StarterFlags.CONTEXT_FREE);
        }

        public int[] getRelevant() {
            return this.relevantParameters;
        }

        public TypeReference getDeclaringClass() {
            return this.declaringClass;
        }

        public Set<StarterFlags> getFlags() {
            return this.flags;
        }

        public Set<AndroidComponent> getComponentsPossible() {
            return this.componentType;
        }

        public boolean isSystemService() {
            return this.targetAccuracy.contains((Object)Intent.IntentType.SYSTEM_SERVICE);
        }

        public String toString() {
            return "<StartInfo flags=" + this.flags + " to possible " + this.componentType + " with allowed Accuracies of " + this.targetAccuracy + "/>";
        }
    }

    public static enum StarterFlags {
        CALL_ON_ACTIVITY_RESULT,
        QUENCH_PERMISSIONS,
        CONTEXT_FREE;

    }
}

