/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.ssa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dalvik.classLoader.DexCFG;
import com.ibm.wala.dalvik.classLoader.DexIMethod;
import com.ibm.wala.dalvik.classLoader.Literal;
import com.ibm.wala.dalvik.dex.instructions.ArrayFill;
import com.ibm.wala.dalvik.dex.instructions.ArrayGet;
import com.ibm.wala.dalvik.dex.instructions.ArrayLength;
import com.ibm.wala.dalvik.dex.instructions.ArrayPut;
import com.ibm.wala.dalvik.dex.instructions.BinaryLiteralOperation;
import com.ibm.wala.dalvik.dex.instructions.BinaryOperation;
import com.ibm.wala.dalvik.dex.instructions.Branch;
import com.ibm.wala.dalvik.dex.instructions.CheckCast;
import com.ibm.wala.dalvik.dex.instructions.Constant;
import com.ibm.wala.dalvik.dex.instructions.GetField;
import com.ibm.wala.dalvik.dex.instructions.Goto;
import com.ibm.wala.dalvik.dex.instructions.InstanceOf;
import com.ibm.wala.dalvik.dex.instructions.Instruction;
import com.ibm.wala.dalvik.dex.instructions.Invoke;
import com.ibm.wala.dalvik.dex.instructions.Monitor;
import com.ibm.wala.dalvik.dex.instructions.New;
import com.ibm.wala.dalvik.dex.instructions.NewArray;
import com.ibm.wala.dalvik.dex.instructions.NewArrayFilled;
import com.ibm.wala.dalvik.dex.instructions.PutField;
import com.ibm.wala.dalvik.dex.instructions.Return;
import com.ibm.wala.dalvik.dex.instructions.Switch;
import com.ibm.wala.dalvik.dex.instructions.Throw;
import com.ibm.wala.dalvik.dex.instructions.UnaryOperation;
import com.ibm.wala.dalvik.ssa.AbstractIntRegisterMachine;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.PhiValue;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPiNodePolicy;
import com.ibm.wala.ssa.ShrikeIndirectionData;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.dominators.Dominators;
import com.ibm.wala.util.intset.IntPair;
import java.util.Arrays;
import java.util.Iterator;

public class DexSSABuilder
extends AbstractIntRegisterMachine {
    private final DexIMethod method;
    private final SymbolTable symbolTable;
    private final SSA2LocalMap localMap;
    private final SSAInstructionFactory insts;
    private final ShrikeIndirectionData shrikeIndirections;

    public static DexSSABuilder make(DexIMethod method, SSACFG cfg, DexCFG scfg, SSAInstruction[] instructions, SymbolTable symbolTable, boolean buildLocalMap, SSAPiNodePolicy piNodePolicy) throws IllegalArgumentException {
        if (scfg == null) {
            throw new IllegalArgumentException("scfg == null");
        }
        return new DexSSABuilder(method, cfg, scfg, instructions, symbolTable, buildLocalMap, piNodePolicy);
    }

    private DexSSABuilder(DexIMethod method, SSACFG cfg, DexCFG scfg, SSAInstruction[] instructions, SymbolTable symbolTable, boolean buildLocalMap, SSAPiNodePolicy piNodePolicy) {
        super(scfg);
        this.localMap = buildLocalMap ? new SSA2LocalMap(scfg, instructions.length, cfg.getNumberOfNodes(), method.getMaxLocals()) : null;
        this.init(new SymbolTableMeeter(cfg, scfg), new SymbolicPropagator(scfg, instructions, cfg, piNodePolicy));
        this.method = method;
        this.symbolTable = symbolTable;
        this.insts = method.getDeclaringClass().getClassLoader().getInstructionFactory();
        this.shrikeIndirections = new ShrikeIndirectionData(instructions.length);
        assert (cfg != null) : "Null CFG";
    }

    @Override
    protected void initializeVariables() {
        AbstractIntRegisterMachine.MachineState entryState = this.getEntryState();
        int parameterNumber = 0;
        int local = this.method.getMaxLocals() - this.method.getNumberOfParameterRegisters() - 1 - 2;
        entryState.allocateLocals();
        for (int i = 0; i < this.method.getNumberOfParameters(); ++i) {
            ++local;
            TypeReference t = this.method.getParameterType(i);
            if (t == null) continue;
            int symbol = this.symbolTable.getParameter(parameterNumber++);
            entryState.setLocal(local, symbol);
            if (!t.equals(TypeReference.Double) && !t.equals(TypeReference.Long)) continue;
            entryState.setLocal(++local, symbol);
        }
    }

    public void build() {
        try {
            this.solve();
            if (this.localMap != null) {
                this.localMap.finishLocalMap(this);
            }
        }
        catch (AssertionError e) {
            System.err.println("When handling method " + this.method.getReference());
            ((Throwable)((Object)e)).printStackTrace();
        }
    }

    public SSA2LocalMap getLocalMap() {
        return this.localMap;
    }

    public ShrikeIndirectionData getIndirectionData() {
        return this.shrikeIndirections;
    }

    private static class SSA2LocalMap
    implements IR.SSA2LocalMap {
        private final DexCFG dexCFG;
        private final IntPair[] localStoreMap;
        private final int[][] block2LocalState;
        private final int maxLocals;

        SSA2LocalMap(DexCFG dexCfg, int nInstructions, int nBlocks, int maxLocals) {
            this.dexCFG = dexCfg;
            this.localStoreMap = new IntPair[nInstructions];
            this.block2LocalState = new int[nBlocks][];
            this.maxLocals = maxLocals;
        }

        void startRange(int pc, int localNumber, int valueNumber) {
            int max = ((DexIMethod)this.dexCFG.getMethod()).getMaxLocals();
            if (localNumber >= max) assert (false) : "invalid local " + localNumber + '>' + max;
            this.localStoreMap[pc] = new IntPair(valueNumber, localNumber);
        }

        private void finishLocalMap(DexSSABuilder builder) {
            for (DexCFG.BasicBlock bb : this.dexCFG) {
                AbstractIntRegisterMachine.MachineState S = builder.getIn(bb);
                int number = bb.getNumber();
                this.block2LocalState[number] = S.getLocals();
            }
        }

        @Override
        public String[] getLocalNames(int index, int vn) {
            try {
                if (!this.dexCFG.getMethod().hasLocalVariableTable()) {
                    return null;
                }
                int[] localNumbers = this.findLocalsForValueNumber(index, vn);
                if (localNumbers == null) {
                    return null;
                }
                DexIMethod m3 = this.dexCFG.getDexMethod();
                String[] result = new String[localNumbers.length];
                for (int i = 0; i < localNumbers.length; ++i) {
                    result[i] = m3.getLocalVariableName(m3.getBytecodeIndex(index), localNumbers[i]);
                }
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
                return null;
            }
        }

        private int[] findLocalsForValueNumber(int pc, int vn) {
            DexCFG.BasicBlock bb = this.dexCFG.getBlockForInstruction(pc);
            int firstInstruction = bb.getFirstInstructionIndex();
            int[] locals = this.block2LocalState[bb.getNumber()];
            if (locals == null) {
                locals = this.allocateNewLocalsArray();
            }
            for (int i = firstInstruction; i <= pc; ++i) {
                if (this.localStoreMap[i] == null) continue;
                IntPair p = this.localStoreMap[i];
                locals[p.getY()] = p.getX();
            }
            return SSA2LocalMap.extractIndices(locals, vn);
        }

        public int[] allocateNewLocalsArray() {
            int[] result = new int[this.maxLocals];
            for (int i = 0; i < this.maxLocals; ++i) {
                result[i] = -1;
            }
            return result;
        }

        private static int[] extractIndices(int[] x, int y) {
            int count = 0;
            for (int element : x) {
                if (element != y) continue;
                ++count;
            }
            if (count == 0) {
                return null;
            }
            int[] result = new int[count];
            int j = 0;
            for (int i = 0; i < x.length; ++i) {
                if (x[i] != y) continue;
                result[j++] = i;
            }
            return result;
        }
    }

    private class SymbolicPropagator
    extends AbstractIntRegisterMachine.BasicRegisterFlowProvider {
        final SSAInstruction[] instructions;
        final DexCFG dexCFG;
        final SSACFG cfg;
        final ClassLoaderReference loader;
        private SSAInstruction[] creators;
        final SSAPiNodePolicy piNodePolicy;

        public SymbolicPropagator(DexCFG dexCFG, SSAInstruction[] instructions, SSACFG cfg, SSAPiNodePolicy piNodePolicy) {
            super(dexCFG);
            this.piNodePolicy = piNodePolicy;
            this.cfg = cfg;
            this.creators = new SSAInstruction[0];
            this.dexCFG = dexCFG;
            this.instructions = instructions;
            this.loader = dexCFG.getMethod().getDeclaringClass().getClassLoader().getReference();
            this.init(new NodeVisitor(cfg), new EdgeVisitor());
        }

        @Override
        public boolean needsEdgeFlow() {
            return this.piNodePolicy != null;
        }

        private void emitInstruction(SSAInstruction s2) {
            this.instructions[this.getCurrentInstructionIndex()] = s2;
            for (int i = 0; i < s2.getNumberOfDefs(); ++i) {
                if (this.creators.length < s2.getDef(i) + 1) {
                    this.creators = Arrays.copyOf(this.creators, 2 * s2.getDef(i));
                }
                assert (s2.getDef(i) != -1) : "invalid def " + i + " for " + s2;
                this.creators[s2.getDef((int)i)] = s2;
            }
        }

        private SSAInstruction getCurrentInstruction() {
            return this.instructions[this.getCurrentInstructionIndex()];
        }

        private int reuseOrCreateDef() {
            if (this.getCurrentInstruction() == null || !this.getCurrentInstruction().hasDef()) {
                return DexSSABuilder.this.symbolTable.newSymbol();
            }
            return this.getCurrentInstruction().getDef();
        }

        private int reuseOrCreateException() {
            if (this.getCurrentInstruction() != null) assert (this.getCurrentInstruction() instanceof SSAInvokeInstruction);
            if (this.getCurrentInstruction() == null) {
                return DexSSABuilder.this.symbolTable.newSymbol();
            }
            SSAInvokeInstruction s2 = (SSAInvokeInstruction)this.getCurrentInstruction();
            return s2.getException();
        }

        private void reuseOrCreatePi(SSAInstruction piCause, int ref) {
            int n = this.getCurrentInstructionIndex();
            SSACFG.BasicBlock bb = this.cfg.getBlockForInstruction(n);
            DexCFG.BasicBlock path = this.getCurrentSuccessor();
            int outNum = this.dexCFG.getNumber(path);
            SSAPiInstruction pi = bb.getPiForRefAndPath(ref, path);
            if (pi == null) {
                pi = DexSSABuilder.this.insts.PiInstruction(this.getCurrentInstructionIndex(), DexSSABuilder.this.symbolTable.newSymbol(), ref, bb.getNumber(), outNum, piCause);
                bb.addPiForRefAndPath(ref, path, pi);
            }
            this.workingState.replaceValue(ref, pi.getDef());
        }

        private void maybeInsertPi(SSAAbstractInvokeInstruction call) {
            Pair<Integer, SSAInstruction> pi;
            if (this.piNodePolicy != null && (pi = this.piNodePolicy.getPi(call, DexSSABuilder.this.symbolTable)) != null) {
                this.reuseOrCreatePi((SSAInstruction)pi.snd, (Integer)pi.fst);
            }
        }

        private void maybeInsertPi(SSAConditionalBranchInstruction cond) {
            Pair<Integer, SSAInstruction> pi;
            if (this.piNodePolicy != null && (pi = this.piNodePolicy.getPi(cond, this.getDef(cond.getUse(0)), this.getDef(cond.getUse(1)), DexSSABuilder.this.symbolTable)) != null) {
                this.reuseOrCreatePi((SSAInstruction)pi.snd, (Integer)pi.fst);
            }
        }

        private SSAInstruction getDef(int vn) {
            if (vn < this.creators.length) {
                return this.creators[vn];
            }
            return null;
        }

        @Override
        public Instruction[] getInstructions() {
            return this.dexCFG.getDexMethod().getDexInstructions();
        }

        class EdgeVisitor
        extends Instruction.Visitor {
            EdgeVisitor() {
            }

            @Override
            public void visitInvoke(Invoke instruction) {
                SymbolicPropagator.this.maybeInsertPi((SSAAbstractInvokeInstruction)SymbolicPropagator.this.getCurrentInstruction());
            }

            @Override
            public void visitBranch(Branch instruction) {
                SymbolicPropagator.this.maybeInsertPi((SSAConditionalBranchInstruction)SymbolicPropagator.this.getCurrentInstruction());
            }
        }

        class NodeVisitor
        extends AbstractIntRegisterMachine.BasicRegisterFlowProvider.BasicRegisterMachineVisitor {
            private final SSACFG cfg;
            private Dominators<ISSABasicBlock> dom = null;

            public NodeVisitor(SSACFG cfg) {
                this.cfg = cfg;
            }

            @Override
            public void visitArrayLength(ArrayLength instruction) {
                int arrayRef = SymbolicPropagator.this.workingState.getLocal(instruction.source);
                int dest = instruction.destination;
                int length = SymbolicPropagator.this.reuseOrCreateDef();
                this.setLocal(dest, length);
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ArrayLengthInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), length, arrayRef));
            }

            @Override
            public void visitArrayGet(ArrayGet instruction) {
                int index = SymbolicPropagator.this.workingState.getLocal(instruction.offset);
                int arrayRef = SymbolicPropagator.this.workingState.getLocal(instruction.array);
                int dest = instruction.destination;
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                this.setLocal(dest, result);
                TypeReference t = instruction.getType();
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ArrayLoadInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, arrayRef, index, t));
            }

            @Override
            public void visitArrayPut(ArrayPut instruction) {
                int value = SymbolicPropagator.this.workingState.getLocal(instruction.source);
                int index = SymbolicPropagator.this.workingState.getLocal(instruction.offset);
                int arrayRef = SymbolicPropagator.this.workingState.getLocal(instruction.array);
                TypeReference t = instruction.getType();
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ArrayStoreInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), arrayRef, index, value, t));
            }

            @Override
            public void visitArrayFill(ArrayFill instruction) {
                Iterator<Number> iae = instruction.getTable().getArrayElements().iterator();
                int i = 0;
                while (iae.hasNext()) {
                    Number ae = iae.next();
                    int index = DexSSABuilder.this.symbolTable.getConstant(i);
                    int arrayRef = SymbolicPropagator.this.workingState.getLocal(instruction.array);
                    TypeReference t = instruction.getType();
                    int value = t.equals(TypeReference.Char) ? DexSSABuilder.this.symbolTable.getConstant((char)ae.intValue()) : (t.equals(TypeReference.Byte) ? DexSSABuilder.this.symbolTable.getConstant(ae.byteValue()) : (t.equals(TypeReference.Short) ? DexSSABuilder.this.symbolTable.getConstant(ae.shortValue()) : (t.equals(TypeReference.Int) ? DexSSABuilder.this.symbolTable.getConstant(ae.intValue()) : (t.equals(TypeReference.Long) ? DexSSABuilder.this.symbolTable.getConstant(ae.longValue()) : (t.equals(TypeReference.Float) ? DexSSABuilder.this.symbolTable.getConstant(ae.floatValue()) : (t.equals(TypeReference.Double) ? DexSSABuilder.this.symbolTable.getConstant(ae.doubleValue()) : (t.equals(TypeReference.Boolean) ? DexSSABuilder.this.symbolTable.getConstant(ae.intValue() != 0) : 0)))))));
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ArrayStoreInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), arrayRef, index, value, t));
                    ++i;
                }
            }

            @Override
            public void visitBinaryOperation(BinaryOperation instruction) {
                int val2 = SymbolicPropagator.this.workingState.getLocal(instruction.oper2);
                int val1 = SymbolicPropagator.this.workingState.getLocal(instruction.oper1);
                int dest = instruction.destination;
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                this.setLocal(dest, result);
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.BinaryOpInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), false, instruction.isUnsigned(), result, val1, val2, !instruction.isFloat()));
            }

            @Override
            public void visitBinaryLiteral(BinaryLiteralOperation instruction) {
                Literal lit = instruction.oper2;
                int val2 = lit instanceof Literal.IntLiteral ? DexSSABuilder.this.symbolTable.getConstant(((Literal.IntLiteral)lit).value) : (lit instanceof Literal.LongLiteral ? DexSSABuilder.this.symbolTable.getConstant(((Literal.LongLiteral)lit).value) : (lit instanceof Literal.DoubleLiteral ? DexSSABuilder.this.symbolTable.getConstant(((Literal.DoubleLiteral)lit).value) : DexSSABuilder.this.symbolTable.getConstant(((Literal.FloatLiteral)lit).value)));
                int val1 = SymbolicPropagator.this.workingState.getLocal(instruction.oper1);
                int dest = instruction.destination;
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                this.setLocal(dest, result);
                try {
                    if (instruction.isSub()) {
                        SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.BinaryOpInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), false, instruction.isUnsigned(), result, val2, val1, !instruction.isFloat()));
                    } else {
                        SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.BinaryOpInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), false, instruction.isUnsigned(), result, val1, val2, !instruction.isFloat()));
                    }
                }
                catch (AssertionError e) {
                    System.err.println("When visiting Instuction " + instruction);
                    throw e;
                }
            }

            protected void setLocal(int dest, int result) {
                assert (result <= DexSSABuilder.this.symbolTable.getMaxValueNumber());
                SymbolicPropagator.this.workingState.setLocal(dest, result);
            }

            @Override
            public void visitCheckCast(CheckCast instruction) {
                int val = SymbolicPropagator.this.workingState.getLocal(instruction.object);
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.workingState.setLocal(instruction.object, result);
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.CheckCastInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, val, instruction.type, instruction.isPEI()));
            }

            @Override
            public void visitBranch(Branch instruction) {
                if (instruction instanceof Branch.BinaryBranch) {
                    Branch.BinaryBranch bbranch = (Branch.BinaryBranch)instruction;
                    int val2 = SymbolicPropagator.this.workingState.getLocal(bbranch.oper2);
                    int val1 = SymbolicPropagator.this.workingState.getLocal(bbranch.oper1);
                    TypeReference t = TypeReference.Int;
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ConditionalBranchInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), t, val1, val2, -1));
                } else if (instruction instanceof Branch.UnaryBranch) {
                    Branch.UnaryBranch ubranch = (Branch.UnaryBranch)instruction;
                    int val2 = DexSSABuilder.this.symbolTable.getConstant(0);
                    int val1 = SymbolicPropagator.this.workingState.getLocal(ubranch.oper1);
                    TypeReference t = TypeReference.Int;
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ConditionalBranchInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), t, val1, val2, -1));
                } else {
                    throw new IllegalArgumentException("instruction is of an unknown subtype of Branch");
                }
            }

            @Override
            public void visitConstant(Constant instruction) {
                int dest = instruction.destination;
                int symbol = 0;
                if (instruction instanceof Constant.ClassConstant) {
                    Constant.ClassConstant constInst = (Constant.ClassConstant)instruction;
                    symbol = SymbolicPropagator.this.reuseOrCreateDef();
                    TypeReference typeRef = constInst.value;
                    SSALoadMetadataInstruction s2 = DexSSABuilder.this.insts.LoadMetadataInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), symbol, TypeReference.JavaLangClass, typeRef);
                    SymbolicPropagator.this.emitInstruction(s2);
                } else if (instruction instanceof Constant.IntConstant) {
                    symbol = DexSSABuilder.this.symbolTable.getConstant(((Constant.IntConstant)instruction).value);
                } else if (instruction instanceof Constant.LongConstant) {
                    symbol = DexSSABuilder.this.symbolTable.getConstant(((Constant.LongConstant)instruction).value);
                } else if (instruction instanceof Constant.StringConstant) {
                    symbol = DexSSABuilder.this.symbolTable.getConstant(((Constant.StringConstant)instruction).value);
                } else {
                    Assertions.UNREACHABLE("unexpected constant instruction " + instruction);
                }
                this.setLocal(dest, symbol);
            }

            @Override
            public void visitGetField(GetField instruction) {
                int dest = instruction.destination;
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                FieldReference f = FieldReference.findOrCreate(SymbolicPropagator.this.loader, instruction.clazzName, instruction.fieldName, instruction.fieldType);
                if (instruction instanceof GetField.GetInstanceField) {
                    int instance = SymbolicPropagator.this.workingState.getLocal(((GetField.GetInstanceField)instruction).instance);
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.GetInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, instance, f));
                } else if (instruction instanceof GetField.GetStaticField) {
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.GetInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, f));
                } else {
                    throw new IllegalArgumentException("unknown subclass of GetField: " + instruction);
                }
                this.setLocal(dest, result);
            }

            @Override
            public void visitGoto(Goto instruction) {
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.GotoInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.destination));
            }

            @Override
            public void visitInstanceof(InstanceOf instruction) {
                int ref = SymbolicPropagator.this.workingState.getLocal(instruction.source);
                int dest = instruction.destination;
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                this.setLocal(dest, result);
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.InstanceofInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, ref, instruction.type));
            }

            @Override
            public void visitInvoke(Invoke instruction) {
                int i;
                Language lang = SymbolicPropagator.this.dexCFG.getMethod().getDeclaringClass().getClassLoader().getLanguage();
                MethodReference m3 = MethodReference.findOrCreate(lang, SymbolicPropagator.this.loader, instruction.clazzName, instruction.methodName, instruction.descriptor);
                IInvokeInstruction.IDispatch code = instruction.getInvocationCode();
                CallSiteReference site = CallSiteReference.make(SymbolicPropagator.this.getCurrentProgramCounter(), m3, code);
                int exc = SymbolicPropagator.this.reuseOrCreateException();
                this.setLocal(SymbolicPropagator.this.dexCFG.getDexMethod().getExceptionReg(), exc);
                int n = instruction.args.length;
                for (int i2 = 0; i2 < m3.getNumberOfParameters(); ++i2) {
                    if (m3.getParameterType(i2) != TypeReference.Double && m3.getParameterType(i2) != TypeReference.Long) continue;
                    --n;
                }
                int[] params = new int[n];
                int arg_i = 0;
                if (n == m3.getNumberOfParameters()) {
                    for (i = 0; i < n; ++i) {
                        params[i] = SymbolicPropagator.this.workingState.getLocal(instruction.args[arg_i]);
                        if (m3.getParameterType(i) == TypeReference.Double || m3.getParameterType(i) == TypeReference.Long) {
                            ++arg_i;
                        }
                        ++arg_i;
                    }
                } else if (n == m3.getNumberOfParameters() + 1) {
                    params[0] = SymbolicPropagator.this.workingState.getLocal(instruction.args[0]);
                    arg_i = 1;
                    for (i = 0; i < n - 1; ++i) {
                        params[i + 1] = SymbolicPropagator.this.workingState.getLocal(instruction.args[arg_i]);
                        if (m3.getParameterType(i) == TypeReference.Double || m3.getParameterType(i) == TypeReference.Long) {
                            ++arg_i;
                        }
                        ++arg_i;
                    }
                } else {
                    throw new UnsupportedOperationException("visitInvoke DexSSABuilder, error");
                }
                if (m3.getReturnType().equals(TypeReference.Void)) {
                    SSAAbstractInvokeInstruction inst = DexSSABuilder.this.insts.InvokeInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), params, exc, site, null);
                    SymbolicPropagator.this.emitInstruction(inst);
                } else {
                    int result = SymbolicPropagator.this.reuseOrCreateDef();
                    assert (result != -1);
                    int dest = SymbolicPropagator.this.dexCFG.getDexMethod().getReturnReg();
                    this.setLocal(dest, result);
                    SSAAbstractInvokeInstruction inst = DexSSABuilder.this.insts.InvokeInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, params, exc, site, null);
                    SymbolicPropagator.this.emitInstruction(inst);
                }
            }

            @Override
            public void visitMonitor(Monitor instruction) {
                int ref = SymbolicPropagator.this.workingState.getLocal(instruction.object);
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.MonitorInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), ref, instruction.enter));
            }

            @Override
            public void visitNew(New instruction) {
                int dest = instruction.destination;
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.NewInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, instruction.newSiteRef));
                this.setLocal(dest, result);
            }

            @Override
            public void visitNewArray(NewArray instruction) {
                int dest = instruction.destination;
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                int[] sizes = new int[instruction.sizes.length];
                for (int i = 0; i < instruction.sizes.length; ++i) {
                    sizes[i] = SymbolicPropagator.this.workingState.getLocal(instruction.sizes[i]);
                }
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.NewInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, instruction.newSiteRef, sizes));
                this.setLocal(dest, result);
            }

            @Override
            public void visitNewArrayFilled(NewArrayFilled instruction) {
                int dest = instruction.destination;
                int result = SymbolicPropagator.this.reuseOrCreateDef();
                int[] sizes = new int[instruction.sizes.length];
                for (int i = 0; i < instruction.sizes.length; ++i) {
                    sizes[i] = DexSSABuilder.this.symbolTable.getConstant(instruction.sizes[i]);
                }
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.NewInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, instruction.newSiteRef, sizes));
                this.setLocal(dest, result);
            }

            @Override
            public void visitPutField(PutField instruction) {
                int value = SymbolicPropagator.this.workingState.getLocal(instruction.source);
                FieldReference f = FieldReference.findOrCreate(SymbolicPropagator.this.loader, instruction.clazzName, instruction.fieldName, instruction.fieldType);
                if (instruction instanceof PutField.PutStaticField) {
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.PutInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), value, f));
                } else if (instruction instanceof PutField.PutInstanceField) {
                    int ref = SymbolicPropagator.this.workingState.getLocal(((PutField.PutInstanceField)instruction).instance);
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.PutInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), ref, value, f));
                } else {
                    throw new IllegalArgumentException("Unknown subclass of PutField: " + instruction);
                }
            }

            @Override
            public void visitReturn(Return instruction) {
                if (instruction instanceof Return.ReturnDouble) {
                    Return.ReturnDouble retD = (Return.ReturnDouble)instruction;
                    int result = SymbolicPropagator.this.workingState.getLocal(retD.source1);
                    boolean isPrimitive = true;
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ReturnInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, isPrimitive));
                } else if (instruction instanceof Return.ReturnSingle) {
                    Return.ReturnSingle retS = (Return.ReturnSingle)instruction;
                    int result = SymbolicPropagator.this.workingState.getLocal(retS.source);
                    boolean isPrimitive = retS.isPrimitive();
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ReturnInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, isPrimitive));
                } else if (instruction instanceof Return.ReturnVoid) {
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ReturnInstruction(SymbolicPropagator.this.getCurrentInstructionIndex()));
                }
            }

            @Override
            public void visitSwitch(Switch instruction) {
                int val = SymbolicPropagator.this.workingState.getLocal(instruction.regA);
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.SwitchInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), val, instruction.getDefaultLabel(), instruction.getCasesAndLabels()));
            }

            private int findRethrowException() {
                int index = SymbolicPropagator.this.getCurrentInstructionIndex();
                SSACFG.BasicBlock bb = this.cfg.getBlockForInstruction(index);
                if (bb.isCatchBlock()) {
                    SSACFG.ExceptionHandlerBasicBlock newBB = (SSACFG.ExceptionHandlerBasicBlock)bb;
                    SSAGetCaughtExceptionInstruction s2 = newBB.getCatchInstruction();
                    return s2.getDef();
                }
                if (this.dom == null) {
                    this.dom = Dominators.make(this.cfg, this.cfg.entry());
                }
                ISSABasicBlock x = bb;
                while (x != null) {
                    if (x.isCatchBlock()) {
                        SSACFG.ExceptionHandlerBasicBlock newBB = (SSACFG.ExceptionHandlerBasicBlock)x;
                        SSAGetCaughtExceptionInstruction s3 = newBB.getCatchInstruction();
                        return s3.getDef();
                    }
                    x = this.dom.getIdom(x);
                }
                return -1;
            }

            @Override
            public void visitThrow(Throw instruction) {
                int throwable = SymbolicPropagator.this.workingState.getLocal(instruction.throwable);
                assert (DexSSABuilder.this.symbolTable.getMaxValueNumber() >= throwable);
                SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ThrowInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), throwable));
            }

            @Override
            public void visitUnaryOperation(UnaryOperation instruction) {
                if (instruction.op == UnaryOperation.OpID.MOVE_EXCEPTION) {
                    int exceptionValue;
                    int idx = SymbolicPropagator.this.getCurrentInstructionIndex();
                    int bbidx = SymbolicPropagator.this.dexCFG.getBlockForInstruction(idx).getNumber();
                    SSACFG.ExceptionHandlerBasicBlock newBB = (SSACFG.ExceptionHandlerBasicBlock)this.cfg.getBasicBlock(bbidx);
                    SSAGetCaughtExceptionInstruction s2 = newBB.getCatchInstruction();
                    if (s2 == null) {
                        exceptionValue = DexSSABuilder.this.symbolTable.newSymbol();
                        s2 = DexSSABuilder.this.insts.GetCaughtExceptionInstruction(newBB.getLastInstructionIndex(), bbidx, exceptionValue);
                        newBB.setCatchInstruction(s2);
                    } else {
                        exceptionValue = s2.getException();
                    }
                    this.setLocal(instruction.destination, exceptionValue);
                    return;
                }
                int val = SymbolicPropagator.this.workingState.getLocal(instruction.source);
                if (instruction.isConversion()) {
                    TypeReference toType;
                    TypeReference fromType;
                    boolean overflows = false;
                    switch (instruction.op) {
                        case DOUBLETOLONG: {
                            fromType = TypeReference.Double;
                            toType = TypeReference.Long;
                            break;
                        }
                        case DOUBLETOFLOAT: {
                            fromType = TypeReference.Double;
                            toType = TypeReference.Float;
                            break;
                        }
                        case INTTOBYTE: {
                            fromType = TypeReference.Int;
                            toType = TypeReference.Byte;
                            break;
                        }
                        case INTTOCHAR: {
                            fromType = TypeReference.Int;
                            toType = TypeReference.Char;
                            break;
                        }
                        case INTTOSHORT: {
                            fromType = TypeReference.Int;
                            toType = TypeReference.Short;
                            break;
                        }
                        case DOUBLETOINT: {
                            fromType = TypeReference.Double;
                            toType = TypeReference.Int;
                            break;
                        }
                        case FLOATTODOUBLE: {
                            fromType = TypeReference.Float;
                            toType = TypeReference.Double;
                            break;
                        }
                        case FLOATTOLONG: {
                            fromType = TypeReference.Float;
                            toType = TypeReference.Long;
                            break;
                        }
                        case FLOATTOINT: {
                            fromType = TypeReference.Float;
                            toType = TypeReference.Int;
                            break;
                        }
                        case LONGTODOUBLE: {
                            fromType = TypeReference.Long;
                            toType = TypeReference.Double;
                            break;
                        }
                        case LONGTOFLOAT: {
                            fromType = TypeReference.Long;
                            toType = TypeReference.Float;
                            break;
                        }
                        case LONGTOINT: {
                            fromType = TypeReference.Long;
                            toType = TypeReference.Int;
                            break;
                        }
                        case INTTODOUBLE: {
                            fromType = TypeReference.Int;
                            toType = TypeReference.Double;
                            break;
                        }
                        case INTTOFLOAT: {
                            fromType = TypeReference.Int;
                            toType = TypeReference.Float;
                            break;
                        }
                        case INTTOLONG: {
                            fromType = TypeReference.Int;
                            toType = TypeReference.Long;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unknown conversion type " + (Object)((Object)instruction.op) + " in unary instruction: " + instruction);
                        }
                    }
                    int dest = instruction.destination;
                    int result = SymbolicPropagator.this.reuseOrCreateDef();
                    this.setLocal(dest, result);
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.ConversionInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), result, val, fromType, toType, overflows));
                } else if (instruction.op == UnaryOperation.OpID.MOVE) {
                    this.setLocal(instruction.destination, SymbolicPropagator.this.workingState.getLocal(instruction.source));
                } else if (instruction.op == UnaryOperation.OpID.MOVE_WIDE) {
                    this.setLocal(instruction.destination, SymbolicPropagator.this.workingState.getLocal(instruction.source));
                    if (instruction.source == SymbolicPropagator.this.dexCFG.getDexMethod().getReturnReg()) {
                        this.setLocal(instruction.destination + 1, SymbolicPropagator.this.workingState.getLocal(instruction.source));
                    } else {
                        this.setLocal(instruction.destination + 1, SymbolicPropagator.this.workingState.getLocal(instruction.source + 1));
                    }
                } else {
                    int dest = instruction.destination;
                    int result = SymbolicPropagator.this.reuseOrCreateDef();
                    this.setLocal(dest, result);
                    SymbolicPropagator.this.emitInstruction(DexSSABuilder.this.insts.UnaryOpInstruction(SymbolicPropagator.this.getCurrentInstructionIndex(), instruction.getOperator(), result, val));
                }
            }
        }
    }

    private class SymbolTableMeeter
    implements AbstractIntRegisterMachine.Meeter {
        final SSACFG cfg;
        final DexCFG dexCFG;

        SymbolTableMeeter(SSACFG cfg, DexCFG dexCFG) {
            this.cfg = cfg;
            this.dexCFG = dexCFG;
        }

        @Override
        public int meetLocal(int n, int[] rhs, DexCFG.BasicBlock bb) {
            int result;
            if (this.allTheSame(rhs)) {
                for (int rh : rhs) {
                    if (rh == -1) continue;
                    return rh;
                }
                return -1;
            }
            SSACFG.BasicBlock newBB = this.cfg.getNode(this.dexCFG.getNumber(bb));
            if (bb.isExitBlock()) {
                return -1;
            }
            SSAPhiInstruction phi = newBB.getPhiForLocal(n);
            if (phi == null) {
                result = DexSSABuilder.this.symbolTable.newPhi(rhs);
                PhiValue v = DexSSABuilder.this.symbolTable.getPhiValue(result);
                phi = v.getPhiInstruction();
                newBB.addPhiForLocal(n, phi);
            } else {
                result = phi.getDef();
                phi.setValues((int[])rhs.clone());
            }
            return result;
        }

        private boolean allTheSame(int[] rhs) {
            int x = -1;
            int i = 0;
            for (i = 0; i < rhs.length; ++i) {
                if (rhs[i] == -1) continue;
                x = rhs[i];
                break;
            }
            ++i;
            while (i < rhs.length) {
                if (rhs[i] != x && rhs[i] != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

