/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.util;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.DefaultInstantiationBehavior;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.parameters.IInstantiationBehavior;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.structure.AbstractAndroidModel;
import com.ibm.wala.dalvik.ipa.callgraph.androidModel.structure.LoopAndroidModel;
import com.ibm.wala.dalvik.ipa.callgraph.impl.AndroidEntryPoint;
import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.Intent;
import com.ibm.wala.dalvik.util.AndroidComponent;
import com.ibm.wala.dalvik.util.AndroidSettingFactory;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.summaries.VolatileMethodSummary;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.NullProgressMonitor;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.ssa.SSAValueManager;
import com.ibm.wala.util.ssa.TypeSafeInstructionFactory;
import com.ibm.wala.util.strings.StringStuff;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AndroidEntryPointManager
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(AndroidEntryPointManager.class);
    public static AndroidEntryPointManager MANAGER = new AndroidEntryPointManager();
    public static List<AndroidEntryPoint> ENTRIES = new ArrayList<AndroidEntryPoint>();
    private transient IInstantiationBehavior instantiation = null;
    private boolean flatComponents = false;
    private transient MonitorUtil.IProgressMonitor progressMonitor = null;
    private boolean doBootSequence = true;
    private Class<? extends AbstractAndroidModel> abstractAndroidModel = LoopAndroidModel.class;
    private transient String pack = null;
    public final Map<Intent, Intent> overrideIntents = HashMapFactory.make();
    public static final Map<Intent, Intent> DEFAULT_INTENT_OVERRIDES = new HashMap<Intent, Intent>();
    private final transient Map<CallSiteReference, Intent> seenIntentCalls = HashMapFactory.make();
    private boolean allowIntentRerouting = true;
    private static final long serialVersionUID = 8740020131212L;

    public static boolean EPContainAny(AndroidComponent compo) {
        for (AndroidEntryPoint ep : ENTRIES) {
            if (!ep.belongsTo(compo)) continue;
            return true;
        }
        return false;
    }

    private AndroidEntryPointManager() {
    }

    public static void reset() {
        ENTRIES = new ArrayList<AndroidEntryPoint>();
        MANAGER = new AndroidEntryPointManager();
    }

    public static Set<TypeReference> getComponents() {
        if (ENTRIES.isEmpty()) {
            throw new IllegalStateException("No entrypoints loaded yet.");
        }
        HashSet<TypeReference> ret = new HashSet<TypeReference>();
        for (AndroidEntryPoint ep : ENTRIES) {
            TypeReference epClass = ep.getMethod().getDeclaringClass().getReference();
            if (!AndroidComponent.isAndroidComponent(epClass, ep.getClassHierarchy())) continue;
            ret.add(epClass);
        }
        return ret;
    }

    public boolean doFlatComponents() {
        return this.flatComponents;
    }

    public boolean setDoFlatComponents(boolean flatComponents) {
        boolean pre = this.flatComponents;
        this.flatComponents = flatComponents;
        return pre;
    }

    public IInstantiationBehavior getInstantiationBehavior(IClassHierarchy cha) {
        if (this.instantiation == null) {
            this.instantiation = new DefaultInstantiationBehavior(cha);
        }
        return this.instantiation;
    }

    public IInstantiationBehavior setInstantiationBehavior(IInstantiationBehavior instantiation) {
        IInstantiationBehavior prev = this.instantiation;
        this.instantiation = instantiation;
        return prev;
    }

    public MonitorUtil.IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            return new NullProgressMonitor();
        }
        return this.progressMonitor;
    }

    public MonitorUtil.IProgressMonitor setProgressMonitor(MonitorUtil.IProgressMonitor monitor) {
        MonitorUtil.IProgressMonitor prev = this.progressMonitor;
        this.progressMonitor = monitor;
        return prev;
    }

    public boolean getDoBootSequence() {
        return this.doBootSequence;
    }

    public boolean setDoBootSequence(boolean doBootSequence) {
        boolean prev = this.doBootSequence;
        this.doBootSequence = doBootSequence;
        return prev;
    }

    public AbstractAndroidModel makeModelBehavior(VolatileMethodSummary body, TypeSafeInstructionFactory insts, SSAValueManager paramManager, Iterable<? extends Entrypoint> entryPoints) {
        if (this.abstractAndroidModel == null) {
            return new LoopAndroidModel(body, insts, paramManager, entryPoints);
        }
        try {
            Constructor<? extends AbstractAndroidModel> ctor = this.abstractAndroidModel.getDeclaredConstructor(VolatileMethodSummary.class, TypeSafeInstructionFactory.class, SSAValueManager.class, Iterable.class);
            if (ctor == null) {
                throw new IllegalStateException("Canot find the constructor of " + this.abstractAndroidModel);
            }
            return ctor.newInstance(body, insts, paramManager, entryPoints);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public Class<? extends AbstractAndroidModel> getModelBehavior() {
        return this.abstractAndroidModel;
    }

    public void setModelBehavior(Class<? extends AbstractAndroidModel> abstractAndroidModel) {
        if (abstractAndroidModel == null) {
            throw new IllegalArgumentException("abstractAndroidModel may not be null. Use SequentialAndroidModel if no special handling shall be inserted.");
        }
        this.abstractAndroidModel = abstractAndroidModel;
    }

    public void setPackage(String pack) {
        if (pack == null) {
            throw new IllegalArgumentException("Setting the package to null is disallowed.");
        }
        if (!pack.startsWith("L") || pack.contains(".")) {
            pack = StringStuff.deployment2CanonicalTypeString(pack);
        }
        if (this.pack == null) {
            logger.info("Setting the package to {}", (Object)pack);
            this.pack = pack;
        } else if (!this.pack.equals(pack)) {
            throw new IllegalArgumentException("The already set package " + this.pack + " and " + pack + " differ. You can only set pack once.");
        }
    }

    public String getPackage() {
        if (this.pack == null) {
            logger.warn("Returning null as package");
            return null;
        }
        return this.pack;
    }

    public String guessPackage() {
        if (this.pack != null) {
            return this.pack;
        }
        if (ENTRIES.isEmpty()) {
            logger.error("guessPackage() called when no entrypoints had been set");
            return null;
        }
        String first = ENTRIES.get(0).getMethod().getReference().getDeclaringClass().getName().getPackage().toString();
        return first;
    }

    public void registerIntent(Intent intent) {
        if (this.overrideIntents.containsKey(intent)) {
            Intent original = this.overrideIntents.get(intent);
            Intent.IntentType oriType = original.getType();
            Intent.IntentType newType = intent.getType();
            if (newType == Intent.IntentType.UNKNOWN_TARGET && oriType != Intent.IntentType.UNKNOWN_TARGET) {
                throw new IllegalArgumentException("You are lowering information on the Intent-Target of the Intent " + original + " from " + (Object)((Object)oriType) + " to " + (Object)((Object)newType) + ". Use registerIntentForce()If you are sure you want to do this!");
            }
            if (oriType != newType) {
                throw new IllegalArgumentException("You are changing the Intents target to a contradicting one! " + (Object)((Object)newType) + "(new) is incompatible to " + (Object)((Object)oriType) + "(before). On Intent " + intent + ". Use registerIntentForce() if you are sure you want to do this!");
            }
        }
        this.registerIntentForce(intent);
    }

    public void registerIntentForce(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("The given Intent is null");
        }
        logger.info("Register Intent {}", (Object)intent);
        this.overrideIntents.put(intent, intent);
    }

    public void setOverride(Intent from, Intent to) {
        if (from == null) {
            throw new IllegalArgumentException("The Intent given as 'from' is null");
        }
        if (to == null) {
            throw new IllegalArgumentException("The Intent given as 'to' is null");
        }
        if (from.equals(to)) {
            throw new IllegalArgumentException("You cannot override an Intent with itself! If you want to alter Information on an Intent use registerIntent (you may register it multiple times).");
        }
        if (this.overrideIntents.containsKey(from)) {
            Intent source;
            Intent ori = this.overrideIntents.get(from);
            if (ori == from) {
                Intent.IntentType oriType = ori.getType();
                Intent.IntentType newType = from.getType();
                source = newType == Intent.IntentType.UNKNOWN_TARGET && oriType != Intent.IntentType.UNKNOWN_TARGET ? ori : from;
            } else {
                source = from;
            }
            Intent original = this.overrideIntents.get(to);
            Intent.IntentType oriType = original.getType();
            Intent.IntentType newType = to.getType();
            if (newType == Intent.IntentType.UNKNOWN_TARGET && oriType != Intent.IntentType.UNKNOWN_TARGET) {
                throw new IllegalArgumentException("You are lowering information on the Intent-Target of the Intent " + original + " from " + (Object)((Object)oriType) + " to " + (Object)((Object)newType) + ". Use setOverrideForce()If you are sure you want to do this!");
            }
            if (oriType != newType) {
                throw new IllegalArgumentException("You are changing the Intents target to a contradicting one! " + (Object)((Object)newType) + "(new) is incompatible to " + (Object)((Object)oriType) + "(before). On Intent " + to + ". Use setOverrideForce() if you are sure you want to do this!");
            }
            this.setOverrideForce(source, to);
        } else {
            this.setOverrideForce(from, to);
        }
    }

    public void setOverrides(Map<Intent, Intent> overrides) {
        for (Map.Entry<Intent, Intent> entry : overrides.entrySet()) {
            Intent to;
            Intent from = entry.getKey();
            if (from.equals(to = entry.getValue())) {
                this.registerIntent(to);
                continue;
            }
            this.setOverride(from, to);
        }
    }

    public void setOverrideForce(Intent from, Intent to) {
        if (from == null) {
            throw new IllegalArgumentException("The Intent given as 'from' is null");
        }
        if (to == null) {
            throw new IllegalArgumentException("The Intent given as 'to' is null");
        }
        logger.info("Override Intent {} to {}", (Object)from, (Object)to);
        this.overrideIntents.put(from, to);
    }

    public Intent getIntent(Intent intent) {
        if (this.overrideIntents.containsKey(intent)) {
            Intent ret = this.overrideIntents.get(intent);
            while (!ret.equals(intent)) {
                if (!this.overrideIntents.containsKey(intent)) {
                    logger.info("Resolved {} to {}", (Object)intent, (Object)ret);
                    return ret;
                }
                logger.debug("Resolving {} hop over {}", (Object)intent, (Object)ret);
                Intent old = ret;
                if ((ret = this.overrideIntents.get(ret)) != old) continue;
                logger.warn("Malformend Intent-Table, staying with " + ret + " for " + intent);
                return ret;
            }
            ret = this.overrideIntents.get(ret);
            logger.info("Resolved {} to {}", (Object)intent, (Object)ret);
            return ret;
        }
        logger.info("No information on {} hash: {}", (Object)intent, (Object)intent.hashCode());
        for (Intent known : this.overrideIntents.keySet()) {
            logger.debug("Known Intents: {} hash: {}", (Object)known, (Object)known.hashCode());
        }
        return intent;
    }

    public boolean existsIntentFor(TypeName clazz) {
        for (Intent i : this.overrideIntents.keySet()) {
            if (!i.getAction().toString().equals(clazz.toString())) continue;
            return true;
        }
        for (Intent i : this.overrideIntents.values()) {
            if (!i.getAction().toString().equals(clazz.toString())) continue;
            return true;
        }
        return false;
    }

    public void addCallSeen(CallSiteReference from, Intent intent) {
        this.seenIntentCalls.put(from, intent);
    }

    public Map<CallSiteReference, Intent> getSeen() {
        return this.seenIntentCalls;
    }

    public boolean setAllowIntentRerouting(boolean allow) {
        boolean prev = this.allowIntentRerouting;
        this.allowIntentRerouting = allow;
        return prev;
    }

    public boolean isAllowIntentRerouting() {
        return this.allowIntentRerouting;
    }

    static {
        DEFAULT_INTENT_OVERRIDES.put(new AndroidSettingFactory.ExternalIntent("Landroid/intent/action/DIAL"), new AndroidSettingFactory.ExternalIntent("Landroid/intent/action/DIAL"));
    }
}

