/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dalvik.util;

import com.ibm.wala.dalvik.ipa.callgraph.propagation.cfa.Intent;
import com.ibm.wala.dalvik.util.AndroidEntryPointManager;
import com.ibm.wala.dalvik.util.AndroidSettingFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AndroidManifestXMLReader {
    private static final Logger logger = LoggerFactory.getLogger(AndroidSettingFactory.class);
    private static final Stack<Tag> parserStack = new Stack();
    private static final Map<HistoryKey, Stack<Object>> attributesHistory = new HashMap<HistoryKey, Stack<Object>>();

    public AndroidManifestXMLReader(File xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("xmlFile may not be null");
        }
        try (FileInputStream in = new FileInputStream(xmlFile);){
            AndroidManifestXMLReader.readXML(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Exception was thrown");
        }
    }

    public AndroidManifestXMLReader(InputStream xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("xmlFile may not be null");
        }
        try {
            AndroidManifestXMLReader.readXML(xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Exception was thrown");
        }
    }

    private static void readXML(InputStream xml) throws SAXException, IOException, ParserConfigurationException {
        assert (xml != null) : "xmlFile may not be null";
        SAXHandler handler = new SAXHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.newSAXParser().parse(new InputSource(xml), (DefaultHandler)handler);
    }

    static {
        for (Attr attr : Attr.values()) {
            attributesHistory.put(attr, new Stack());
        }
        for (Enum enum_ : Tag.values()) {
            attributesHistory.put((HistoryKey)((Object)enum_), new Stack());
        }
    }

    private static class SAXHandler
    extends DefaultHandler {
        private int unimportantDepth = 0;

        public SAXHandler() {
            parserStack.push(Tag.ROOT);
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            Tag tag = Tag.fromString(qName);
            if (tag == Tag.UNIMPORTANT || this.unimportantDepth > 0) {
                ++this.unimportantDepth;
            } else {
                logger.debug("Handling {} made from {}", (Object)tag, (Object)qName);
                ParserItem handler = tag.getHandler();
                if (handler != null) {
                    handler.enter(attrs);
                }
                parserStack.push(tag);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.unimportantDepth > 0) {
                --this.unimportantDepth;
            } else {
                Tag tag = Tag.fromString(qName);
                ParserItem handler = tag.getHandler();
                if (handler != null) {
                    handler.leave();
                }
            }
        }
    }

    private static class ComponentItem
    extends ParserItem {
        private ComponentItem() {
        }

        @Override
        public void leave() {
            String pack;
            Set<Tag> allowedTags = this.self.getAllowedSubTags();
            HashSet<Intent> overrideTargets = new HashSet<Intent>();
            while (parserStack.peek() != this.self) {
                Tag current = (Tag)parserStack.pop();
                if (allowedTags.contains(current)) {
                    Object oIntent;
                    if (current == Tag.INTENT) {
                        if (((Stack)attributesHistory.get(Tag.INTENT)).isEmpty()) continue;
                        oIntent = ((Stack)attributesHistory.get(Tag.INTENT)).peek();
                        if (oIntent == null) {
                            throw new IllegalStateException("The currently parsed Intent did not push a Valid intent to the Stack! Attributes-Stack for name is: " + attributesHistory.get(Attr.NAME));
                        }
                        if (!(oIntent instanceof Intent)) {
                            throw new IllegalStateException("Unexpected Attribute type for Intent: " + oIntent.getClass().toString());
                        }
                    } else {
                        throw new IllegalStateException("Error in parser implementation");
                    }
                    overrideTargets.add((Intent)oIntent);
                    current.getHandler().popAttributes();
                    continue;
                }
                throw new IllegalStateException("In " + this.self + ": Tag " + current + " not allowed in Context " + parserStack + "\n\tAllowed Tags: " + allowedTags);
            }
            if (attributesHistory.get(Attr.PACKAGE) != null && !((Stack)attributesHistory.get(Attr.PACKAGE)).isEmpty()) {
                pack = (String)((Stack)attributesHistory.get(Attr.PACKAGE)).peek();
            } else {
                logger.warn("Empty Package {}", ((Stack)attributesHistory.get(Attr.PACKAGE)).peek());
                pack = null;
            }
            String name = this.self == Tag.ALIAS ? (String)((Stack)attributesHistory.get(Attr.TARGET)).peek() : (String)((Stack)attributesHistory.get(Attr.NAME)).peek();
            Intent intent = AndroidSettingFactory.intent(pack, name, null);
            logger.info("\tRegister: {}", (Object)intent);
            AndroidEntryPointManager.MANAGER.registerIntent(intent);
            for (Intent ovr : overrideTargets) {
                logger.info("\tOverride: {} --> {}", (Object)ovr, (Object)intent);
                if (ovr.equals(intent)) {
                    AndroidEntryPointManager.MANAGER.registerIntent(intent);
                    continue;
                }
                AndroidEntryPointManager.MANAGER.setOverride(ovr, intent);
            }
        }
    }

    private static class IntentItem
    extends ParserItem {
        private IntentItem() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void leave() {
            EnumSet<Tag> allowedTags = EnumSet.copyOf(this.self.getAllowedSubTags());
            HashSet<String> urls = new HashSet<String>();
            HashSet<String> names = new HashSet<String>();
            while (parserStack.peek() != this.self) {
                Tag current = (Tag)parserStack.pop();
                if (!allowedTags.contains(current)) throw new IllegalStateException("In INTENT: Tag " + current + " not allowed in Context " + parserStack + "\n\tAllowed Tags: " + allowedTags);
                if (current == Tag.ACTION) {
                    Object oName = ((Stack)attributesHistory.get(Attr.NAME)).peek();
                    if (oName == null) {
                        throw new IllegalStateException("The currently parsed Action did not leave the required 'name' Attribute on the Stack! Attributes-Stack for name is: " + attributesHistory.get(Attr.NAME));
                    }
                    if (!(oName instanceof String)) throw new IllegalStateException("Unexpected Attribute type for name: " + oName.getClass().toString());
                    names.add((String)oName);
                } else {
                    if (current != Tag.DATA) throw new IllegalStateException("Error in parser implementation");
                    Object oUrl = ((Stack)attributesHistory.get(Attr.SCHEME)).peek();
                    if (oUrl != null) {
                        if (!(oUrl instanceof String)) throw new IllegalStateException("Unexpected Attribute type for name: " + oUrl.getClass().toString());
                        urls.add((String)oUrl);
                    }
                }
                current.getHandler().popAttributes();
            }
            if (!names.isEmpty()) {
                for (String name : names) {
                    if (urls.isEmpty()) {
                        urls.add(null);
                    }
                    for (String url : urls) {
                        logger.info("New Intent ({}, {})", (Object)name, (Object)url);
                        Intent intent = AndroidSettingFactory.intent(name, url);
                        ((Stack)attributesHistory.get(this.self)).push(intent);
                    }
                }
                return;
            } else {
                logger.warn("specified intent without action - this means that no intents will pass the filter...");
            }
        }
    }

    private static class ManifestItem
    extends ParserItem {
        private ManifestItem() {
        }

        @Override
        public void enter(Attributes saxAttrs) {
            super.enter(saxAttrs);
            AndroidEntryPointManager.MANAGER.setPackage((String)((Stack)attributesHistory.get(Attr.PACKAGE)).peek());
        }
    }

    private static class NoOpItem
    extends ParserItem {
        private NoOpItem() {
        }
    }

    private static class FinalItem
    extends ParserItem {
        private FinalItem() {
        }

        @Override
        public void leave() {
            Set<Tag> subs = this.self.getAllowedSubTags();
            if (subs != null && !subs.isEmpty()) {
                throw new IllegalArgumentException("FinalItem can not be applied to " + this.self + " as it contains sub-tags: " + this.self.getAllowedSubTags());
            }
            if (parserStack.peek() != this.self) {
                throw new IllegalStateException("Topstack is not " + this.self + " which is disallowed for a FinalItem!\nThis is most certainly caused by an implementation mistake on a ParserItem. Stack is:\n\t" + parserStack);
            }
        }
    }

    private static abstract class ParserItem {
        protected Tag self;

        public void setSelf(Tag self) {
            if (this.self != null) {
                throw new IllegalStateException("Self can only be set once!");
            }
            this.self = self;
        }

        public void enter(Attributes saxAttrs) {
            for (Attr relevant : this.self.getRelevantAttributes()) {
                String attr = saxAttrs.getValue(relevant.getName());
                if (attr == null) {
                    attr = saxAttrs.getValue("android:" + relevant.getName());
                }
                ((Stack)attributesHistory.get(relevant)).push(attr);
                logger.debug("Pushing '{}' for {} in {}", attr, relevant, this.self);
            }
        }

        public void popAttributes() {
            for (Attr relevant : this.self.getRelevantAttributes()) {
                try {
                    logger.debug("Popping {} of value {} in {}", relevant, ((Stack)attributesHistory.get(relevant)).peek(), this.self);
                    ((Stack)attributesHistory.get(relevant)).pop();
                }
                catch (EmptyStackException e) {
                    System.err.println(this.self + " failed to pop " + relevant);
                    throw e;
                }
            }
            if (attributesHistory.containsKey(this.self) && attributesHistory.get(this.self) != null && !((Stack)attributesHistory.get(this.self)).isEmpty()) {
                try {
                    ((Stack)attributesHistory.get(this.self)).pop();
                }
                catch (EmptyStackException e) {
                    System.err.println("The Stack for " + this.self + " was Empty when trying to pop");
                    throw e;
                }
            }
        }

        public void leave() {
            while (parserStack.peek() != this.self) {
                Tag subTag;
                Set<Tag> allowedSubTags = this.self.getAllowedSubTags();
                if (allowedSubTags.contains(subTag = (Tag)parserStack.pop())) {
                    if (subTag.getHandler() == null) {
                        throw new IllegalArgumentException("The SubTag " + subTag.toString() + " has no handler!");
                    }
                    subTag.getHandler().popAttributes();
                    logger.debug("New Stack: {}", (Object)parserStack);
                    continue;
                }
                throw new IllegalStateException(subTag + " is not allowed as sub-tag of " + this.self + " in Context:\n\t" + parserStack);
            }
        }
    }

    private static enum Attr implements HistoryKey
    {
        PACKAGE("package"),
        NAME("name"),
        SCHEME("scheme"),
        HOST("host"),
        PATH("path"),
        ENABLED("enabled"),
        TARGET("targetActivity"),
        PROCESS("process"),
        ORDER("initOrder"),
        MIME("mimeType");

        private final String attrName;

        private Attr(String attrName) {
            this.attrName = attrName;
        }

        public boolean isRelevantIn(Tag tag) {
            return tag.isRelevant(this);
        }

        public String getName() {
            return this.attrName;
        }
    }

    private static enum Tag implements HistoryKey
    {
        ROOT("ROOT", new ISubTags(){

            @Override
            public Set<Tag> getSubTags() {
                return EnumSet.of(MANIFEST);
            }
        }, null, NoOpItem.class),
        MANIFEST("manifest", new ISubTags(){

            @Override
            public Set<Tag> getSubTags() {
                return EnumSet.of(APPLICATION);
            }
        }, EnumSet.of(Attr.PACKAGE), ManifestItem.class),
        APPLICATION("application", new ISubTags(){

            @Override
            public Set<Tag> getSubTags() {
                return EnumSet.of(ACTIVITY, SERVICE, RECEIVER, PROVIDER, ALIAS);
            }
        }, Collections.emptySet(), NoOpItem.class),
        ACTIVITY("activity", new ISubTags(){

            @Override
            public Set<Tag> getSubTags() {
                return EnumSet.of(INTENT);
            }
        }, EnumSet.of(Attr.NAME, Attr.ENABLED, Attr.PROCESS), ComponentItem.class),
        ALIAS("activity-alias", new ISubTags(){

            @Override
            public Set<Tag> getSubTags() {
                return EnumSet.of(INTENT);
            }
        }, EnumSet.of(Attr.ENABLED, Attr.TARGET, Attr.NAME), ComponentItem.class),
        SERVICE("service", new ISubTags(){

            @Override
            public Set<Tag> getSubTags() {
                return EnumSet.of(INTENT);
            }
        }, EnumSet.of(Attr.ENABLED, Attr.NAME, Attr.PROCESS), ComponentItem.class),
        RECEIVER("receiver", new ISubTags(){

            @Override
            public Set<Tag> getSubTags() {
                return EnumSet.of(INTENT);
            }
        }, EnumSet.of(Attr.ENABLED, Attr.NAME, Attr.PROCESS), ComponentItem.class),
        PROVIDER("provider", new ISubTags(){

            @Override
            public Set<Tag> getSubTags() {
                return EnumSet.of(INTENT);
            }
        }, EnumSet.of(Attr.ENABLED, Attr.ORDER, Attr.NAME, Attr.PROCESS), ComponentItem.class),
        INTENT("intent-filter", new ISubTags(){

            @Override
            public Set<Tag> getSubTags() {
                return EnumSet.of(ACTION, DATA);
            }
        }, Collections.emptySet(), IntentItem.class),
        ACTION("action", Collections::emptySet, EnumSet.of(Attr.NAME), FinalItem.class),
        DATA("data", Collections::emptySet, EnumSet.of(Attr.SCHEME, Attr.HOST, Attr.PATH, Attr.MIME), FinalItem.class),
        UNIMPORTANT("UNIMPORTANT", null, Collections.emptySet(), null);

        private final String tagName;
        private final Set<Attr> relevantAttributes;
        private final ISubTags allowedSubTagsHolder;
        private final ParserItem item;
        private Set<Tag> allowedSubTags;
        private static final Map<String, Tag> reverseMap;

        private Tag(String tagName, ISubTags allowedSubTags, Set<Attr> relevant, Class<? extends ParserItem> item) {
            this.tagName = tagName;
            this.relevantAttributes = relevant;
            this.allowedSubTagsHolder = allowedSubTags;
            if (item != null) {
                try {
                    this.item = item.newInstance();
                    this.item.setSelf(this);
                }
                catch (InstantiationException e) {
                    e.getCause().printStackTrace();
                    throw new IllegalStateException("InstantiationException was thrown");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    if (e.getCause() != null) {
                        e.getCause().printStackTrace();
                    }
                    throw new IllegalStateException("IllegalAccessException was thrown");
                }
            } else {
                this.item = null;
            }
        }

        public ParserItem getHandler() {
            if (this.item == null) {
                System.err.println("Requested non existing handler for: " + this.toString());
            }
            return this.item;
        }

        public Set<Tag> getAllowedSubTags() {
            if (this.allowedSubTagsHolder == null) {
                return null;
            }
            if (this.allowedSubTags == null) {
                this.allowedSubTags = this.allowedSubTagsHolder.getSubTags();
            }
            return Collections.unmodifiableSet(this.allowedSubTags);
        }

        public Set<Attr> getRelevantAttributes() {
            return Collections.unmodifiableSet(this.relevantAttributes);
        }

        public boolean isRelevant(Attr attr) {
            return this.relevantAttributes.contains(attr);
        }

        public boolean isRelevant() {
            return this != UNIMPORTANT;
        }

        public static Tag fromString(String tag) {
            tag = tag.toLowerCase();
            return reverseMap.getOrDefault(tag, UNIMPORTANT);
        }

        public String getName() {
            return this.tagName;
        }

        static {
            reverseMap = new HashMap<String, Tag>();
            for (Tag tag : Tag.values()) {
                reverseMap.put(tag.tagName, tag);
            }
        }
    }

    private static interface HistoryKey {
    }

    private static interface ISubTags {
        public Set<Tag> getSubTags();
    }
}

