/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.IFDS;

import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.SparseIntSet;

public class CallFlowEdges {
    private final SparseVector<IBinaryNaturalRelation> edges = new SparseVector(1, 1.1f);
    private final SparseVector<IntSet> identityEdges = new SparseVector(1, 1.1f);

    public void addCallEdge(int c, int d1, int d2) {
        if (d1 == d2) {
            BimodalMutableIntSet s2 = (BimodalMutableIntSet)this.identityEdges.get(d1);
            if (s2 == null) {
                s2 = new BimodalMutableIntSet();
                this.identityEdges.set(d1, s2);
            }
            s2.add(c);
        } else {
            IBinaryNaturalRelation R = this.edges.get(d2);
            if (R == null) {
                R = new BasicNaturalRelation(new byte[]{1}, 1);
                this.edges.set(d2, R);
            }
            R.add(c, d1);
        }
    }

    public IntSet getCallFlowSources(int c, int d2) {
        if (c < 0) {
            throw new IllegalArgumentException("invalid c : " + c);
        }
        if (d2 < 0) {
            throw new IllegalArgumentException("invalid d2: " + d2);
        }
        IntSet s2 = this.identityEdges.get(d2);
        IBinaryNaturalRelation R = this.edges.get(d2);
        IntSet result = null;
        if (R == null) {
            if (s2 != null) {
                result = s2.contains(c) ? SparseIntSet.singleton(d2) : null;
            }
        } else if (s2 == null) {
            result = R.getRelated(c);
        } else if (s2.contains(c)) {
            if (R.getRelated(c) == null) {
                result = SparseIntSet.singleton(d2);
            } else {
                result = MutableSparseIntSet.make(R.getRelated(c));
                ((MutableSparseIntSet)result).add(d2);
            }
        } else {
            result = R.getRelated(c);
        }
        return result;
    }

    public IntSet getCallFlowSourceNodes(int d2) {
        IntSet s2 = this.identityEdges.get(d2);
        IBinaryNaturalRelation R = this.edges.get(d2);
        IntSet result = null;
        if (R == null) {
            if (s2 != null) {
                result = s2;
            }
        } else if (s2 == null) {
            result = CallFlowEdges.getDomain(R);
        } else {
            result = MutableSparseIntSet.make(s2);
            ((MutableSparseIntSet)result).addAll(CallFlowEdges.getDomain(R));
        }
        return result;
    }

    private static IntSet getDomain(IBinaryNaturalRelation r) {
        MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
        int maxKeyValue = r.maxKeyValue();
        for (int i = 0; i <= maxKeyValue; ++i) {
            if (r.getRelated(i) == null) continue;
            result.add(i);
        }
        return result;
    }
}

