/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.flowgraph;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.demandpa.flowgraph.AbstractDemandFlowGraph;
import com.ibm.wala.demandpa.flowgraph.AssignGlobalLabel;
import com.ibm.wala.demandpa.flowgraph.AssignLabel;
import com.ibm.wala.demandpa.flowgraph.GetFieldLabel;
import com.ibm.wala.demandpa.flowgraph.NewLabel;
import com.ibm.wala.demandpa.flowgraph.PutFieldLabel;
import com.ibm.wala.demandpa.util.ArrayContents;
import com.ibm.wala.demandpa.util.MemoryAccessMap;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.debug.Assertions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DemandValueFlowGraph
extends AbstractDemandFlowGraph {
    public DemandValueFlowGraph(CallGraph cg, HeapModel heapModel, MemoryAccessMap mam, ClassHierarchy cha) {
        super(cg, heapModel, mam, cha);
    }

    @Override
    protected void addNodesForParameters(CGNode node, IR ir) {
        SymbolTable symbolTable = ir.getSymbolTable();
        int numParams = symbolTable.getNumberOfParameters();
        for (int i = 0; i < numParams; ++i) {
            int parameter = symbolTable.getParameter(i);
            PointerKey paramPk = this.heapModel.getPointerKeyForLocal(node, parameter);
            this.addNode(paramPk);
            this.params.put(paramPk, node);
        }
        PointerKey returnKey = this.heapModel.getPointerKeyForReturnValue(node);
        this.addNode(returnKey);
        this.returns.put(returnKey, node);
        PointerKey exceptionReturnKey = this.heapModel.getPointerKeyForExceptionalReturnValue(node);
        this.addNode(exceptionReturnKey);
        this.returns.put(exceptionReturnKey, node);
    }

    @Override
    protected AbstractDemandFlowGraph.FlowStatementVisitor makeVisitor(CGNode node) {
        return new AllValsStatementVisitor(node);
    }

    private class AllValsStatementVisitor
    extends SSAInstruction.Visitor
    implements AbstractDemandFlowGraph.FlowStatementVisitor {
        protected final CGNode node;
        protected final IR ir;
        private ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;

        public AllValsStatementVisitor(CGNode node) {
            this.node = node;
            this.ir = node.getIR();
            this.symbolTable = this.ir.getSymbolTable();
            assert (this.symbolTable != null);
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            PointerKey result = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            PointerKey arrayRef = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getArrayRef());
            DemandValueFlowGraph.this.addNode(result);
            DemandValueFlowGraph.this.addNode(arrayRef);
            DemandValueFlowGraph.this.addEdge(result, arrayRef, GetFieldLabel.make(ArrayContents.v()));
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            PointerKey value = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getValue());
            PointerKey arrayRef = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getArrayRef());
            DemandValueFlowGraph.this.addNode(value);
            DemandValueFlowGraph.this.addNode(arrayRef);
            DemandValueFlowGraph.this.addEdge(arrayRef, value, PutFieldLabel.make(ArrayContents.v()));
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            HashSet<IClass> types = HashSetFactory.make();
            for (TypeReference t : instruction.getDeclaredResultTypes()) {
                IClass cls = DemandValueFlowGraph.this.cha.lookupClass(t);
                if (cls == null) {
                    return;
                }
                types.add(cls);
            }
            FilteredPointerKey result = DemandValueFlowGraph.this.heapModel.getFilteredPointerKeyForLocal(this.node, instruction.getResult(), new FilteredPointerKey.MultipleClassesFilter(types.toArray(new IClass[0])));
            PointerKey value = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getVal());
            DemandValueFlowGraph.this.addNode(result);
            DemandValueFlowGraph.this.addNode(value);
            DemandValueFlowGraph.this.addEdge(result, value, AssignLabel.noFilter());
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
            if (instruction.returnsVoid()) {
                return;
            }
            PointerKey def = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getResult());
            DemandValueFlowGraph.this.addNode(def);
            PointerKey returnValue = DemandValueFlowGraph.this.heapModel.getPointerKeyForReturnValue(this.node);
            DemandValueFlowGraph.this.addNode(returnValue);
            DemandValueFlowGraph.this.addEdge(returnValue, def, AssignLabel.noFilter());
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            this.visitGetInternal(instruction.getDef(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        protected void visitGetInternal(int lval, int ref, boolean isStatic, FieldReference field) {
            IField f = DemandValueFlowGraph.this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                return;
            }
            PointerKey def = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, lval);
            assert (def != null);
            if (isStatic) {
                PointerKey fKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForStaticField(f);
                DemandValueFlowGraph.this.addNode(def);
                DemandValueFlowGraph.this.addNode(fKey);
                DemandValueFlowGraph.this.addEdge(def, fKey, AssignGlobalLabel.v());
            } else {
                PointerKey refKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, ref);
                DemandValueFlowGraph.this.addNode(def);
                DemandValueFlowGraph.this.addNode(refKey);
                DemandValueFlowGraph.this.addEdge(def, refKey, GetFieldLabel.make(f));
            }
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            this.visitPutInternal(instruction.getVal(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        public void visitPutInternal(int rval, int ref, boolean isStatic, FieldReference field) {
            IField f = DemandValueFlowGraph.this.cg.getClassHierarchy().resolveField(field);
            if (f == null) {
                return;
            }
            PointerKey use = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, rval);
            assert (use != null);
            if (isStatic) {
                PointerKey fKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForStaticField(f);
                DemandValueFlowGraph.this.addNode(use);
                DemandValueFlowGraph.this.addNode(fKey);
                DemandValueFlowGraph.this.addEdge(fKey, use, AssignGlobalLabel.v());
            } else {
                PointerKey refKey = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, ref);
                DemandValueFlowGraph.this.addNode(use);
                DemandValueFlowGraph.this.addNode(refKey);
                DemandValueFlowGraph.this.addEdge(refKey, use, PutFieldLabel.make(f));
            }
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            for (int i = 0; i < instruction.getNumberOfUses(); ++i) {
                PointerKey use = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getUse(i));
                DemandValueFlowGraph.this.addNode(use);
                Set s2 = MapUtil.findOrCreateSet(DemandValueFlowGraph.this.callParams, use);
                s2.add(instruction);
            }
            if (instruction.hasDef()) {
                PointerKey def = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
                DemandValueFlowGraph.this.addNode(def);
                DemandValueFlowGraph.this.callDefs.put(def, instruction);
            }
            PointerKey exc = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getException());
            DemandValueFlowGraph.this.addNode(exc);
            DemandValueFlowGraph.this.callDefs.put(exc, instruction);
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            InstanceKey iKey = DemandValueFlowGraph.this.heapModel.getInstanceKeyForAllocation(this.node, instruction.getNewSite());
            if (iKey == null) {
                return;
            }
            PointerKey def = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            DemandValueFlowGraph.this.addNode(iKey);
            DemandValueFlowGraph.this.addNode(def);
            DemandValueFlowGraph.this.addEdge(def, iKey, NewLabel.v());
            IClass klass = iKey.getConcreteType();
            int dim = 0;
            InstanceKey lastInstance = iKey;
            PointerKey lastVar = def;
            while (klass != null && klass.isArrayClass()) {
                if ((klass = ((ArrayClass)klass).getElementClass()) == null || !klass.isArrayClass()) continue;
                InstanceKey ik = DemandValueFlowGraph.this.heapModel.getInstanceKeyForMultiNewArray(this.node, instruction.getNewSite(), dim);
                PointerKey pk = DemandValueFlowGraph.this.heapModel.getPointerKeyForArrayContents(lastInstance);
                DemandValueFlowGraph.this.addNode(ik);
                DemandValueFlowGraph.this.addNode(pk);
                DemandValueFlowGraph.this.addEdge(pk, ik, NewLabel.v());
                DemandValueFlowGraph.this.addEdge(lastVar, pk, PutFieldLabel.make(ArrayContents.v()));
                lastInstance = ik;
                lastVar = pk;
                ++dim;
            }
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey def = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            Set<IClass> types = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(instruction, this.ir);
            DemandValueFlowGraph.this.addExceptionDefConstraints(this.ir, this.node, peis, def, types);
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
            PointerKey src = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getDef());
            PointerKey dst = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, instruction.getVal());
            DemandValueFlowGraph.this.addNode(src);
            DemandValueFlowGraph.this.addNode(dst);
            DemandValueFlowGraph.this.addEdge(src, dst, AssignLabel.noFilter());
        }

        private void handleNonHeapInstruction(SSAInstruction instruction) {
            for (int i = 0; i < instruction.getNumberOfDefs(); ++i) {
                int def = instruction.getDef(i);
                PointerKey defPk = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, def);
                DemandValueFlowGraph.this.addNode(defPk);
                for (int j = 0; j < instruction.getNumberOfUses(); ++j) {
                    int use = instruction.getUse(j);
                    PointerKey usePk = DemandValueFlowGraph.this.heapModel.getPointerKeyForLocal(this.node, use);
                    DemandValueFlowGraph.this.addNode(usePk);
                    DemandValueFlowGraph.this.addEdge(defPk, usePk, AssignLabel.noFilter());
                }
            }
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        @Override
        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        @Override
        public void visitComparison(SSAComparisonInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        @Override
        public void visitConversion(SSAConversionInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        @Override
        public void visitInstanceof(SSAInstanceofInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        @Override
        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
            this.handleNonHeapInstruction(instruction);
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        @Override
        public void setBasicBlock(ISSABasicBlock block) {
            this.basicBlock = block;
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
            Assertions.UNREACHABLE();
        }
    }
}

