/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.util;

import com.ibm.wala.analysis.reflection.InstanceKeyWithNode;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.AbstractLocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.AllocationSiteInNode;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.MultiNewArrayInNode;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ExceptionReturnValueKey;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Set;

public class CallGraphMapUtil {
    public static CGNode mapCGNode(CGNode orig, CallGraph fromCG, CallGraph toCG) throws IllegalArgumentException {
        if (fromCG == null) {
            throw new IllegalArgumentException("fromCG == null");
        }
        if (orig == fromCG.getFakeRootNode()) {
            return toCG.getFakeRootNode();
        }
        MethodReference methodRef = orig.getMethod().getReference();
        if (methodRef.toString().equals("< Primordial, Ljava/lang/Object, clone()Ljava/lang/Object; >")) {
            CGNode ret = toCG.getNode(orig.getMethod(), orig.getContext());
            if (ret == null) {
                System.err.println("WEIRD can't map node " + orig);
            }
            return ret;
        }
        Set<CGNode> nodes = toCG.getNodes(methodRef);
        int size = nodes.size();
        assert (size <= 1);
        return size == 0 ? null : nodes.iterator().next();
    }

    public static InstanceKey mapInstKey(InstanceKey ik, CallGraph fromCG, CallGraph toCG, HeapModel heapModel) throws UnimplementedError, NullPointerException {
        Object ret = null;
        if (ik instanceof InstanceKeyWithNode) {
            CGNode oldCGNode = ((InstanceKeyWithNode)ik).getNode();
            CGNode newCGNode = CallGraphMapUtil.mapCGNode(oldCGNode, fromCG, toCG);
            if (newCGNode == null) {
                return null;
            }
            if (ik instanceof AllocationSiteInNode) {
                if (ik instanceof NormalAllocationInNode) {
                    ret = heapModel.getInstanceKeyForAllocation(newCGNode, ((AllocationSiteInNode)ik).getSite());
                } else if (ik instanceof MultiNewArrayInNode) {
                    MultiNewArrayInNode mnik = (MultiNewArrayInNode)ik;
                    ret = heapModel.getInstanceKeyForMultiNewArray(newCGNode, mnik.getSite(), mnik.getDim());
                } else {
                    Assertions.UNREACHABLE();
                }
            } else {
                Assertions.UNREACHABLE();
            }
        } else {
            if (ik instanceof ConcreteTypeKey) {
                return ik;
            }
            Assertions.UNREACHABLE();
        }
        assert (ret != null);
        assert (ret.getClass() == ik.getClass());
        return ret;
    }

    public static PointerKey mapPointerKey(PointerKey pk, CallGraph fromCG, CallGraph toCG, HeapModel heapModel) throws UnimplementedError {
        PointerKey ret = null;
        if (pk instanceof AbstractLocalPointerKey) {
            CGNode oldCGNode = ((AbstractLocalPointerKey)pk).getNode();
            CGNode newCGNode = CallGraphMapUtil.mapCGNode(oldCGNode, fromCG, toCG);
            if (newCGNode == null) {
                return null;
            }
            if (pk instanceof LocalPointerKey) {
                ret = heapModel.getPointerKeyForLocal(newCGNode, ((LocalPointerKey)pk).getValueNumber());
            } else if (pk instanceof ReturnValueKey) {
                ret = pk instanceof ExceptionReturnValueKey ? heapModel.getPointerKeyForExceptionalReturnValue(newCGNode) : heapModel.getPointerKeyForReturnValue(newCGNode);
            } else {
                Assertions.UNREACHABLE();
            }
        } else {
            Assertions.UNREACHABLE();
        }
        assert (ret != null);
        return ret;
    }
}

