/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.examples.analysis.dataflow;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.dataflow.IFDS.ICFGSupergraph;
import com.ibm.wala.dataflow.IFDS.IFlowFunction;
import com.ibm.wala.dataflow.IFDS.IMergeFunction;
import com.ibm.wala.dataflow.IFDS.IPartiallyBalancedFlowFunctions;
import com.ibm.wala.dataflow.IFDS.ISupergraph;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.IdentityFlowFunction;
import com.ibm.wala.dataflow.IFDS.KillEverything;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationProblem;
import com.ibm.wala.dataflow.IFDS.PartiallyBalancedTabulationSolver;
import com.ibm.wala.dataflow.IFDS.PathEdge;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StaticInitializer {
    private final IClassHierarchy cha;
    private final ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> supergraph;
    private final InitializerDomain domain = new InitializerDomain();
    private Map<BasicBlockInContext<IExplodedBasicBlock>, List<IClass>> initialized;

    public final Map<BasicBlockInContext<IExplodedBasicBlock>, List<IClass>> getInitialized() {
        return this.initialized;
    }

    public StaticInitializer(CallGraph cg) {
        this.cha = cg.getClassHierarchy();
        this.supergraph = ICFGSupergraph.make(cg);
    }

    public TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, IClass> analyze() {
        TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, IClass> result;
        block2: {
            PartiallyBalancedTabulationSolver<BasicBlockInContext<IExplodedBasicBlock>, CGNode, IClass> solver = PartiallyBalancedTabulationSolver.createPartiallyBalancedTabulationSolver(new ReachingDefsProblem(), null);
            result = null;
            try {
                result = solver.solve();
            }
            catch (CancelException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return result;
    }

    public ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> getSupergraph() {
        return this.supergraph;
    }

    public TabulationDomain<IClass, BasicBlockInContext<IExplodedBasicBlock>> getDomain() {
        return this.domain;
    }

    private class ReachingDefsProblem
    implements PartiallyBalancedTabulationProblem<BasicBlockInContext<IExplodedBasicBlock>, CGNode, IClass> {
        private final InitializerFlowFunctions flowFunctions;
        private final Collection<PathEdge<BasicBlockInContext<IExplodedBasicBlock>>> initialSeeds;

        private ReachingDefsProblem() {
            this.flowFunctions = new InitializerFlowFunctions(StaticInitializer.this.domain);
            this.initialSeeds = this.collectInitialSeeds();
        }

        @Override
        public BasicBlockInContext<IExplodedBasicBlock> getFakeEntry(BasicBlockInContext<IExplodedBasicBlock> node) {
            CGNode cgNode = node.getNode();
            return this.getFakeEntry(cgNode);
        }

        @Override
        private BasicBlockInContext<IExplodedBasicBlock> getFakeEntry(CGNode cgNode) {
            BasicBlockInContext[] entriesForProcedure = (BasicBlockInContext[])StaticInitializer.this.supergraph.getEntriesForProcedure(cgNode);
            assert (entriesForProcedure.length == 1);
            return entriesForProcedure[0];
        }

        private Collection<PathEdge<BasicBlockInContext<IExplodedBasicBlock>>> collectInitialSeeds() {
            HashSet<PathEdge<BasicBlockInContext<IExplodedBasicBlock>>> result = HashSetFactory.make();
            for (BasicBlockInContext bb : StaticInitializer.this.supergraph) {
                SSAInvokeInstruction invInstr;
                BasicBlockInContext<IExplodedBasicBlock> fakeEntry;
                int factNum;
                IClass fact;
                CGNode cgNode;
                IExplodedBasicBlock ebb = (IExplodedBasicBlock)bb.getDelegate();
                SSAInstruction instruction = ebb.getInstruction();
                if (instruction instanceof SSAPutInstruction) {
                    SSAPutInstruction putInstr = (SSAPutInstruction)instruction;
                    if (!putInstr.isStatic()) continue;
                    cgNode = bb.getNode();
                    fact = StaticInitializer.this.cha.lookupClass(putInstr.getDeclaredField().getDeclaringClass());
                    factNum = StaticInitializer.this.domain.add(fact);
                    fakeEntry = this.getFakeEntry(cgNode);
                    result.add(PathEdge.createPathEdge(fakeEntry, factNum, bb, factNum));
                    continue;
                }
                if (instruction instanceof SSAGetInstruction) {
                    SSAGetInstruction getInstr = (SSAGetInstruction)instruction;
                    if (!getInstr.isStatic()) continue;
                    cgNode = bb.getNode();
                    fact = StaticInitializer.this.cha.lookupClass(getInstr.getDeclaredField().getDeclaringClass());
                    factNum = StaticInitializer.this.domain.add(fact);
                    fakeEntry = this.getFakeEntry(cgNode);
                    result.add(PathEdge.createPathEdge(fakeEntry, factNum, bb, factNum));
                    continue;
                }
                if (instruction instanceof SSANewInstruction) {
                    SSANewInstruction newInstr = (SSANewInstruction)instruction;
                    cgNode = bb.getNode();
                    fact = StaticInitializer.this.cha.lookupClass(newInstr.getConcreteType());
                    factNum = StaticInitializer.this.domain.add(fact);
                    fakeEntry = this.getFakeEntry(cgNode);
                    result.add(PathEdge.createPathEdge(fakeEntry, factNum, bb, factNum));
                    continue;
                }
                if (!(instruction instanceof SSAInvokeInstruction) || !(invInstr = (SSAInvokeInstruction)instruction).isStatic()) continue;
                cgNode = bb.getNode();
                fact = StaticInitializer.this.cha.lookupClass(invInstr.getDeclaredTarget().getDeclaringClass());
                factNum = StaticInitializer.this.domain.add(fact);
                fakeEntry = this.getFakeEntry(cgNode);
                result.add(PathEdge.createPathEdge(fakeEntry, factNum, bb, factNum));
            }
            return result;
        }

        @Override
        public IPartiallyBalancedFlowFunctions<BasicBlockInContext<IExplodedBasicBlock>> getFunctionMap() {
            return this.flowFunctions;
        }

        @Override
        public TabulationDomain<IClass, BasicBlockInContext<IExplodedBasicBlock>> getDomain() {
            return StaticInitializer.this.domain;
        }

        @Override
        public IMergeFunction getMergeFunction() {
            return null;
        }

        @Override
        public ISupergraph<BasicBlockInContext<IExplodedBasicBlock>, CGNode> getSupergraph() {
            return StaticInitializer.this.supergraph;
        }

        @Override
        public Collection<PathEdge<BasicBlockInContext<IExplodedBasicBlock>>> initialSeeds() {
            return this.initialSeeds;
        }
    }

    private class InitializerFlowFunctions
    implements IPartiallyBalancedFlowFunctions<BasicBlockInContext<IExplodedBasicBlock>> {
        private final InitializerDomain domain;

        protected InitializerFlowFunctions(InitializerDomain domain) {
            this.domain = domain;
        }

        @Override
        public IFlowFunction getUnbalancedReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
            return IdentityFlowFunction.identity();
        }

        @Override
        public IUnaryFlowFunction getCallFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest, BasicBlockInContext<IExplodedBasicBlock> ret) {
            return IdentityFlowFunction.identity();
        }

        @Override
        public IUnaryFlowFunction getCallNoneToReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
            return IdentityFlowFunction.identity();
        }

        @Override
        public IUnaryFlowFunction getCallToReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
            return KillEverything.singleton();
        }

        @Override
        public IUnaryFlowFunction getNormalFlowFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
            final IExplodedBasicBlock ebb = src.getDelegate();
            SSAInstruction instruction = ebb.getInstruction();
            if (instruction instanceof SSAPutInstruction) {
                final SSAPutInstruction putInstr = (SSAPutInstruction)instruction;
                if (putInstr.isStatic()) {
                    return new IUnaryFlowFunction(){

                        @Override
                        public IntSet getTargets(int d1) {
                            System.out.println(ebb.toString());
                            System.out.println(d1);
                            int factNum = InitializerFlowFunctions.this.domain.getMappedIndex(StaticInitializer.this.cha.lookupClass(putInstr.getDeclaredField().getDeclaringClass()));
                            System.out.println(factNum);
                            assert (factNum != -1);
                            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
                            result.add(factNum);
                            if (d1 != factNum) {
                                result.add(d1);
                            }
                            return result;
                        }

                        public String toString() {
                            return "Initializer Normal Flow";
                        }
                    };
                }
            } else if (instruction instanceof SSAGetInstruction) {
                final SSAGetInstruction getInstr = (SSAGetInstruction)instruction;
                if (getInstr.isStatic()) {
                    return new IUnaryFlowFunction(){

                        @Override
                        public IntSet getTargets(int d1) {
                            int factNum = InitializerFlowFunctions.this.domain.getMappedIndex(StaticInitializer.this.cha.lookupClass(getInstr.getDeclaredField().getDeclaringClass()));
                            assert (factNum != -1);
                            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
                            result.add(factNum);
                            if (d1 != factNum) {
                                result.add(d1);
                            }
                            return result;
                        }

                        public String toString() {
                            return "Initializer Normal Flow";
                        }
                    };
                }
            } else {
                SSAInvokeInstruction invInstr;
                if (instruction instanceof SSANewInstruction) {
                    final SSANewInstruction newInstr = (SSANewInstruction)instruction;
                    return new IUnaryFlowFunction(){

                        @Override
                        public IntSet getTargets(int d1) {
                            int factNum = InitializerFlowFunctions.this.domain.getMappedIndex(StaticInitializer.this.cha.lookupClass(newInstr.getConcreteType()));
                            assert (factNum != -1);
                            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
                            result.add(factNum);
                            if (d1 != factNum) {
                                result.add(d1);
                            }
                            return result;
                        }

                        public String toString() {
                            return "Initializer Normal Flow";
                        }
                    };
                }
                if (instruction instanceof SSAInvokeInstruction && (invInstr = (SSAInvokeInstruction)instruction).isStatic()) {
                    return new IUnaryFlowFunction(){

                        @Override
                        public IntSet getTargets(int d1) {
                            System.out.println("Invoke!");
                            int factNum = InitializerFlowFunctions.this.domain.getMappedIndex(StaticInitializer.this.cha.lookupClass(invInstr.getDeclaredTarget().getDeclaringClass()));
                            assert (factNum != -1);
                            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
                            result.add(factNum);
                            if (d1 != factNum) {
                                result.add(d1);
                            }
                            return result;
                        }

                        public String toString() {
                            return "Initializer Normal Flow";
                        }
                    };
                }
            }
            return IdentityFlowFunction.identity();
        }

        @Override
        public IFlowFunction getReturnFlowFunction(BasicBlockInContext<IExplodedBasicBlock> call, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
            return IdentityFlowFunction.identity();
        }
    }

    private static class InitializerDomain
    extends MutableMapping<IClass>
    implements TabulationDomain<IClass, BasicBlockInContext<IExplodedBasicBlock>> {
        private static final long serialVersionUID = -1897766113586243833L;

        private InitializerDomain() {
        }

        @Override
        public boolean hasPriorityOver(PathEdge<BasicBlockInContext<IExplodedBasicBlock>> p1, PathEdge<BasicBlockInContext<IExplodedBasicBlock>> p2) {
            return false;
        }
    }
}

